import EventType = cc.Node.EventType;

const {ccclass, property} = cc._decorator;

@ccclass
export default class Helloworld extends cc.Component {

    @property(cc.Node)
    ndTarget: cc.Node = null;

    @property(cc.Label)
    label: cc.Label = null;

    @property
    text: string = 'hello';

    start () {
        // init logic
        this.label.string = this.text;

        this.ndTarget.on(EventType.TOUCH_START, this.ShowTip, this);
        this.ndTarget.on(EventType.TOUCH_MOVE, this.MoveTip, this);
        this.ndTarget.on(EventType.TOUCH_END, this.HideTip, this); // 在目标节点区域内 TOUCH_MOVE 后再抬起就不会触发了，不知道是不是bug…
        this.ndTarget.on(EventType.TOUCH_CANCEL, this.CancelTip, this); // 在目标节点区域内 TOUCH_MOVE 时也会触发这个事件… 不知道为什么…
    }

    private ShowTip () {
        cc.log('down');
        this.label.string = 'down';
    }

    private MoveTip () {
        cc.log('move');
        this.label.string = 'move';
    }

    private HideTip () {
        cc.log('end');
        this.label.string = 'end';
    }

    private CancelTip () {
        cc.log('cancel');
        this.label.string = 'cancel';
    }
}
