(function() {"use strict";var __module = CC_EDITOR ? module : {exports:{}};var __filename = 'preview-scripts/assets/Script/NodeRockingBar.js';var __require = CC_EDITOR ? function (request) {return cc.require(request, require);} : function (request) {return cc.require(request, __filename);};function __define (exports, require, module) {"use strict";
cc._RF.push(module, '3364a1tQz9NQbhMf/mLSHgQ', 'NodeRockingBar', __filename);
// Script/NodeRockingBar.js

"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _dec, _dec2, _class, _desc, _value, _class2, _descriptor, _descriptor2;

function _initDefineProp(target, property, descriptor, context) {
    if (!descriptor) return;
    Object.defineProperty(target, property, {
        enumerable: descriptor.enumerable,
        configurable: descriptor.configurable,
        writable: descriptor.writable,
        value: descriptor.initializer ? descriptor.initializer.call(context) : void 0
    });
}

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
    var desc = {};
    Object['ke' + 'ys'](descriptor).forEach(function (key) {
        desc[key] = descriptor[key];
    });
    desc.enumerable = !!desc.enumerable;
    desc.configurable = !!desc.configurable;

    if ('value' in desc || desc.initializer) {
        desc.writable = true;
    }

    desc = decorators.slice().reverse().reduce(function (desc, decorator) {
        return decorator(target, property, desc) || desc;
    }, desc);

    if (context && desc.initializer !== void 0) {
        desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
        desc.initializer = undefined;
    }

    if (desc.initializer === void 0) {
        Object['define' + 'Property'](target, property, desc);
        desc = null;
    }

    return desc;
}

function _initializerWarningHelper(descriptor, context) {
    throw new Error('Decorating class property failed. Please ensure that transform-class-properties is enabled.');
}

var _cc$_decorator = cc._decorator,
    ccclass = _cc$_decorator.ccclass,
    property = _cc$_decorator.property;
var NodeRockingBar = (_dec = property(cc.Node), _dec2 = property(cc.Node), ccclass(_class = (_class2 = function (_cc$Component) {
    _inherits(NodeRockingBar, _cc$Component);

    function NodeRockingBar() {
        var _ref;

        var _temp, _this, _ret;

        _classCallCheck(this, NodeRockingBar);

        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
        }

        return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = NodeRockingBar.__proto__ || Object.getPrototypeOf(NodeRockingBar)).call.apply(_ref, [this].concat(args))), _this), _initDefineProp(_this, "spr_rockingBg", _descriptor, _this), _initDefineProp(_this, "spr_bar", _descriptor2, _this), _this._radious = null, _this._onCheckedBar = false, _temp), _possibleConstructorReturn(_this, _ret);
    }

    //参数


    //是否点中 spr_bar


    _createClass(NodeRockingBar, [{
        key: "onLoad",
        value: function onLoad() {
            this._radious = this.spr_rockingBg.width / 2;
            //对摇杆进行处理
            var self = this;
            cc.eventManager.addListener({
                event: cc.EventListener.TOUCH_ONE_BY_ONE,
                onTouchBegan: function onTouchBegan(touch, event) {
                    var touchPos = touch.getLocation();
                    if (touchPos.x >= self.spr_bar.x - self.spr_bar.width / 2 && touchPos.x <= self.spr_bar.x + self.spr_bar.width / 2) {
                        if (touchPos.y >= self.spr_bar.y - self.spr_bar.height / 2 && touchPos.y <= self.spr_bar.y + self.spr_bar.height / 2) {
                            self._onCheckedBar = true;
                            self.spr_bar.setPosition(touchPos.x, touchPos.y);
                        }
                    }
                    return true;
                },
                onTouchMoved: function onTouchMoved(touch, event) {
                    var touchPos = touch.getLocation();
                    if (self._onCheckedBar) {
                        self.spr_bar.setPosition(self.getBarPosition(touchPos));
                    }
                },
                onTouchEnded: function onTouchEnded(touch, event) {
                    var touchPos = touch.getLocation();
                    self.spr_bar.setPosition(self.spr_rockingBg.x, self.spr_rockingBg.y);
                    self._onCheckedBar = false;
                }
            }, self.node);
        }
    }, {
        key: "getBarPosition",
        value: function getBarPosition(pos) {
            //相似三角型
            var length = cc.pDistance(pos, this.spr_rockingBg.getPosition());
            if (length >= this._radious) {
                pos.x = (pos.x - this.spr_rockingBg.x) * this._radious / length + this.spr_rockingBg.x;
                pos.y = (pos.y - this.spr_rockingBg.y) * this._radious / length + this.spr_rockingBg.y;
            }
            return pos;
        }

        //返回的是一个方向

    }, {
        key: "getRockingData",
        value: function getRockingData() {
            var posX = this.spr_bar.x - this.spr_rockingBg.x;
            var posY = this.spr_bar.y - this.spr_rockingBg.y;
            if (posX < -5 || posX > 5 || posY < -5 || posX > 5) {
                return cc.p(posX * 4, posY * 4);
            }
            return cc.p(0, 0);
        }
    }]);

    return NodeRockingBar;
}(cc.Component), (_descriptor = _applyDecoratedDescriptor(_class2.prototype, "spr_rockingBg", [_dec], {
    enumerable: true,
    initializer: function initializer() {
        return null;
    }
}), _descriptor2 = _applyDecoratedDescriptor(_class2.prototype, "spr_bar", [_dec2], {
    enumerable: true,
    initializer: function initializer() {
        return null;
    }
})), _class2)) || _class);
exports.default = NodeRockingBar;
module.exports = exports["default"];

cc._RF.pop();
        }
        if (CC_EDITOR) {
            __define(__module.exports, __require, __module);
        }
        else {
            cc.registerModuleFunc(__filename, function () {
                __define(__module.exports, __require, __module);
            });
        }
        })();
        //# sourceMappingURL=NodeRockingBar.js.map
        