// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

const {ccclass, property} = cc._decorator;

@ccclass
export default class NewClass extends cc.Component {
    start () {
        
        this.node.on(cc.Node.EventType.TOUCH_START, ()=>{
            cc.find("Canvas").getComponent("ScartchCardOther")._userEraser = true;
        });
        this.node.on(cc.Node.EventType.TOUCH_END, (event)=>{
            cc.find("Canvas").getComponent("ScartchCardOther")._userEraser = false;
            event.stopPropagation();
        });
        this.node.on(cc.Node.EventType.TOUCH_CANCEL,(event)=>{
            event.stopPropagation();
        })
        this.node.on(cc.Node.EventType.TOUCH_MOVE, this.dragEvent, this);
    }

    dragEvent (event) {
        this.node.setPosition(event.target.parent.convertToNodeSpaceAR(event.getLocation()));
        event.stopPropagation();
    }

    

    // update (dt) {}
}
