const {ccclass, property} = cc._decorator;

@ccclass
export default class NewClass extends cc.Component {

    @property({
        type: cc.Graphics
    })
    myGraphics: cc.Graphics = null;

    @property({
        displayName: "橡皮",
        type: cc.Node
    })
    eraser: cc.Node = null;

    @property({
        // displayName: ""
    })

    _userEraser: boolean = false;

    _drawPos: Array<cc.Vec2> = [];

    onLoad () {
        this.node.on(cc.Node.EventType.TOUCH_MOVE, this._onTouchMoved, this);
        var collider = cc.director.getCollisionManager();
        collider.enabled = true;
        // collider.enabledDebugDraw = true;
    }

    _onTouchMoved (event) {
        var point = event.touch.getLocation();
        point = this.node.convertToNodeSpaceAR(point);
        this._addCircle(point);
    }

    _addCircle (point) {
        if (!this._userEraser) {
            var stencil = this.myGraphics;
            var _newNode = new cc.Node();
            cc.find("Canvas").addChild(_newNode);
            _newNode.addComponent(cc.BoxCollider).size = cc.size(30, 30);
            _newNode.addComponent("Collision");
            _newNode.position = point;
            _newNode.group = "drawLine";
            this._drawPos.push(point);
            stencil.fillColor = new cc.Color(255, 255, 255, 255);
            stencil.rect(point.x, point.y, 30, 30);
            stencil.fill();
        }
    }
}
