cc.Class({
    extends: cc.Component,

    properties: {
        label: {
            default: null,
            type: cc.Label
        },
        // defaults, set visually when attaching this script to the Canvas
        text: 'Hello, World!'
    },

    // use this for initialization
    onLoad: function () {
        for (var c1 = 0; c1 < 15; c1++) {
            var node = new cc.Node("newNode");
            var sprite = node.addComponent(cc.Sprite);
            var anim = node.addComponent(cc.Animation);
        
            var spriteFrames = [];
            for (var i = 0; i < 15; i++) {
                if (i < 9) {
                    spriteFrames[i] = new cc.SpriteFrame(cc.url.raw("Texture/Square/Round01_0" + (i + 1) + ".png"));
                }
                else {
                    spriteFrames[i] = new cc.SpriteFrame(cc.url.raw("Texture/Square/Round01_" + (i + 1) + ".png"));
                }
            }
        
            var animClip = cc.AnimationClip.createWithSpriteFrames(spriteFrames);
            animClip.wrapMode = cc.WrapMode.Loop;
            animClip.sample = 31;
        
            anim.addClip(animClip, "test");
            anim.play("test");
        
            this.node.addChild(node);
            
            var x = Math.floor(c1 / 3);
            var y = Math.floor(c1 % 3);
            node.setPosition(-400 + x * 260, 250 - y * 260);
        }
        
    },

    // called every frame
    update: function (dt) {
        if (dt >= 0.1) {
            cc.log(dt);
            while (1);
        }
    },
});
