cc.Class({
    extends: cc.Component,

    properties: {
        audio: {
            default: null,
            url: cc.AudioClip
        },
        label: {
            default: null,
            type: cc.Label
        },
        // defaults, set visually when attaching this script to the Canvas
        text: 'Hello, World!'
    },

    // use this for initialization
    onLoad: function () {
        this.current = cc.audioEngine.play(this.audio, true, 1);
        this.label.string = this.text;
    },

    // called every frame
    update: function (dt) {

    },

    onSliderChange(newVolume) {
        cc.audioEngine.setVolume(this.current, newVolume.progress);
    },
});
