import IDataModel from "./model/IDataModel";
import AccountModel from "./model/Account/AccountModel";
import SystemModel from "./model/System/SystemModel";
import SettingModel from "./model/Setting/SettingModel";
import { SingletonFactory } from "../utils/SingletonFactory";
import PlayerModel from "./model/PlayerModel";
import SdkModel from "./model/Sdk/SdkModel";
import SdkNativeModel from "./model/Sdk/SdkNativeModel";
import SdkWChatWeb from "./model/Sdk/SdkWChatWeb";
import TakePictureModel from "./model/TakePicture/TakePictureModel";

class GameDataCenter {
    private _tModel: Array<IDataModel> = [];

    account: AccountModel = null;
    setting: SettingModel = null;
    system: SystemModel = null;
    player: PlayerModel = null;
    sdk: SdkModel = null;
    sdknative: SdkNativeModel = null;
    sdkwchatweb: SdkWChatWeb = null;
    takePicture: TakePictureModel = null;

    public static instance

    constructor() {
        GameDataCenter.instance = this;
    }

    newModel<T extends IDataModel>(c: { new(): T }): T {
        let obj = SingletonFactory.getInstance(c);
        this._tModel.push(obj);
        return obj
    }

    clear() {
        this._tModel.forEach(m => {
            m.clear();
        });
    }

    initModule() {
        this.account = this.newModel(AccountModel);
        this.setting = this.newModel(SettingModel);
        this.player = this.newModel(PlayerModel);
        this.sdk = this.newModel(SdkModel);
        this.sdknative = this.newModel(SdkNativeModel);
        this.sdkwchatweb = this.newModel(SdkWChatWeb);
        this.takePicture = this.newModel(TakePictureModel);
    }
}

export default new GameDataCenter();
(window as any).GameDataCenter = GameDataCenter;