import IDataModel from "../IDataModel";
import UIHelp from "../../../logic/ui/UIHelp";
import EventMng from "../../../manager/EventMng";
import { GameEvent } from "../../const/EventConst";
import GameDataCenter from "../../GameDataCenter";
import { Utils } from '../../../utils/Utils';

const KEY_ACCOUNT = 'account';

export default class AccountModel extends IDataModel {
    public jwt: string = null;
    public uid: number = null;
    public yangzhengma: string = "1";
    public stops: number = null;

    constructor() {
        super('account');
    }

    // /**缓存账号到本地 */
    // saveAccount(account: string) {
    //     this.Set(KEY_ACCOUNT, account);
    //     this.Save();
    // }

    // /**从本地读取缓存账号 */
    // getAccount() {
    //     return this.Query(KEY_ACCOUNT, '');
    // }

    /**需要重写 */
    getMessageListeners() {
        return {
            // key为消息名，value为触发函数
            ['register']: (msg) => { this.G2C_LoginSuccess(msg) },
        }
    }

    LoginWx() {
        var sdk = GameDataCenter.sdk;

        //测试数据
        var openid = "456456451271";
        var avatarUrl = "img111";
        var nickName = "test";

        var params = {
            openid: openid,
            headimg: avatarUrl,
            nickname: nickName
        }
        
        this.sendHttpMsg("register",params)
    }

    /**登录成功 */
    G2C_LoginSuccess(msg) {
        this.jwt = msg["data"]["jwt"];
        this.uid = msg["data"]["user"]["id"];
        this.stops = msg["stops"];

        GameDataCenter.player.config = msg["data"]["configs"];
        EventMng.emit(GameEvent.LOGIN_SUCCESS);
    }
}