import IDataModel from "./IDataModel";
import UIHelp from "../../logic/ui/UIHelp";
import EventMng from "../../manager/EventMng";
import { GameEvent } from "../const/EventConst";

const PLAYER_ACCOUNT = 'player';

export default class PlayerModel extends IDataModel {
    public _money: number = 0;
    public _nicheng: string = "";
    public name: string = "";
    public serverTime: number = 0;
    public base: object;
    public isWx: boolean;
    public today: number;
    public createDay: number;
    public id: number;
    public avatarUrl: string;
    public config: object;
    public baseF: object;
    public isrealname: number = 0;

    constructor() {
        super('player');
        this.isWx = cc.sys.platform == cc.sys.WECHAT_GAME;
    }

    initData(user: object){
        this.base = user;
        this.money = Math.floor(Number(user["goods2"]) * 100) / 100;
        this.name = user["username"];
        this.createDay = user["createday"];
        this.id = user["id"];
        this.avatarUrl = user["strings6"];
        this.isrealname = user["goods40"];
    }

    get money(){
        return this._money;
    }

    set money(_money: number){
        if(_money == this._money){
            return;
        }

        this._money = _money;
        EventMng.emit(GameEvent.MONEY_CHANGE);
    }

    get nicheng(){
        return this._nicheng;
    }

    set nicheng(_nicheng: string){
        if(_nicheng == this._nicheng){
            return;
        }

        this._nicheng = _nicheng;
        EventMng.emit(GameEvent.NICHENG_CHANGE);
    }

    /**需要重写 */
    getMessageListeners() {
        return {
            // key为消息名，value为触发函数
            ['getUser']: (msg) => { this.G2C_GetUserSuccess(msg) },
            ['userEdit']: (msg) => { this.G2C_SetUserSuccess(msg) },
            ['realName']: (msg) => { this.G2C_RealNameSuccess(msg) },
        }
    }

    getUser() {
        var params = {
        }
        this.sendHttpMsg("getUser",params)
    }

    G2C_GetUserSuccess(msg) {
        EventMng.emit(GameEvent.GET_USER_SUCCESS);
    }

    setUser(uid:number, name:string, address:string, sex:string, jieshao:string, weixin:string, isshowPh:number, isshowWx:number) {
        var params = {
            uid: uid,
            str5: name,
            str7: address,
            str8: sex,
            str9: jieshao,
            str10: weixin,
            goods50: isshowPh,
            goods51: isshowWx
        }
        this.sendHttpMsg("userEdit",params)
    }

    G2C_SetUserSuccess(msg) {
        EventMng.emit(GameEvent.SET_USER_SUCCESS);
        UIHelp.ShowTips("保存成功");
    }

    sendRealName(uid: number, name: string, idcard: string, img1:string, img2: string, pid: string) {
        var params = {
            uid: uid,
            name: name,
            idCard: idcard,
            img1: img1,
            img2: img2,
            pid: pid
        }
        this.sendHttpMsg("realName",params)
    }

    G2C_RealNameSuccess(msg) {
        EventMng.emit(GameEvent.SEND_REALNAME_SUCCESS);
    }
}