import IDataModel from "../IDataModel";
import EventMng from "../../../manager/EventMng";
import { GameEvent } from "../../const/EventConst";
import GameDataCenter from "../../GameDataCenter";
import { Utils } from '../../../utils/Utils';

export default class SdkNativeModel extends IDataModel {
    public appid: string = "45645645714";
    public secret: string = "111111111";

    constructor() {
        super('sdknativesdk');
    }

    onShareFriendClicked() {
        var self = this
        
        var info: any = {};
        info.link = "http://www.baidu.com"
        info.title = "模版测试分享"
        info.description = "分享一条链接到聊天"
        info.isfried = true

        if (cc.sys.OS_ANDROID == cc.sys.os) {
            jsb.reflection.callStaticMethod("org/cocos2dx/javascript/AppActivity", "shareLink", "(Ljava/lang/String;)V", JSON.stringify(info));
        } else if (cc.sys.OS_IOS == cc.sys.os) {
            jsb.reflection.callStaticMethod("AppController", "shareLink:", JSON.stringify(info));
        }
    }

    onShareQuanClicked() {
        var self = this
        var info: any = {};
        info.link = "http://www.baidu.com"
        info.title = "模版测试分享"
        info.description = "分享一条链接到朋友圈"
        info.typoe = "WXSceneSession"
        info.isfried = false
        if (cc.sys.OS_ANDROID == cc.sys.os) {
            jsb.reflection.callStaticMethod("org/cocos2dx/javascript/AppActivity", "shareLink", "(Ljava/lang/String;)V", JSON.stringify(info));
        } else if (cc.sys.OS_IOS == cc.sys.os) {
            jsb.reflection.callStaticMethod("AppController", "shareLink:", JSON.stringify(info));
        }
    }

    login(){
        var self = this;
        if (cc.sys.OS_ANDROID == cc.sys.os) {
            jsb.reflection.callStaticMethod("org/cocos2dx/javascript/AppActivity", "wxLogin", "()V");
        } else if (cc.sys.OS_IOS == cc.sys.os) {
            jsb.reflection.callStaticMethod("AppController", "wxLogin");
        }
    }

    onCamerClicked(node) {
        var self = this
        Utils.captureScreen(node,function(fullPath){
            var datanative = {
                friend: false,
                imagedata: fullPath,
                imagepath:fullPath,
            }

            if (cc.sys.OS_ANDROID == cc.sys.os) {
                jsb.reflection.callStaticMethod("org/cocos2dx/javascript/AppActivity", "sendImageContent", "(Ljava/lang/String;)V", JSON.stringify(datanative));
            } else if (cc.sys.OS_IOS == cc.sys.os) {
                jsb.reflection.callStaticMethod("AppController", "sendImageContent:", JSON.stringify(datanative));
            }
        })
    }

    getClipbord() {
        var self = this
        let ret
        if (cc.sys.isNative) {
            if (cc.sys.OS_ANDROID == cc.sys.os) {
                console.log("getClipbord 11111111安卓");
                ret = jsb.reflection.callStaticMethod("org/cocos2dx/javascript/AppActivity", "getClipbord", "()Ljava/lang/String;");
                console.log("剪切板："+ret);
            } else if (cc.sys.OS_IOS == cc.sys.os) {
                console.log("getClipbord 11111111ios");
                ret = jsb.reflection.callStaticMethod("AppController", "getClipbord");
                console.log("剪切板："+ret);
            }
        }
    }

    onCopyClicked() {
        var self = this
        var info = "你好么"
        if (cc.sys.OS_ANDROID == cc.sys.os) {
            jsb.reflection.callStaticMethod("org/cocos2dx/javascript/AppActivity", "setClipbord", "(Ljava/lang/String;)V",info);
        } else if (cc.sys.OS_IOS == cc.sys.os) {
            jsb.reflection.callStaticMethod("AppController", "setClipbord:",info)
        }
    }

    onAdClicked() {
        var self = this
        let paydata = {
            "uid":"666666",
            "time":5,
            "reward":50,
            "adSlot":"945101849",//广告位ID
        }

        let payinfo = JSON.stringify(paydata)
        if (cc.sys.OS_ANDROID == cc.sys.os) {
            jsb.reflection.callStaticMethod("org/cocos2dx/javascript/AppActivity", "showAd", "(Ljava/lang/String;)V", payinfo);
        } else if (cc.sys.OS_IOS == cc.sys.os) {
            jsb.reflection.callStaticMethod("AppController", "showAd:", payinfo);
        }
    }
}