// TypeScript file
import IDataModel from "../IDataModel";

export default class SdkWChatWeb extends IDataModel {
    public static _bodyConfig;

    public initWchat(bodyConfigMsg){
        var bodyConfig: BodyConfig = new BodyConfig();
        bodyConfig.appId = bodyConfigMsg.appId || ''; // 必填，公众号的唯一标识
        bodyConfig.debug = false; // 开启调试模式,调用的所有api的返回值会在客户端alert出来
        bodyConfig.timestamp = bodyConfigMsg.timestamp || ''; // 必填，生成签名的时间戳 parseInt(Main.timestamp)
        bodyConfig.nonceStr =  bodyConfigMsg.nonceStr || ''; // 必填，生成签名的随机串 Main.noncestr
        bodyConfig.signature = bodyConfigMsg.signature || ''; // 必填，签名，见附录1 Main.signature
        
        bodyConfig.jsApiList = [
             'getLocation',
             'onMenuShareTimeline', 
             'onMenuShareAppMessage', 
             'onMenuShareQQ',
             'chooseImage',
             'startRecord',
             'stopRecord',
             'onVoiceRecordEnd',
             'uploadVoice',
             'downloadVoice',
             'playVoice',
             'getBrandWCPayRequest'
             
        ] // 必填，需要使用的JS接口列表，所有JS接口列表见附录2
        SdkWChatWeb._bodyConfig = bodyConfig
    }


    public useWChat(type,callback=null,data=null){
        console.log('type:'+type)
        /// 通过config接口注入权限验证配置
        if(wx_web) {
            console.log('SdkWChatWeb._bodyConfig111:'+JSON.stringify(SdkWChatWeb._bodyConfig))
            wx_web.config(SdkWChatWeb._bodyConfig);
            wx_web.ready(function() {
                console.log('ready:'+type)
                switch(type){
                    case 'getLocation' :
                        //callback('我要返回你好')
                        wx_web.getLocation({
                            type: 'wgs84', // 默认为wgs84的gps坐标，如果要返回直接给openLocation用的火星坐标，可传入'gcj02'
                            success: function (res) {
                                var latitude = res.latitude; // 纬度，浮点数，范围为90 ~ -90
                                var longitude = res.longitude; // 经度，浮点数，范围为180 ~ -180。
                                var speed = res.speed; // 速度，以米/每秒计
                                var accuracy = res.accuracy; // 位置精度
                                callback({longitude:longitude,latitude:latitude})
                            }
                        });
                        break;
                    case 'startRecord' :
                        wx_web.startRecord(this);
                        console.log('public useWChat() 开始录音')
                        break;
                    case 'stopRecord' :
                        wx_web.stopRecord({
                            success: function (res) {
                                callback(res)
                            }
                        });
                        break;
                    case 'onVoiceRecordEnd' :
                        wx_web.onVoiceRecordEnd({
                            // 录音时间超过一分钟没有停止的时候会执行 complete 回调
                            complete: function (res) {
                                callback(res)
                            }
                        });
                        break;
                    case 'uploadVoice' :
                        wx_web.uploadVoice({
                            localId: data.localId, // 需要上传的音频的本地ID，由stopRecord接口获得
                            isShowProgressTips: 0, // 默认为1，显示进度提示
                                success: function (res) {
                                // var serverId = res.serverId; // 返回音频的服务器端ID
                                callback(res)
                            }
                        });
                        break;
                    case 'downloadVoice' :
                        wx_web.downloadVoice({
                            serverId: data.serverId, // 需要下载的音频的服务器端ID，由uploadVoice接口获得
                            isShowProgressTips: 0, // 默认为1，显示进度提示
                            success: function (res) {
                                // var localId = res.localId; // 返回音频的本地ID
                                callback(res)
                            }
                        });
                        break;
                    case 'playVoice' :
                        wx_web.playVoice({
                            localId: data.localId // 需要播放的音频的本地ID，由stopRecord接口获得
                        });
                        break;
                    case 'onMenuShareTimeline' :
                        console.log('点击分享按钮')
                        var bodymenuShareTimeline: BodyMenuShareTimeline = new BodyMenuShareTimeline;
                        bodymenuShareTimeline.title = data.title;
                        bodymenuShareTimeline.link = data.link;
                        bodymenuShareTimeline.imgUrl = data.imgUrl;
                        bodymenuShareTimeline.success = function(): void {
                            console.log('分享成功')
                            callback("success")
                        };
                        bodymenuShareTimeline.fail = function(): void {
                            console.log('分享失败')
                        };
                        bodymenuShareTimeline.cancel = function(): void {
                            console.log('取消分享')
                        };
                        wx_web.onMenuShareTimeline(bodymenuShareTimeline);
                        break;
                    case 'onMenuShareAppMessage' :
                        console.log('点击分享按钮')
                        var bodymenuShareAppMessage: BodyMenuShareAppMessage = new BodyMenuShareAppMessage;
                        bodymenuShareAppMessage.title = data.title;
                        bodymenuShareAppMessage.link = data.link;
                        bodymenuShareAppMessage.desc = data.desc;
                        bodymenuShareAppMessage.imgUrl = data.imgUrl;

                        bodymenuShareAppMessage.success = function(): void {
                            console.log('分享成功')
                            callback("success")
                        };
                        bodymenuShareAppMessage.fail = function(): void {
                            console.log('分享失败')
                        };
                        bodymenuShareAppMessage.cancel = function(): void {
                            console.log('取消分享')
                        };
                        wx_web.onMenuShareAppMessage(bodymenuShareAppMessage);
                        break; 
                    case 'getBrandWCPayRequest':
                    console.log("调用支付")
                        console.log(data)
                        wx_web.chooseWXPay({  
                            appId:data.appid,
                            timestamp:data.timestamp,
                            nonceStr:data.noncestr,
                            package:data.package,
                            signType:data.signtype,
                            paySign:data.paysign,
                            success:function(res){
                                callback(res)
                            }
                        })
                        break;                       
                }
            });
            wx_web.error(function(res){
                console.log('_____errrr+:'+res)
                // config信息验证失败会执行error函数，如签名过期导致验证失败，具体错误信息可以打开config的debug模式查看，也可以在返回的res参数中查看，对于SPA可以在这里更新签名。
            });
        }
    }
}