import IDataModel from "../IDataModel";
import UIHelp from "../../../logic/ui/UIHelp";
import EventMng from "../../../manager/EventMng";
import { GameEvent } from "../../const/EventConst";

export default class SettingModel extends IDataModel {
    musicid: any = '';

    constructor() {
        super('setting');
    }

    saveMusic(status) {
        this.Set("music_state", status);
        this.Save();
    }

    getMusic() {
        return this.Query("music_state",true);
    }

    saveEffect(status) {
        this.Set("effect_state", status);
        this.Save();
    }

    getEffect() {
        return this.Query("effect_state",true);
    }

    /**需要重写 */
    getMessageListeners() {
        return {
            // key为消息名，value为触发函数
        }
    }

    playSFX(audioclip=null){
        let effect = this.getEffect();
        if(!effect){
            return
        }

        cc.loader.loadRes("sounds/ui_click", cc.Asset, function(err, ret) {
            if (err) {
                console.log(err);
                return;
            }
            let tem = cc.loader.getRes("sounds/ui_click", cc.Asset);
            audioclip = audioclip || tem
            cc.audioEngine.play(audioclip,false,1);    
        }.bind(this));
    }

    playBGM(audioclip=null){
        var self = this
        let music = this.getMusic();
        if(!music){
            return
        }

        cc.audioEngine.stop(self.musicid)
        cc.loader.loadRes("sounds/bgFight", cc.Asset, function(err, ret) {
            if (err) {
                console.log(err);
                return;
            }
            let tem = cc.loader.getRes("sounds/bgFight", cc.Asset);
            audioclip = audioclip || tem
            self.musicid = cc.audioEngine.play(audioclip,true,1);    
        }.bind(this));
    }

    stopBGM(){
        var self = this
        cc.audioEngine.stop(self.musicid)
    }
}