import UIMng from "../../manager/UIMng";
import UIBase, { UIClass } from "./UIBase";
import { ViewZorder } from "../../data/const/ViewZOrder";
import UITips from "./tips/UITips";
import UIConfirmDialog from "./tips/UIConfirmDialog";
import UILoading from "./loading/UILoading";

/**确定框界面参数 */
export interface DialogParams {
    title: string,
    content: string,
    certainCb?: Function,
    cancelCb?: Function
}

export default class UIHelp {
    public static SetLabel(node: cc.Node, value: string | number) {
        if (typeof value === 'number') {
            value = value.toString();
        } else if (value == undefined) {
            value = "";
        }
        // 文本和富文本只能二选一
        if (node.getComponent(cc.RichText)) {
            let defaultColor = node.color.toHEX('#rrggbb');
            node.getComponent(cc.RichText).string = `<color=${defaultColor}>${value}</c>`;
        } else {
            node.getComponent(cc.Label).string = value;
        }
    }

    public static SetLabelColor(node: cc.Node, color: cc.Color){
        node.getComponent(cc.Label).node.color = color;
    }

    public static GetEditBoxStr(node: cc.Node){
        return node.getComponent(cc.EditBox).string;
    }

    public static SetEditBoxStr(node: cc.Node, str: string){
        return node.getComponent(cc.EditBox).string = str;
    }

    public static SetProgressBar(node: cc.Node, progress: number) {
        if (typeof progress != 'number') {
            return console.log("参数错误");
        }

        node.getComponent(cc.ProgressBar).progress = progress;
    }

    public static CreateSprite(spriteFrame){
        //创建一个新的节点，因为cc.Sprite是组件不能直接挂载到节点上，只能添加到为节点的一个组件
        var node = new cc.Node('myNode')
        //调用新建的node的addComponent函数，会返回一个sprite的对象
        const sprite = node.addComponent(cc.Sprite)
        //给sprite的spriteFrame属性 赋值
        sprite.spriteFrame = spriteFrame

        return node;
    }

    public static SetSpriteFrame(node: cc.Node, dAtlas: cc.SpriteAtlas | string, imgPath: string = ""){
        if(typeof dAtlas === 'string'){
            if(dAtlas.slice(dAtlas.length - 4) == ".png"){
                cc.loader.load(dAtlas, function (err, texture) {
                    if (!err) {
                        var frame = new cc.SpriteFrame(texture);
                        node.getComponent(cc.Sprite).spriteFrame = frame;
                    } else {
                        console.log("加载头像失败");
                    }
                });
            }else{
                cc.loader.load({url: dAtlas, type: 'png'}, function (err, texture) {
                    if (!err) {
                        var frame = new cc.SpriteFrame(texture);
                        node.getComponent(cc.Sprite).spriteFrame = frame;
                    } else {
                        console.log("加载头像失败");
                    }
                });
            }
        }else{
            let framec = dAtlas.getSpriteFrame(imgPath);
            node.getComponent(cc.Sprite).spriteFrame = framec;
        }
    }

    /**按钮灰化，只有注册click事件，才会真正被禁用 */
    public static SetBtnGrayState(node: cc.Node, isGray) {
        let button = node.getComponent(cc.Button);
        if (!button) {
            return;
        }
        button.interactable = !isGray;
        button.enableAutoGrayEffect = isGray;
    }

    public static IsBtnGray(node: cc.Node) {
        let button = node.getComponent(cc.Button);
        if (!button) {
            return false;
        }
        return !button.interactable;
    }

    public static ShowUI<T extends UIBase>(uiClass: UIClass<T>, callback?: Function, ...args: any[]) {
        UIMng.getInstance().openUI(uiClass, ViewZorder.UI, callback, null, ...args);
    }

    public static ShowLoding() {
        cc.find("loding").getComponent("UILoading").showLoding();
    }

    public static CloseLoding() {
        cc.find("loding").getComponent("UILoading").hideLoding();
    }

    public static CloseUI<T extends UIBase>(uiClass: UIClass<T>) {
        UIMng.getInstance().closeUI(uiClass);
    }

    public static IsShowingUI<T extends UIBase>(uiClass: UIClass<T>) {
        return UIMng.getInstance().isShowing(uiClass);
    }

    public static ShowTips(message: string, ...param: any[]) {
        let tipUI = UIMng.getInstance().getUI(UITips) as UITips;
        if (!tipUI) {
            UIMng.getInstance().openUI(UITips, ViewZorder.Tips, (ui) => {
                UIHelp.ShowTips(message);
            });
        } else {
            tipUI.showTip(message);
        }
    }

    public static ShowDialog(data: DialogParams) {
        UIMng.getInstance().openUI(UIConfirmDialog, ViewZorder.Dialog, null, null, data);
    }
}