import auto_endNode from "../../../data/autoui/game/auto_endNode";
import UIBase from "../UIBase";
import UIHelp from "../UIHelp";
import EventMng from "../../../manager/EventMng";
import { GameEvent } from "../../../data/const/EventConst";

const { ccclass, menu, property } = cc._decorator;

@ccclass
@menu("UI/game/UIEndNode")
export default class UIEndNode extends UIBase {
	@property(cc.SpriteAtlas)
	dAtlas: cc.SpriteAtlas = null;
	
	ui: auto_endNode = null;

	protected static prefabUrl = "game/endNode";
	protected static className = "UIEndNode";

	private errnum:number = 0;
	private rightnum:number = 0;
	private defennum:number = 0;
	private type:number = 0;

	onUILoad() {
		this.ui = this.node.addComponent(auto_endNode);
	}

	onShow() {
		this.onRegisterEvent(this.ui.btn_jixuyouxi, this.onJiXu, this);
		this.onRegisterEvent(this.ui.btn_cxks, this.onAgain, this);
		this.onRegisterEvent(this.ui.btn_tuichu, this.onTuiChu, this);
	}

	onHide() {
		this.unRegisterEvent(this.ui.btn_jixuyouxi, this.onJiXu, this);
		this.unRegisterEvent(this.ui.btn_cxks, this.onAgain, this);
		this.unRegisterEvent(this.ui.btn_tuichu, this.onTuiChu, this);
	}

	onStart() {
		var self = this;
		if (this.type == 1) {
			let framec = this.dAtlas.getSpriteFrame("text_zanting");
			this.ui.spr_title_jieshu.getComponent(cc.Sprite).spriteFrame = framec;
			this.ui.btn_cxks.active = false;
			this.ui.btn_jixuyouxi.active = true;
		} else {
			this.updateList(this.defennum);
			let framec = this.dAtlas.getSpriteFrame("text_jieshu");
			this.ui.spr_title_jieshu.getComponent(cc.Sprite).spriteFrame = framec;
			this.ui.btn_cxks.active = true;
			this.ui.btn_jixuyouxi.active = false;
		}
		UIHelp.SetLabel(this.ui.lab_err_num, this.errnum);
		UIHelp.SetLabel(this.ui.lab_right_num, this.rightnum);
		UIHelp.SetLabel(this.ui.lab_defen_num, this.defennum);
		this.initPaiHang();
		this.show_dlg();
	}

	show_dlg() {
		var self = this;
		var mask = this.ui.layout_bg;
		mask.opacity = 0;
        var fin = cc.fadeTo(0.3, 128);
		mask.runAction(fin);
		
		var content = this.ui.spr_bg;
		content.scale = 0;
		var s = cc.scaleTo(0.4, 1).easing(cc.easeBackOut());
		content.runAction(s);
	}

	onInit(params) {
		var self = this;
		this.errnum = params[0];
		this.rightnum = params[1];
		this.defennum = params[2];
		this.type = params[3];
	}
	
	initPaiHang() {
		for (let index = 0; index < 5; index++) {
			var num = cc.sys.localStorage.getItem("paihang"+index);
			let node = this.ui.paimingNode.getChildByName("spr_paiming_"+(index+1)).getChildByName("lab_fenshu");
			UIHelp.SetLabel(node, num);
		}
	}

	updateList(defeng) {
		var num = defeng;
		for (let index = 0; index < 5; index++) {
			let numold = Number(cc.sys.localStorage.getItem("paihang"+index));
			if (numold < num) {
				cc.sys.localStorage.setItem("paihang"+index, num);
				num = numold;
			}
		}
	}

	onJiXu() {
		var self = this;
		EventMng.emit(GameEvent.GAME_JIXU);
		UIHelp.CloseUI(UIEndNode);
	}

	onAgain() {
		var self = this;
		cc.director.loadScene("gameScene");
	}

	onTuiChu() {
		var self = this;
		//cc.game.end();
		cc.director.loadScene("loginScene");
	}

	onClose() {
		UIHelp.CloseUI(UIEndNode);
	}
}