import auto_jinqu from "../../../data/autoui/game/auto_jinqu";
import UIBase from "../UIBase";
import UIHelp from "../UIHelp";
import EventMng from "../../../manager/EventMng";
import { GameEvent } from "../../../data/const/EventConst";

const { ccclass, menu, property } = cc._decorator;

@ccclass
@menu("UI/game/UIJinqu")
export default class UIJinqu extends cc.Component {
    @property(cc.Float)
	speed: number = 5;
	
    @property(cc.Float)
    jiange: number = 200;

	ui: auto_jinqu = null;

	protected static prefabUrl = "game/jinqu";
	protected static className = "UIJinqu";

	private isCreate: boolean = false;

	onUILoad() {
		this.ui = this.node.addComponent(auto_jinqu);
	}

	onShow() {

	}

	onHide() {

	}
    
    update (dt) {
		var self = this;
		var stop = this.node.parent.getComponent("UIGameScene_1").stop;
		if (stop == false) {
			let pos = this.node.position.sub(cc.v3(0,this.speed));
			this.node.setPosition(pos);
	
			if(pos.y <= cc.winSize.height/2-this.jiange && this.isCreate == false) {
				this.isCreate = true;
				EventMng.emit(GameEvent.GAME_ADD_NODE);
			}
	
			if(pos.y <= -(cc.winSize.height/2-this.node.height)) {
				// this.node.parent.getComponent("UIGameScene_1").jifen++;
				// EventMng.emit(GameEvent.GAME_JIFEN);
				this.node.removeFromParent(true);
			}
		}
    }

	start() {
		var self = this;
		this.onInit();
	}

	onInit() {
		var self = this;
		var type = Math.round(Math.random());
		if (type == 1) {
			this.node.setScale(0.5, 0.5);
		}
		var posX = Math.random()*cc.winSize.width - cc.winSize.width/2;
		var posY = cc.winSize.height - cc.winSize.height/2;
		this.node.setPosition(posX, posY)
	}
}