import auto_node from "../../../data/autoui/game/auto_node";
import UIBase from "../UIBase";
import UIHelp from "../UIHelp";
import EventMng from "../../../manager/EventMng";
import { GameEvent } from "../../../data/const/EventConst";
import GameDataCenter from "../../../data/GameDataCenter";

const { ccclass, menu, property } = cc._decorator;

@ccclass
@menu("UI/game/UINode")
export default class UINode extends cc.Component {
	@property(cc.SpriteAtlas)
	dAtlas: cc.SpriteAtlas = null;

    @property(cc.Float)
    nodecnt: number = 3;

	ui: auto_node = null;

	protected static prefabUrl = "game/node";
	protected static className = "UINode";

	private isCreate: boolean = false;
	private gezi: Array<object> = [];
	private sceneNode: cc.Node = null;

	public index: number = 0;

	onLoad() {
		this.ui = this.node.addComponent(auto_node);

		this.ui.node_1.on('touchstart', this.onTouchNode1Start, this);
		this.ui.node_2.on('touchstart', this.onTouchNode2Start, this);
		this.ui.node_3.on('touchstart', this.onTouchNode3Start, this);
	}

	onDestroy() {
		this.ui.node_1.off('touchstart', this.onTouchNode1Start, this);
		this.ui.node_2.off('touchstart', this.onTouchNode2Start, this);
		this.ui.node_3.off('touchstart', this.onTouchNode3Start, this);
	}
    
    update (dt) {
		var self = this;
		var stop = this.sceneNode.getComponent("UIGameScene").stop;
		if (stop == false) {
			let pos = this.node.position.sub(cc.v3(0,this.sceneNode.getComponent("UIGameScene").speed));
			this.node.setPosition(pos);
	
			if(pos.y <= cc.winSize.height/2-this.node.height && this.isCreate == false) {
				this.isCreate = true;
				var isLoop = this.sceneNode.getComponent("UIGameScene").isLoop;
				if (isLoop == false) {
					EventMng.emit(GameEvent.GAME_ADD_NODE);
				} else {
					var list = this.sceneNode.getComponent("UIGameScene").nodeArray;
					var num = (list.length + this.index)%list.length;
					list[num].getComponent("UINode").onInit();
				}
			}
	
			if(pos.y <= -(cc.winSize.height/2+this.node.height)) {
				this.sceneNode.getComponent("UIGameScene").isLoop = true;
			}
		}
    }

	start() {
		var self = this;
		this.sceneNode = this.node.parent.parent;
		this.onInit();
	}

	onInit() {
		var self = this;
		this.gezi = [];
		var zhengque = Math.floor(Math.random()*2.99);
		var zcList = this.sceneNode.getComponent("UIGameScene").zcList;
		var jqList = this.sceneNode.getComponent("UIGameScene").jqList;
		var array = this.node.children;

		this.isCreate = false;
		this.node.setPosition(cc.v2(0,cc.winSize.height/2));
		for (let index = 0; index < array.length; index++) {
			array[index].getComponent(cc.Button).interactable = true;
		}
		this.ui.node_1.on('touchstart', this.onTouchNode1Start, this);
		this.ui.node_2.on('touchstart', this.onTouchNode2Start, this);
		this.ui.node_3.on('touchstart', this.onTouchNode3Start, this);
		for (let index = 0; index < this.nodecnt; index++) {
			if (index == zhengque) {
				//let framec = this.dAtlas.getSpriteFrame("ic_zhengque");
				//this.node.getChildByName(`node_${index+1}`).getComponent(cc.Sprite).spriteFrame = framec;
				let id = Math.round(Math.random()*(zcList.length-1));
				UIHelp.SetLabel(this.node.getChildByName(`node_${index+1}`).getChildByName(`lab_text`),zcList[id]["name"]);
				this.node.getChildByName(`node_${index+1}`).getChildByName(`lab_text`).color = cc.color(255, 0, 0);
				this.node.getChildByName(`node_${index+1}`).getChildByName(`lab_text`).getComponent(cc.LabelOutline).color = cc.color(255, 255, 255);
				this.gezi.push(zcList[id]);
			} else {
				//let framec = this.dAtlas.getSpriteFrame("ic_cuowu");
				//this.node.getChildByName(`node_${index+1}`).getComponent(cc.Sprite).spriteFrame = framec;
				let id = Math.round(Math.random()*(jqList.length-1));
				UIHelp.SetLabel(this.node.getChildByName(`node_${index+1}`).getChildByName(`lab_text`),jqList[id]["name"]);
				this.node.getChildByName(`node_${index+1}`).getChildByName(`lab_text`).color = cc.color(255, 0, 0);
				this.node.getChildByName(`node_${index+1}`).getChildByName(`lab_text`).getComponent(cc.LabelOutline).color = cc.color(255, 255, 255);
				this.gezi.push(jqList[id]);
			}
		}
	}

	onSelect(event, custom) {
		var self = this;
		var speed = this.sceneNode.getComponent("UIGameScene").speed;
		var maxspeed = this.sceneNode.getComponent("UIGameScene").maxspeed;
		var zengsu = this.sceneNode.getComponent("UIGameScene").zengsu;
		var level = this.sceneNode.getComponent("UIGameScene").level;
		var time = this.sceneNode.getComponent("UIGameScene").time;
		var stop = this.sceneNode.getComponent("UIGameScene").stop;
		if (stop == true) { return; }

		GameDataCenter.setting.playSFX();

		var btn = event.target;
		btn.getComponent(cc.Button).interactable = false;
		btn.getChildByName(`lab_text`).color = cc.color(127, 127, 127);
		if (this.gezi[custom-1]["types"] == 1) {
			this.sceneNode.getComponent("UIGameScene").jifen++;
			this.sceneNode.getComponent("UIGameScene").rightnum++;
			this.setAction(btn, "+1");

			if (this.sceneNode.getComponent("UIGameScene").jifen - level >= zengsu && speed < maxspeed && time > 10) {
				this.sceneNode.getComponent("UIGameScene").speed += 0.5;
				this.sceneNode.getComponent("UIGameScene").zengsu ++;
				this.sceneNode.getComponent("UIGameScene").level = this.sceneNode.getComponent("UIGameScene").jifen;
			}
		} else {
			this.sceneNode.getComponent("UIGameScene").errnum++;
			if (this.sceneNode.getComponent("UIGameScene").jifen > 0) {
				this.sceneNode.getComponent("UIGameScene").jifen--;
				this.setAction(btn, "-1");
			}
		}
		EventMng.emit(GameEvent.GAME_JIFEN);
	}

	onTouchNode1Start(event) {
		var self = this;
		this.onSelect(event, 1);
		this.ui.node_1.off('touchstart', this.onTouchNode1Start, this);
	}

	onTouchNode2Start(event) {
		var self = this;
		this.onSelect(event, 2);
		this.ui.node_2.off('touchstart', this.onTouchNode2Start, this);
	}

	onTouchNode3Start(event) {
		var self = this;
		this.onSelect(event, 3);
		this.ui.node_3.off('touchstart', this.onTouchNode3Start, this);
	}

	setAction(node: cc.Node, str: string) {
		var self = this;
		var actnode = node.getChildByName("lab_fenshu");
		UIHelp.SetLabel(actnode, str);
		actnode.opacity = 255;
		actnode.setPosition(cc.v2(0, 100));
		var action1 = cc.moveTo(1, cc.v2(0, 200));
		var action2 = cc.fadeTo(1, 0);
		actnode.runAction(cc.spawn(action1, action2));
	}
}