import auto_Hotupdate from "../../../data/autoui/hotupdate/auto_Hotupdate";
import UIBase from "../UIBase";

const { ccclass, menu, property } = cc._decorator;

@ccclass
@menu("UI/hotupdate/UIHotupdate")
export default class UIHotupdate extends UIBase {
	ui: auto_Hotupdate = null;

	protected static prefabUrl = "hotupdate/Hotupdate";
	protected static className = "UIHotupdate";

	private _storagePath: string;
    private versionCompareHandle: any;
    private _am: any;
	private _updating: boolean = false;
	private manifestUrl:any;

	onUILoad() {
        this.ui = this.node.addComponent(auto_Hotupdate);
        console.log(this.ui)
		cc.loader.loadRes("project", cc.Asset, function(err, ret) {
            if (err) {
                console.log(err);
                return;
            }
            this.manifestUrl = cc.loader.getRes("project", cc.Asset);
			console.log(this.manifestUrl)
			//检查热更新
			this.initUpdateManager();
			this.checkUpdate();
        }.bind(this));
        console.log("Hotupdate onLoad");

        if (!cc.sys.isNative) {
            this.node.active = false
        }else{
        }
	}

	onShow() {
		this.onRegisterEvent(this.ui.btn_confirm, this.btn_update_click, this);
		this.onRegisterEvent(this.ui.btn_cancel, this.btn_cancel_click, this);
		this.onRegisterEvent(this.ui.btn_ok, this.btn_needRestart_click, this);
	}

	onHide() {
		this.unRegisterEvent(this.ui.btn_confirm, this.btn_update_click, this);
		this.unRegisterEvent(this.ui.btn_cancel, this.btn_cancel_click, this);
		this.unRegisterEvent(this.ui.btn_ok, this.btn_needRestart_click, this);
	}

	onStart() {

	}

	onClose() {
	}

	btn_update_click() {
        this.ui.update_tip_start.active = false;
        this.ui.label_tip.active = true;
        this.ui.label_tip.getComponent(cc.Label).string = "发现新的版本准备更新";
        this._updating = false;
        this.hotUpdate();
    }
    btn_cancel_click() {
        // this.update_tip_start.node.active = false;
        console.log("退出游戏代码");
        cc['j2n'].exit();
    }
    btn_needRestart_click() {
        this._am.setEventCallback(null)
        var searchPaths = jsb.fileUtils.getSearchPaths();
        var newPaths = this._am.getLocalManifest().getSearchPaths();
        Array.prototype.unshift(searchPaths, newPaths);
        cc.sys.localStorage.setItem('HotUpdateSearchPaths', JSON.stringify(searchPaths));
        jsb.fileUtils.setSearchPaths(searchPaths);
        cc.audioEngine.stopAll();
        cc.game.restart();
	}
	
    initUpdateManager() {
        if (!cc.sys.isNative) {
            return;
        }
        this._storagePath = ((jsb.fileUtils ? jsb.fileUtils.getWritablePath() : '/') + 'project-remote-asset');
        this.versionCompareHandle = function (versionA, versionB) {
            console.log("本地版本为" + versionA + ', 服务器版本为' + versionB);
            var vA = versionA.split('.');
            var vB = versionB.split('.');
            for (var i = 0; i < vA.length; ++i) {
                var a = parseInt(vA[i]);
                var b = parseInt(vB[i] || 0);
                if (a === b) {
                    continue;
                }
                else {
                    return a - b;
                }
            }
            if (vB.length > vA.length) {
                return -1;
            }
            else {
                return 0;
            }
        };

        this._am = new jsb.AssetsManager('', this._storagePath, this.versionCompareHandle);

        this._am.setVerifyCallback(function (path, asset) {
            var compressed = asset.compressed;

            var expectedMD5 = asset.md5;

            var relativePath = asset.path;

            var size = asset.size;
            if (compressed) {
                console.log("Verification passed : " + relativePath);
                return true;
            }
            else {
                console.log("Verification passed : " + relativePath + ' (' + expectedMD5 + ')');
                return true;
            }
        });
        if (cc.sys.os === cc.sys.OS_ANDROID) {
            this._am.setMaxConcurrentTask(2);
        }
	}
	
	checkUpdate() {
        if (!cc.sys.isNative) {
            return;
        }
        console.log("检测热更新");
        this.ui.label_tip.active = true;
        this.ui.label_tip.getComponent(cc.Label).string = "正在检测更新...";
        if (this._updating) {
            console.log('Checking or updating ...');
            return;
        }
        if (this._am.getState() === jsb.AssetsManager.State.UNINITED) {
            this._am.loadLocalManifest(this.manifestUrl.nativeUrl);
        }
        if (!this._am.getLocalManifest() || !this._am.getLocalManifest().isLoaded()) {
            console.log('Failed to load local manifest ...');
            return;
        }
        // this._checkListener = new jsb.EventListenerAssetsManager(this._am, this.checkCb.bind(this));
        this._am.setEventCallback(this.checkCb.bind(this))
        // cc.eventManager.addListener(this._checkListener, 1);
        this._am.checkUpdate();
        this._updating = true;
	}
	
	checkCb(event) {
        console.log('checkCb Code: ' + event.getEventCode());
        var failed = false;
        switch (event.getEventCode()) {
            case jsb.EventAssetsManager.ERROR_NO_LOCAL_MANIFEST:
                console.log('找不到本地MANIFEST文件');
                failed = true;
                break;
            case jsb.EventAssetsManager.ERROR_DOWNLOAD_MANIFEST:
            case jsb.EventAssetsManager.ERROR_PARSE_MANIFEST:
                console.log('检测热更新失败 无法下载MANIFEST');
                failed = true;
                break;
            case jsb.EventAssetsManager.UPDATE_PROGRESSION://UPDATE_PROGRESSION
                console.log('UPDATE_PROGRESSION');

                break;
            case jsb.EventAssetsManager.ALREADY_UP_TO_DATE://已经是服务器版本
                console.log('已经是最新版本');
                this.ui.label_tip.active = false;
                this.node.active = false
                failed = true;
                break;
            case jsb.EventAssetsManager.NEW_VERSION_FOUND://找到新版本
                failed = true;
                console.log('找到新版本.');
                this.ui.update_tip_start.active = true;
                break;
            default:
                return;
        }
        if (failed == true) {
            this._am.setEventCallback(null)
            console.log("移除检测回调");
        }
	}
	
    hotUpdate() {
        if (this._am && !this._updating) {
            // this._updateListener = new jsb.EventListenerAssetsManager(this._am, this.updateCb.bind(this));
            this._am.setEventCallback(this.updateCb.bind(this))
            // cc.eventManager.addListener(this._updateListener, 1);
            if (this._am.getState() === jsb.AssetsManager.State.UNINITED) {
                this._am.loadLocalManifest(this.manifestUrl.nativeUrl);
            }
            this._am.update();
            this._updating = true;
        }
    }
    conver(limit) {
        var size = "";
        if (limit < 0.1 * 1024) { //如果小于0.1KB转化成B  
            size = limit.toFixed(2) + "B";
        } else if (limit < 0.1 * 1024 * 1024) {//如果小于0.1MB转化成KB  
            size = (limit / 1024).toFixed(2) + "KB";
        } else if (limit < 0.1 * 1024 * 1024 * 1024) { //如果小于0.1GB转化成MB  
            size = (limit / (1024 * 1024)).toFixed(2) + "MB";
        } else { //其他转化成GB  
            size = (limit / (1024 * 1024 * 1024)).toFixed(2) + "GB";
        }

        var sizestr = size + "";
        var len = sizestr.indexOf("\.");
        var dec = sizestr.substr(len + 1, 2);
        if (dec == "00") {//当小数点后为00时 去掉小数部分  
            return sizestr.substring(0, len) + sizestr.substr(len + 3, 2);
        }
        return sizestr;
    }
    updateCb(event) {
        var needRestart = false;
        var failed = false;
        switch (event.getEventCode()) {
            case jsb.EventAssetsManager.ERROR_NO_LOCAL_MANIFEST:
                console.log("No local manifest file found, hot update skipped.");
                failed = true;
                break;
            case jsb.EventAssetsManager.UPDATE_PROGRESSION:
                this.ui.ProgressBar.active = true;
                if (!isNaN(event.getPercent())) {
                    console.log("判断出不为空");
                    this.ui.ProgressBar.getComponent(cc.ProgressBar).progress = (event.getDownloadedFiles() / event.getTotalFiles());
                    this.ui.progresstip.getComponent(cc.Label).string = Math.floor((event.getDownloadedFiles() / event.getTotalFiles()) * 100) + "%";
                    this.ui.label_tip.getComponent(cc.Label).string = "需要下载" + event.getDownloadedFiles() + "/" + event.getTotalFiles() + "个文件共" + this.conver(event.getDownloadedBytes()) + "/" + this.conver(event.getTotalBytes());
                }
                var msg = event.getMessage();
                console.log("msg======", msg);
                break;
            case jsb.EventAssetsManager.ERROR_DOWNLOAD_MANIFEST:
            case jsb.EventAssetsManager.ERROR_PARSE_MANIFEST:
                console.log('Fail to download manifest file, hot update skipped.');
                failed = true;
                break;
            case jsb.EventAssetsManager.ALREADY_UP_TO_DATE:
                console.log('Already up to date with the latest remote version.');
                failed = true;
                break;
            case jsb.EventAssetsManager.UPDATE_FINISHED:
                console.log('Update finished. ' + event.getMessage());
                needRestart = true;
                break;
            case jsb.EventAssetsManager.UPDATE_FAILED:
                console.log('Update failed. ' + event.getMessage());
                break;
            case jsb.EventAssetsManager.ERROR_UPDATING:
                console.log('Asset update error: ' + event.getAssetId() + ', ' + event.getMessage());
                break;
            case jsb.EventAssetsManager.ERROR_DECOMPRESS:
                console.log('Update failed. ' + event.getMessage());
                break;
            default:
                break;
        }

        if (failed) {
            this._am.setEventCallback(null)
            this._updating = false;
        }

        if (needRestart) {
            this.ui.update_tip_finish.active = true;
        }
    }
}