import UIBase from "../UIBase";
import GameDataCenter from "../../../data/GameDataCenter";
import EventMng from "../../../manager/EventMng";
import { GameEvent } from "../../../data/const/EventConst";

const { ccclass, menu, property } = cc._decorator;

@ccclass
@menu("UI/scene/TimerNode")
export default class TimerNode extends UIBase {

	protected static prefabUrl = "";
	protected static className = "TimerNode";

	onUILoad() {
		cc.game.addPersistRootNode(this.node);
	}

	onShow() {
		EventMng.on(GameEvent.LOGIN_SUCCESS, this.createSchedule, this);
	}

	onHide() {
		EventMng.off(GameEvent.LOGIN_SUCCESS, this.createSchedule, this);
	}

	createSchedule(){
		// 以秒为单位的时间间隔
        var interval = 1;
        // 重复次数
        var repeat = cc.macro.REPEAT_FOREVER;
        // 开始延时
        var delay = 0;
        this.schedule(function() {
			// 这里的 this 指向 component
			if(GameDataCenter.player.serverTime){
				GameDataCenter.player.serverTime += 1;
				EventMng.emit(GameEvent.SERVER_TIME_CHANGE);
			}
            
        }, interval, repeat, delay);
	}
}