import auto_gameScene from "../../../data/autoui/scene/auto_gameScene";
import UIBase from "../UIBase";
import UIHelp from "../UIHelp";
import EventMng from "../../../manager/EventMng";
import { GameEvent } from "../../../data/const/EventConst";
import UIEndNode from "../game/UIEndNode"
import GameDataCenter from "../../../data/GameDataCenter";

const { ccclass, menu, property } = cc._decorator;

@ccclass
@menu("UI/scene/UIGameScene")
export default class UIGameScene extends UIBase {
    @property(cc.Prefab)
	nodePrefab: cc.Prefab = null;

	@property(cc.Float)
	time: number = 100;

    @property(cc.Float)
	speed: number = 4;
	
    @property(cc.Float)
	maxspeed: number = 8;
	
    @property(cc.Float)
    zengsu: number = 10;
	
	ui: auto_gameScene = null;

	protected static prefabUrl = "";
	protected static className = "UIGameScene";

	private nodeArray: Array<cc.Node> = [];
    public jifen: number = 0;
    public rightnum: number = 0;
    public errnum: number = 0;
    private isGameEnd: boolean = false;
	private starttime: number = 0;

	public stop: boolean = false;
	public isLoop: boolean = false;
	public jqList: Array<object> = [];
	public zcList: Array<object> = [];
	private level: number = 0;

	onUILoad() {
		this.ui = this.node.addComponent(auto_gameScene);
		let list = require('DangYuanJQCfg')["CfgDangYuan"];
		for (let index in list) {
			var vo = list[index];
			if (vo["types"] == 1) {
				this.zcList.push(vo);
			} else {
				this.jqList.push(vo);
			}
		}
	}

	onShow() {
		this.onRegisterEvent(this.ui.btn_zanting, this.onZanTing, this);

		EventMng.on(GameEvent.GAME_ADD_NODE, this.addNewNode, this);
		EventMng.on(GameEvent.GAME_JIFEN, this.setJiFen, this);
		EventMng.on(GameEvent.GAME_AGAIN, this.onAgain, this);
		EventMng.on(GameEvent.GAME_JIXU, this.onJiXu, this);
	}

	onHide() {
		this.unRegisterEvent(this.ui.btn_zanting, this.onZanTing, this);

		EventMng.off(GameEvent.GAME_ADD_NODE, this.addNewNode, this);
		EventMng.off(GameEvent.GAME_JIFEN, this.setJiFen, this);
		EventMng.off(GameEvent.GAME_AGAIN, this.onAgain, this);
		EventMng.off(GameEvent.GAME_JIXU, this.onJiXu, this);
	}

    onUpdate (dt) {
		var self = this;
		var starttime = this.starttime;
        if (starttime != 0 && this.isGameEnd == false && this.stop == false) {
            var nowtime = Date.parse(String(new Date()))/1000;
            this.time = starttime - nowtime;
			this.setTime(this.time);
            if (this.time <= 0) {
                this.gameEnd(2);
            }
        }
    }

	onStart() {
		var self = this;

		var isEffect = GameDataCenter.setting.getEffect()
		this.ui.toggle_Effect.getComponent(cc.Toggle).isChecked = !isEffect;

		this.jifen = 0;
		this.ui.topNode.zIndex = cc.macro.MAX_ZINDEX;
		this.addNewNode();
		this.starttime = Date.parse(String(new Date()))/1000 + this.time;

		this.ui.toggle_Effect.runAction(this.setAction());
	}

	addNewNode() {
		var self = this;
		let newNode = cc.instantiate(this.nodePrefab);
		this.ui.spr_game_bg.addChild(newNode);
		this.nodeArray.push(newNode);
		newNode.getComponent("UINode").index = this.nodeArray.length;
	}

	setJiFen() {
		var self = this;
		UIHelp.SetLabel(this.ui.lab_fenshu, this.jifen);
	}

	setTime(time) {
		var self = this;
		UIHelp.SetLabel(this.ui.lab_time, time+"s");
	}

    gameEnd(type) {
		var self = this;
		this.stop = true; 
        this.isGameEnd = true;
		UIHelp.ShowUI(UIEndNode, null, this.errnum, this.rightnum, this.jifen,2);
    }

	onAgain() {
		var self = this;
		cc.director.loadScene("gameScene");
	}

	onZanTing() {
		var self = this;
		this.ui.spr_zanting.active = true;
		this.ui.spr_jixu.active = false;
		UIHelp.ShowUI(UIEndNode, null, this.errnum, this.rightnum, this.jifen, 1);
		//cc.director.pause();
		this.stop = true;
	}

	onJiXu() {
		var self = this;
		this.starttime = Date.parse(String(new Date()))/1000 + this.time;
		//cc.director.resume();
		this.stop = false;
		this.ui.spr_zanting.active = false;
		this.ui.spr_jixu.active = true;
	}

	onSelectEffect() {
		var self = this;
		var isEffect = !(this.ui.toggle_Effect.getComponent(cc.Toggle).isChecked);
		GameDataCenter.setting.saveEffect(isEffect);
	}

	private setAction() {
		var self = this;
		var time = 5; //旋转时间
		var action1 = cc.rotateTo(time, 180);
		var action2 = cc.rotateTo(time, 360);
        return cc.repeatForever(cc.sequence(action1, action2));
	}

	onClose() {
		UIHelp.CloseUI(UIGameScene);
	}
}