import auto_loadingScene from "../../../data/autoui/scene/auto_loadingScene";
import UIBase from "../UIBase";
import UIHelp from "../UIHelp";

const { ccclass, menu, property } = cc._decorator;

@ccclass
@menu("UI/scene/UILoadingScene")
export default class UILoadingScene extends UIBase {
	ui: auto_loadingScene = null;

	protected static prefabUrl = "";
	protected static className = "UILoadingScene";

	private bar = 0;

	onUILoad() {
		this.ui = this.node.addComponent(auto_loadingScene);
	}

	onShow() {

	}

	onHide() {

	}

	onUpdate(dt) {
		var self = this;
		var jindu = this.bar/100;
		if(jindu <= 1) {
			UIHelp.SetProgressBar(this.ui.progressBar, jindu);
			this.bar ++;
			if (jindu == 1) {
				cc.director.loadScene("loginScene");
			}
		}
    }


	onStart() {
		var self = this;
		var fin = cc.fadeTo(2, 0);
		this.ui.model.runAction(fin);
	}

	onClose() {
		UIHelp.CloseUI(UILoadingScene);
	}
}