import auto_loginScene from "../../../data/autoui/scene/auto_loginScene";
import GameDataCenter from "../../../data/GameDataCenter";
import GameController from "../../../GameController";
import UIBase from "../UIBase";
import UIHelp from "../UIHelp";
import UILoading from "../loading/UILoading";
import EventMng from "../../../manager/EventMng";
import { GameEvent } from "../../../data/const/EventConst";
import { Utils } from '../../../utils/Utils';

const { ccclass, menu, property } = cc._decorator;

@ccclass
@menu("UI/scene/UILoginScene")
export default class UILoginScene extends UIBase {
	ui: auto_loginScene = null;

	protected static prefabUrl = "";
	protected static className = "UILoginScene";

	onUILoad() {
		this.ui = this.node.addComponent(auto_loginScene);
		this.ui.version.getComponent(cc.Label).string = "1.0.0";
	}

	onShow() {
		// 监听btn_login点击事件
		this.onRegisterEvent(this.ui.btn_kaishi, this.onLogin, this);
	}

	onHide() {
		// 取消监听btn_login点击事件
		this.unRegisterEvent(this.ui.btn_kaishi, this.onLogin, this);
	}

	onStart() {
		var self = this;
		// 游戏初始化
		GameController.init();
		GameDataCenter.setting.playBGM();
		GameDataCenter.setting.saveEffect(true);
	}

	onLogin() {
		var self = this;
		cc.director.loadScene("gameScene");
	}
}