import { SocketDelegate } from "./SocketDelegate";
import { Log } from "../utils/Log";
import { Utils } from "../utils/Utils";
import { Http } from "./Http";
import EventMng from "../manager/EventMng";
import GameController from "../GameController";
import GameDataCenter from "../data/GameDataCenter";
import UIHelp from "../logic/ui/UIHelp";
let instance = null;
let instancegame = null;
export class Network {
    private _socket: SocketDelegate = null;
    private _url: string = 'ws://60.205.213.218:19501/?';
    private _httpurl: string = 'http://api.luckypet.vip/server/hall';
    private _httpurltest: string = 'http://api.luckypet.vip/';
    private isInit: boolean = false;
    private socket: WebSocket = null;
    private host: string = null;
    private static instance: any = null;
    private closedByClient: boolean = false;
    private ctx_seq = -1


    constructor() {
        //this.safeConnectSocket();
    }


    public get readyState(): number {
        if (this.socket == null) {
            return WebSocket.CLOSED;
        }
        return this.socket.readyState;
    }

    public get isConnected(): boolean {
        return this.readyState == WebSocket.OPEN;
    }

    public get isClosedByClient(): boolean {
        return this.closedByClient;
    }

    public connect(url: string) {
        var self = this;
        console.log('url======connect======', url);
        if (self.isInit) {
            console.log('Network is already inited...');
            return;

        }
        //   console.log('url1111======connect======', url);

        self.closedByClient = false;
        let host = "";
        if (url.indexOf("ws://") == -1) {
            host = "ws://" + url;
        } else {
            host = url;
        }
        //    console.log('host======connect======', host);
        self.host = host;

        self.socket = new WebSocket(host);

        self.socket.onopen = (evt) => {
            console.log('Network onopen...', evt);
            self.isInit = true;
            EventMng.emit("netstart", evt);
        }

        self.socket.onmessage = (evt) => {
            var data = JSON.parse(evt.data);
          //  console.log('收到的数据message=====', data)
            EventMng.emit("net", data);
        }
        self.socket.onerror = (evt) => {
            console.log('Network onerror...');
            EventMng.emit("neterror", evt);
        };
        self.socket.onclose = (evt) => {
            console.log('Network onclose...1');
            // evt['closeByClient'] = self.closedByClient;
            EventMng.emit("netclose", evt);

            this.isInit = false;
        }
    }

    public sendmc(c: string, m: string, data: any) {
        var obj: Object = {
            "c": c,
            "m": m,
            "data": data
        };

        if (data) {
            data.ctx_seq = this.ctx_seq;
        }

        this.send(obj)
    }

    public send(cmd: any) {
        if (!this.isInit)
            cc.warn('Network is not inited...');
        else if (this.socket.readyState == WebSocket.OPEN) {
            var str = JSON.stringify(cmd)
            if (cmd.c != "heart") {
                console.log("<-----------------------发送", cmd)
            }
            //  console.log('str========', str)
            // var uint = this.str2UTF8(str);
            // var deflate = new Zlib.Gzip(uint);
            // var compressed = deflate.compress();
            this.socket.send(str);
        } else
            cc.log('Network WebSocket readState:' + this.socket.readyState);

    }

    public close() {
        if (this.socket) {
            this.socket.close();
            this.socket = null;
            this.isInit = false;
            this.closedByClient = true;
        }
    }

    //http请求
    httpSend(cmd,params,loding){
        var self = this;

        if(loding){
            UIHelp.ShowLoding();
        }

        if (params && GameDataCenter.account.jwt) {
            params["jwt"] = GameDataCenter.account.jwt;
        }

        if (params && GameDataCenter.account.uid) {
            params["uid"] = GameDataCenter.account.uid;
        }

        var param = Utils.obj_contact(params);
        var url = encodeURI(self._httpurl + "/" + cmd + param);
        console.log('_____httpSend:', url)
        Http.get(url, function (eventName: string, xhr: XMLHttpRequest) {
            UIHelp.CloseLoding();
            if (eventName == 'COMPLETE') {
                if (xhr.readyState == 4 && (xhr.status >= 200 && xhr.status < 400)) {
                    var response = JSON.parse(xhr.responseText)
                    let replace = cmd.replace(/\//g, '_')

                    //-------所有请求回调都带有user，刷新user数据， 可修改----------
                    if (response["errcode"]) {
                        if(response["errcode"] == 3){
                            UIHelp.ShowTips(response["msg"]);
                        }else if(response["errcode"] == 4){
                            UIHelp.ShowTips("服务器更新中...");
                            cc.director.loadScene("loginScene");
                        }else{
                            UIHelp.ShowTips(response["errmsg"]);
                        }
                        return;
                    }

                    if(GameDataCenter.account.stops != null && GameDataCenter.account.stops != response["stops"]){
                        UIHelp.ShowTips("服务器更新中...");
                        cc.director.loadScene("loginScene");
                    }

                    if (response["data"] && response["data"]["user"]) {
                        GameDataCenter.player.initData(response["data"]["user"]);
                    }

                    if (response["today"]) {
                        GameDataCenter.player.today = response["today"];
                    }

                    if (response["now"]) {
                        GameDataCenter.player.serverTime = response["now"];
                    }
                    //-------所有请求回调都带有user，刷新user数据， 可修改----------
                    console.log('_____httpSendend:', response)

                    EventMng.emit(replace, response);
                }
            } else if (eventName == 'TIMEOUT') {
                //TODO:添加提示连接网关超时
                this.et.emit('TIMEOUT', {})
                cc.log("添加提示连接网关超时")
            } else if (eventName == 'ERROR') {
                //TODO:添加提示连接网关发生错误
                cc.log("添加提示连接网关发生错误")
            }
        }, this);
    }

    httpPost(cmd, params){
        var self = this;

        UIHelp.ShowLoding();

        // console.log(url)
        // console.log(reqData)
        //1.拼接请求参数
        var param = "";
        for(var item in params){
            param += item + "=" + params[item] + "&";
        }
        //2.发起请求
        var xhr = new XMLHttpRequest();
        xhr.onreadystatechange = function () {
            UIHelp.CloseLoding();
            if (xhr.readyState == 4){
                if(xhr.status >= 200 && xhr.status < 400){
                    var response = xhr.responseText;
                    let replace = cmd.replace(/\//g,'_')
                    // console.log(response)
                    if(response){
                        if(response["errcode"]){
                            UIHelp.ShowTips(response["errmsg"]);
                            return;
                        }

                        var responseJson = JSON.parse(response);
                        EventMng.emit(replace, responseJson);
                    }else{
                        console.log("返回数据不存在")
                    }
                }else{
                    console.log("请求失败")
                }
            }
        };
        xhr.open("POST", self._httpurltest + "/" + cmd, true);
        xhr.setRequestHeader("Content-Type" , "application/x-www-form-urlencoded");  
        xhr.send(param);//reqData为字符串形式： "key=value"
    }
}
instancegame = new Network();
cc['NetworkGame'] = instancegame ? instancegame : new Network();