// Learn cc.Class:
//  - [Chinese] http://docs.cocos.com/creator/manual/zh/scripting/class.html
//  - [English] http://www.cocos2d-x.org/docs/creator/en/scripting/class.html
// Learn Attribute:
//  - [Chinese] http://docs.cocos.com/creator/manual/zh/scripting/reference/attributes.html
//  - [English] http://www.cocos2d-x.org/docs/creator/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - [Chinese] http://docs.cocos.com/creator/manual/zh/scripting/life-cycle-callbacks.html
//  - [English] http://www.cocos2d-x.org/docs/creator/en/scripting/life-cycle-callbacks.html

cc.Class({
    extends: cc.Component,

    properties: {
        display: {
            type: cc.Node,
            default: null
        }
    },

    // LIFE-CYCLE CALLBACKS:

    onLoad () {
        this.setUpdateWechatSubCanvas(true);
    },

    onDestroy () {
        this.setUpdateWechatSubCanvas(false);
    },

    setUpdateWechatSubCanvas: function(bOn) {
        if (CC_WECHATGAME) {
            var self = this
            this.scheduleOnce(() =>{
                if (self.display) {
                    self.display.getComponent(cc.WXSubContextView).enabled = bOn
                    self.display.getComponent(cc.WXSubContextView).update()
                }
                console.log("当前子域刷新状态：", bOn)
            }, 0.1)
        }
    },

    start () {

    },

    // update (dt) {},
});
