// http://www.emanueleferonato.com/2011/10/04/create-a-terrain-like-the-one-in-tiny-wings-with-flash-and-box2d-%E2%80%93-adding-more-bumps/
cc.Class({
    extends: cc.Component,

    properties: {
        xOffset: 0,
        yOffset: 0,
        hillWidth:200,
        label: {
            default: null,
            type: cc.Label
        },
        // defaults, set visually when attaching this script to the Canvas
        text: 'Hello, World!',
        target: {
            default: null,
            type: cc.Node
        },
        grand: {
            default: null,
            type: cc.Node
        }
    },

    // use this for initialization
    onLoad: function () {
        this.label.string = this.text;

        

        this.hills = [];
        this.pools = [];

        while (this.xOffset < 2400) {
            this.generateHill();
        }

        this.target.name="1";
        for (let index = 0; index < 0; index++) {
            let player=cc.instantiate(this.target);
            player.parent=this.node;
            player.x=player.x-index*100;
            player.name=this.target.name+index+1;
        }
    },

    generateHillPiece (xOffset) {
        let hills = this.hills;
        let first = hills[0];
        if (first && (this.target.x - first.node.x > 1200)) {
            first.node.x = xOffset;
            first.node.y = this.yOffset;
            hills.push( hills.shift() );
            return;
        }

        let node =cc.instantiate(this.grand);
        node.active=true;
        node.x = xOffset;
        node.y = this.yOffset;
        node.parent = this.node;
        hills.push( {node: node} );
        
    },

    generateHill () {
        this.generateHillPiece(this.xOffset);
        this.xOffset += this.hillWidth;
        this.yOffset =0;
    },

    // called every frame, uncomment this function to activate update callback
    update: function (dt) {
        if (!this.target) return;

        for (let index = 0; index < this.hills.length; index++) {
            if(this.hills[index].node.y!=0){
                let x=index;
            }
        }
        
        while (this.target.x + 1200 > this.xOffset) {
            this.generateHill();
        }
    },
});
