cc.Class({
    extends: cc.Component,

    properties: {

        face_one:cc.SpriteFrame,
        face_two:cc.SpriteFrame,
        label:cc.Label,
        spriteCount:{
            set:function (value) {
                this._spriteCount = value;
                this.refreshLabel();
            },
            get:function () {
                return this._spriteCount
            },
        }
    },

    // use this for initialization
    onLoad: function () {

        this._spriteCount = 0;

        setInterval(()=>{

            var bgNode = new cc.Node("Sprite");
            var sprite = bgNode.addComponent(cc.Sprite);
            sprite.type = cc.Sprite.Type.SLICED;
            sprite.insetLeft = 26;
            sprite.insetRight = 26;
            sprite.insetBottom = 26;
            // sprite.insetTop = 26;

            bgNode.parent = cc.director.getScene().getChildByName("Canvas");

            var node = new cc.Node("Label");
            node.size = cc.size(200,100);
            node.color = cc.color(255,0,0,255);
            node.position = cc.v2(0,0);
            var label = node.addComponent(cc.Label);
            label.fontSize = 34;
            label.verticalAlign = 1;
            label.lineHeight = 100;
            label.string = "我是测试用数字" + Math.random();
            node.parent = bgNode;
            bgNode.opacity = 0;
            bgNode.width = node.width + 100;
            var actions = [];
            actions.push(cc.fadeIn(0.1));
            actions.push(cc.delayTime(0.1));
            actions.push(cc.moveTo(0.25,cc.v2(0,100)));
            actions.push(cc.callFunc(()=>{

            }))
            actions.push(cc.delayTime(1));
            actions.push(cc.fadeOut(0.2));
            actions.push(cc.callFunc((k)=>{
                k.destroy();
            },bgNode));
            bgNode.runAction(cc.sequence(actions));

        },500);

    },
    
    buttonPressed:function (ev,data) {

        if (data == 1){
            for (let i = 0; i < 100;++i) this.createNode(this.face_one,"dog",10);
            this.spriteCount += 100;
        }

        if (data == 2){
            this.createNode(this.face_two,"bullet");
            this.spriteCount += 1;
        }

    },

    createNode:function (spriteFrame,group,speed) {

        let node = new cc.Node();
        node.addComponent(cc.Sprite).spriteFrame = spriteFrame;
        node.addComponent("ColliderListener");
        let box = node.addComponent(cc.BoxCollider);
        box.size = cc.size(50,50);
        node.setPosition(this.createRandPosition() || cc.v2(0,0));
        node.group = group;
        this.node.addChild(node);

        node.runAction(cc.sequence(cc.moveTo(speed || 1,0,0),cc.callFunc(()=>{
            node.destroy();
            this.spriteCount -= 1;
        })))

    },



    refreshLabel:function () {
        this.node.getChildByName("label").getComponent(cc.Label).string = this.spriteCount;
    },

    createRandPosition:function () {
        return cc.v2(Math.random() * 960 - 480,Math.random() * 640 - 320);
    },

    // called every frame
    update: function (dt) {

    },
});
