cc.Class({
    extends: cc.Component,

    properties: {
        txt1: cc.Label,
        txt2: cc.Label,
        _exp: 0,
        _heroExp: 0,
    },

    onLoad: function () {
        this.schedule(function () {
            this._exp++;
            this.dispatch({"heroExp": this._exp});
        }, 0.05);
    },

    onBtn1: function () {
        this.dispatch([{"soldier": 2600}, {"soldier": 80}]);
    },

    dispatch: function (data) {
        for (var k in data) {
            if (data.hasOwnProperty(k)) {
                var val = Number(data[k]);
                if (!isNaN(val)) {
                    data[k] = val;
                }
            }
        }

        if (data.heroExp) {
            this._heroExp = data.heroExp;
        }
    },

    update: function () {
        this.txt1.string = this._exp;
        this.txt2.string = this._heroExp;
    },

});
