cc.Class({
    extends: require('./textureRenderUtils'),

    properties: {
        _width: 0,
        _height: 0
    },

    start() {
        this.node.on("touchstart", this.onClick, this);
    },

    /**初始化图片资源 */
    init() {
        this.label.string = '';
        let texture = new cc.RenderTexture();
        let gl = cc.game._renderContext;
        texture.initWithSize(cc.visibleRect.width, cc.visibleRect.height, gl.STENCIL_INDEX8);
        //一用这句话就黑屏
        this.camera.targetTexture = texture;
        this.camera.targetTexture = null;
        this.texture = texture;
    },

    onClick() {
        this.init();
        // create the capture
        this.schedule(() => {
            let picData = this.initImage();
            this.showSprite(picData);
            this.label.string = 'Showing the capture'
            // this.saveFile(picData);
            this.camera.targetTexture = this.texture;
        }, 1, 0);
    },


    // 初始化图片数据
    initImage() {
        console.log("我是texture", this.texture);
        let data = this.texture.readPixels();
        console.log("我是data", data);
        this._width = this.texture.width;
        this._height = this.texture.height;
        let picData = this.filpYImage(data, this._width, this._height);
        return picData;
    },

    // override init with Data
    showSprite(picData) {
        let texture = new cc.Texture2D();
        texture.initWithData(picData, 32, this._width, this._height);

        let spriteFrame = new cc.SpriteFrame();
        spriteFrame.setTexture(texture);

        let node = new cc.Node();
        let sprite = node.addComponent(cc.Sprite);
        sprite.spriteFrame = spriteFrame;

        node.zIndex = cc.macro.MAX_ZINDEX;
        node.parent = cc.director.getScene();
        // set position
        let width = cc.winSize.width;
        let height = cc.winSize.height;
        node.x = width / 2;
        node.y = height / 2;
        node.on(cc.Node.EventType.TOUCH_START, () => {
            node.parent = null;
            this.label.string = '';
            node.destroy();
        });

        this.captureAction(node, width, height);
    },


    captureAction(capture, width, height) {
        let scaleAction = cc.scaleTo(1, 0.3);
        let targetPos = cc.v2(width - width / 6, height / 4);
        let moveAction = cc.moveTo(1, targetPos);
        let spawn = cc.spawn(scaleAction, moveAction);
        capture.runAction(spawn);
        let blinkAction = cc.blink(0.1, 1);
        // scene action
        this.node.runAction(blinkAction);
    },


    saveFile(picData) {
        if (CC_JSB) {
            let filePath = jsb.fileUtils.getWritablePath() + 'render_to_sprite_image.png';

            let success = jsb.saveImageData(picData, this._width, this._height, filePath)
            if (success) {
                cc.log("save image data success, file: " + filePath);
            }
            else {
                cc.error("save image data failed!");
            }
        }
    },

    // This is a temporary solution
    filpYImage(data, width, height) {
        // create the data array
        let picData = new Uint8Array(width * height * 4);
        console.log("我是picData", picData);
        let rowBytes = width * 4;
        for (let row = 0; row < height; row++) {
            let srow = height - 1 - row;
            let start = srow * width * 4;
            let reStart = row * width * 4;
            // save the piexls data
            for (let i = 0; i < rowBytes; i++) {
                picData[reStart + i] = data[start + i];
            }
        }
        return picData;
    }
}); 
