"use strict";
cc._RF.push(module, '7f526okx0BDAJTG2/v/NF+Y', 'capture_to_native');
// Script/capture_to_native.js

'use strict';

cc.Class({
    extends: require('./textureRenderUtils'),

    properties: {
        _width: 0,
        _height: 0
    },

    start: function start() {
        this.node.on("touchstart", this.onClick, this);
    },


    /**初始化图片资源 */
    init: function init() {
        this.label.string = '';
        var texture = new cc.RenderTexture();
        var gl = cc.game._renderContext;
        texture.initWithSize(cc.visibleRect.width, cc.visibleRect.height, gl.STENCIL_INDEX8);
        //一用这句话就黑屏
        this.camera.targetTexture = texture;
        this.camera.targetTexture = null;
        this.texture = texture;
    },
    onClick: function onClick() {
        var _this = this;

        this.init();
        // create the capture
        this.schedule(function () {
            var picData = _this.initImage();
            _this.showSprite(picData);
            _this.label.string = 'Showing the capture';
            // this.saveFile(picData);
            _this.camera.targetTexture = _this.texture;
        }, 1, 0);
    },


    // 初始化图片数据
    initImage: function initImage() {
        console.log("我是texture", this.texture);
        var data = this.texture.readPixels();
        console.log("我是data", data);
        this._width = this.texture.width;
        this._height = this.texture.height;
        var picData = this.filpYImage(data, this._width, this._height);
        return picData;
    },


    // override init with Data
    showSprite: function showSprite(picData) {
        var _this2 = this;

        var texture = new cc.Texture2D();
        texture.initWithData(picData, 32, this._width, this._height);

        var spriteFrame = new cc.SpriteFrame();
        spriteFrame.setTexture(texture);

        var node = new cc.Node();
        var sprite = node.addComponent(cc.Sprite);
        sprite.spriteFrame = spriteFrame;

        node.zIndex = cc.macro.MAX_ZINDEX;
        node.parent = cc.director.getScene();
        // set position
        var width = cc.winSize.width;
        var height = cc.winSize.height;
        node.x = width / 2;
        node.y = height / 2;
        node.on(cc.Node.EventType.TOUCH_START, function () {
            node.parent = null;
            _this2.label.string = '';
            node.destroy();
        });

        this.captureAction(node, width, height);
    },
    captureAction: function captureAction(capture, width, height) {
        var scaleAction = cc.scaleTo(1, 0.3);
        var targetPos = cc.v2(width - width / 6, height / 4);
        var moveAction = cc.moveTo(1, targetPos);
        var spawn = cc.spawn(scaleAction, moveAction);
        capture.runAction(spawn);
        var blinkAction = cc.blink(0.1, 1);
        // scene action
        this.node.runAction(blinkAction);
    },
    saveFile: function saveFile(picData) {
        if (CC_JSB) {
            var filePath = jsb.fileUtils.getWritablePath() + 'render_to_sprite_image.png';

            var success = jsb.saveImageData(picData, this._width, this._height, filePath);
            if (success) {
                cc.log("save image data success, file: " + filePath);
            } else {
                cc.error("save image data failed!");
            }
        }
    },


    // This is a temporary solution
    filpYImage: function filpYImage(data, width, height) {
        // create the data array
        var picData = new Uint8Array(width * height * 4);
        console.log("我是picData", picData);
        var rowBytes = width * 4;
        for (var row = 0; row < height; row++) {
            var srow = height - 1 - row;
            var start = srow * width * 4;
            var reStart = row * width * 4;
            // save the piexls data
            for (var i = 0; i < rowBytes; i++) {
                picData[reStart + i] = data[start + i];
            }
        }
        return picData;
    }
});

cc._RF.pop();