cc.Class({
    extends: cc.Component,

    properties: {
        richText: cc.Component
    },

    // use this for initialization
    onLoad: function () {

    },
    

    captureScreen: function () {
        //注意，EditBox，VideoPlayer，Webview 等控件无法截图

        if(CC_JSB || true) {
            //如果待截图的场景中含有 mask，请开启下面注释的语句
            var renderTexture = cc.RenderTexture.create(1280,640, cc.Texture2D.PIXEL_FORMAT_RGBA8888, gl.DEPTH24_STENCIL8_OES);
            // var renderTexture = cc.RenderTexture.create(1280,640);

            //把 renderTexture 添加到场景中去，否则截屏的时候，场景中的元素会移动
            this.richText.node.parent._sgNode.addChild(renderTexture);
            //把 renderTexture 设置为不可见，可以避免截图成功后，移除 renderTexture 造成的闪烁
            renderTexture.setVisible(false);

            //实际截屏的代码
            renderTexture.begin();
            //this.richText.node 是我们要截图的节点，如果要截整个屏幕，可以把 this.richText 换成 Canvas 切点即可
            this.richText.node._sgNode.visit();
            renderTexture.end();

            // let imagePath=cc.path.join(jsb.fileUtils.getWritablePath(),"demo.png");
            // renderTexture.saveToFile(imagePath,cc.ImageFormat.PNG, true, function () {
            //     //把 renderTexture 从场景中移除
            //     renderTexture.removeFromParent();
            //     cc.log("capture screen successfully!");
            // });
            // 打印截图路径
            // cc.log(jsb.fileUtils.getWritablePath());

            var width = 1280, height = 640;

            const texture = renderTexture.getSprite().getTexture();

            // Create a framebuffer backed by the texture
            const framebuffer = gl.createFramebuffer();
            gl.bindFramebuffer(gl.FRAMEBUFFER, framebuffer);
            gl.framebufferTexture2D(gl.FRAMEBUFFER, gl.COLOR_ATTACHMENT0, gl.TEXTURE_2D, texture._webTextureObj, 0);
    
            // Read the contents of the framebuffer
            const data = new Uint8Array(width * height * 4);
            gl.readPixels(0, 0, width, height, gl.RGBA, gl.UNSIGNED_BYTE, data);
    
            gl.deleteFramebuffer(framebuffer);

            const offScreenCanvas = document.createElement('canvas');
            offScreenCanvas.width = width;
            offScreenCanvas.height = height;
            const context = offScreenCanvas.getContext('2d');
    
            // Copy the pixels to a 2D canvas
            const imageData = context.createImageData(width, height);
            imageData.data.set(data);
            context.putImageData(imageData, 0, 0);
    
            const img = new Image();
            img.src = offScreenCanvas.toDataURL();
    
            img.style.position = 'absolute';
            img.style.left = 0;
            img.style.top = 0;
            document.body.appendChild(img);
        }
    }

});
