/*******************************************************************************
 * CopyRight (c) HYTC Ltd. All rights reserved.
 * Filename:  tool.js
 * Creator:   GaoLei
 * Version:   0.0
 * Date:		2011-05-13
 * Description: 为了适配js而提供的额外工具类
 *******************************************************************************/
console.log(" 1 load Tool.js");

// 将字符串转成int
export function toInt(value) {
    if (typeof value == 'string') {
        return parseInt(value);
    }
    return Math.floor(value);
}

//向下取整
export function Int(i) {
    return Math.floor(i);
}

//向上取整
export function ceil(i) {
    return Math.ceil(i);
}

export function abs(i) {
    return Math.abs(i);
}

// 将int转成字符串
export function toString(value) {
    return String(value);
}

// 获取一个整数的长度
export function getNumLength(num) {
    return String(num).length;
}

// 获取随机数 [0, _rand)
export function random(_rand) {
    return Int(Math.random() * (_rand + 1));
}

// 模板字符串 
export function sprintf(textSrc, d1, d2) {
    //String.format(textSrc, s);// replace(textSrc, "%s", s);
    if (typeof (d1) === 'string') {
        textSrc = textSrc.replace('%s', String(d1));
    }
    else if (typeof (d1) === 'number') {
        textSrc = textSrc.replace('%d', String(d1));
    }

    if (typeof (d2) === 'string') {
        textSrc = textSrc.replace('%s', String(d2));
    } else if (typeof (d2) === 'number') {
        textSrc = textSrc.replace('%d', String(d2));
    }
    return textSrc;
}






//获取系统当前时间 毫秒
export function currentTimeMillis() {
    let date = new Date();
    return date.getTime()
}

export function getRmsSizeAvailable() { //获取RMS剩余空间
    return 12345678;
}
export function getTotalMemory() { //获取内存大小
    return 12345679;
}
export function getFreeMemory() { //获取可以内存大小
    return 12345677;
}
export function getPlatform() { //获取设备名
    return "ccs";
}
export function setDataKV(key, value) {
    cc.sys.localStorage.setItem(key, value);
}
export function getDataByKey(key) {
    return cc.sys.localStorage.getItem(key);
}





//为String类增加一个方法
String.prototype.removeAll = function () {
    return "";
}
String.prototype.equals = function (str) {
    return this === str;
}
//unicod String -> utf8 Array
String.prototype.toBytes = function () {
    let bytes = new Array();
    let len = this.length;
    let c;
    for (let i = 0; i < len; i++) {
        c = this.charCodeAt(i);
        if (c >= 0x010000 && c <= 0x10FFFF) {
            bytes.push(((c >> 18) & 0x07) | 0xF0);
            bytes.push(((c >> 12) & 0x3F) | 0x80);
            bytes.push(((c >> 6) & 0x3F) | 0x80);
            bytes.push((c & 0x3F) | 0x80);
        } else if (c >= 0x000800 && c <= 0x00FFFF) {
            bytes.push(((c >> 12) & 0x0F) | 0xE0);
            bytes.push(((c >> 6) & 0x3F) | 0x80);
            bytes.push((c & 0x3F) | 0x80);
        } else if (c >= 0x000080 && c <= 0x0007FF) {
            bytes.push(((c >> 6) & 0x1F) | 0xC0);
            bytes.push((c & 0x3F) | 0x80);
        } else {
            bytes.push(c & 0xFF);
        }
    }
    return bytes;
}

Array.prototype.add = function (child) {
    this.push(child);
}
Array.prototype.clear = function () {
    this.splice(0, this.length); //清空数组 
}
Array.prototype.get = function (index) {
    return this[index];
}
// 移除此列表中首次出现的指定元素（如果存在）。
Array.prototype.remove = function (obj) {
    var index = this.indexOf(obj);
    //使用splice函数进行移除：
    if (index > -1) {
        this.splice(index, 1);
    }
}
Array.prototype.removeAll = function () {
    this.splice(0, this.length); //清空数组 
}
Array.prototype.size = function () {
    return this.length;
}

Map.prototype.removeAll = function () {
    //this.clear(); //清空数组
}
Map.prototype.put = function (k, v) {
    this.set(k, v);
}


cc.Button.prototype.splash = function(){
    console.log("cc.Button.prototype.splash");
    // this._pressed = true;
    // this._updateState();
}





export function int2Byte(intValue) {
    let byte = intValue;
    if (intValue >= -512 && intValue <= -385)
    {
        byte = 512 + intValue;
    }
    else if (intValue >= -384 && intValue <= -129)
    {
        byte = 256 + intValue;
    }
    else if (intValue >= -128 && intValue <= 127)
    {
        byte = 0 + intValue;
    }
    else if (intValue >= 128 && intValue <= 383) 
    {
        byte = intValue - 256; //-(256-intValue)
    }
    else if (intValue >= 384 && intValue <= 512)
    {
        byte = intValue - 512; //-(256-intValue)
    }
    return byte;
}


//UTF8Bytes->UnicodeBytes
/*
Unicode符号范围 | UTF - 8 编码方式(十六进制) | （二进制）
-- -- -- -- -- -- -- -- -- -- -- + -- -- -- -- -- -- -- -- -- --
	      0 < -- > 0x7f | 0xxx_xxxx
	  0x80 < -- > 0x7FF | 110x_xxxx 10xx_xxxx
    0x800 < -- > 0xFFFF | 1110_xxxx 10xx_xxxx 10xx_xxxx
0x10000 < -- > 0x10FFFF | 1111_0xxx 10xx_xxxx 10xx_xxxx 10xx_xxxx
*/
export function UTF8Bytes_to_UnicodeBytes(utf8Bytes) {
    let unicodeBytes = new Array();
    for (let i = 0; i < utf8Bytes.length; i++) {
        let unicode = 0;
        let m = utf8Bytes[i];
        if (m >= 0 && m <= 0x7F) //UTF8 1字节 //0xxx_xxxx
        {
            unicode = m; // | 0x0000
        } else if (m >= 0xC0 && m <= 0xDF) //UTF8 2字节 //110x_xxxx
        {
            let m1 = (m & 0x1F) << 6; //UTF 第1个字节
            let m2 = (utf8Bytes[i + 1] & 0x3F); //UTF 第2个字节
            unicode = m1 | m2;
            i += 1;
        } else if (m >= 0xE0 && m <= 0xEF) //UTF8 3字节 //1110_xxxx
        {
            let m1 = (m & 0x0F) << 12; //UTF 第1个字节
            let m2 = (utf8Bytes[i + 1] & 0x3F) << 6; //UTF 第2个字节
            let m3 = (utf8Bytes[i + 2] & 0x3F); //UTF 第3个字节
            unicode = m1 | m2 | m3;
            i += 2;
        } else if (m >= 0xF0 && m <= 0xF7) //UTF8 4字节 //1111_0xxx
        {
            let m1 = (m & 0x07) << 18; //UTF 第1个字节
            let m2 = (utf8Bytes[i + 1] & 0x3F) << 12; //UTF 第2个字节
            let m3 = (utf8Bytes[i + 2] & 0x3F) << 6; //UTF 第3个字节
            let m4 = (utf8Bytes[i + 3] & 0x3F); //UTF 第4个字节
            unicode = m1 | m2 | m3 | m4;
            i += 3;
        }
        unicodeBytes.push(unicode);
    }
    return unicodeBytes;
}