/*******************************************************************************
 * CopyRight (c) HYTC Ltd. All rights reserved.
 * Filename: xiyou_autoPath.js
 * Creator:   GaoLei
 * Version:   0.0
 * Date:		 2011-06-28
 * Description: 自动寻路
 *******************************************************************************/
console.log(" 1 load autoPath.js");

import * as ENUM from '../adapter/ENUM'
import {
	XIYOU_DIRECTION
} from '../adapter/ENUM'
import {
	Int
} from '../Tool'

const G_OFFSET = 1; //每个图块G值的增加值

Array.prototype.removeElementAt = function (val) {
	var index = this.indexOf(val);
	if (index > -1) {
		return this.splice(index, 1);
	}
	return this;
};
Array.prototype.elementAt = function (index) {
	return this[index];
};


export default class AutoPath {
	//构造方法
	constructor() {
		this.tileSize = 1; //图块大小
		this.destinationRow = 0; //目标所在行
		this.destinationCol = 0; //目标所在列
		this.mapData = null; //地图数组
		this.tile_x_count = 0; //地图数组的行数
		this.tile_y_count = 0; //地图数组的列数
		this.startTileX = 0;
		this.startTileY = 0;
		//this.mapPlayer = null; //地图上的玩家
		this.closeNode = null; //节点关闭列表
		this.openNode = null; //节点开启别表
	}

	getPath(startX, StartY, destinationX, destinationY) {
		this.closeNode = new Array(); //Vector<MGE_Node>();	//节点关闭列表
		this.openNode = new Array(); //Vector<MGE_Node>();	//节点开启别表
		this.destinationRow = this.getRowPosition(destinationY);
		this.destinationCol = this.getColPosition(destinationX);
		let startNode = new MGE_Node();
		startNode.row = this.getRowPosition(StartY);
		startNode.col = this.getColPosition(startX);
		startNode.g = 0;
		startNode.h = this.getH(startNode.row, startNode.col);
		startNode.f = startNode.g + startNode.h;
		this.openNode.push(startNode);
		let bestNode = null;
		let autoPath = [];

		while (true) {
			bestNode = this.getBesetNode();
			//console.log("getPath bestNode:", bestNode);

			if (bestNode == null) { //未找到路径
				return autoPath;
			} else if (bestNode.row === this.getRowPosition(destinationY) &&
				bestNode.col === this.getColPosition(destinationX)) {
				let _Node = bestNode;
				let nodeSum = 0;
				let nodeIndex = 0;
				("程序运行次数");
				while (_Node.parent !== null) {
					//console.log(" getPath = 10 _Node.parent= ", _Node.parent);
					_Node = _Node.parent;
					nodeSum += 1;
				}
				//console.log("节点数量=%d\n",nodeSum);

				_Node = bestNode;
				nodeIndex = nodeSum - 1;
				if (nodeIndex >= ENUM.AUTO_PATH_FOOTSTEP) {
					// console.log(bestNode);
					// console.log(startNode);
					// console.log("getPath","return 2");
					return autoPath;
				}
				while (_Node.parent !== null && nodeIndex >= 0) {
					//console.log(` getPath = 20 x:${_Node.col}  y:${_Node.row} \n`);
					
					/*
					let _NodeParent = _Node.parent;
					if (_NodeParent.col - _Node.col == 0 && _NodeParent.row - _Node.row == +1) { // 从父节点到本节点的操作是 上
						autoPath[nodeIndex] = XIYOU_DIRECTION.UP;
					} else if (_NodeParent.col - _Node.col == 0 && _NodeParent.row - _Node.row == -1) { // 从父节点到本节点的操作是 下
						autoPath[nodeIndex] = XIYOU_DIRECTION.DOWN;
					} else if (_NodeParent.col - _Node.col == +1 && _NodeParent.row - _Node.row == 0) { // 从父节点到本节点的操作是 左
						autoPath[nodeIndex] = XIYOU_DIRECTION.LEFT;
					} else if (_NodeParent.col - _Node.col == -1 && _NodeParent.row - _Node.row == 0) { // 从父节点到本节点的操作是 右
						autoPath[nodeIndex] = XIYOU_DIRECTION.RIGHT;
					} else {
						autoPath[nodeIndex] = XIYOU_DIRECTION.NON;
					}
					*/
					autoPath[nodeIndex] = {
						col: _Node.col,
						row: _Node.row
					};
					

					nodeIndex -= 1;
					_Node = _Node.parent;
					//_NodeParent = null;
				}
				_Node = null;
				return autoPath;
			}
			this.seachSeccessionNode(bestNode);
			bestNode = null;
		}
		//return autoPath;
	}


	/**
	 * 根据传入的节点生成子节点
	 * 
	 * @param bestNode
	 * @param destinationRow
	 * @param destinationCol
	 */
	seachSeccessionNode(bestNode) {
		let row, col;
		//上部节点
		if (this.isCanMove(row = bestNode.row - 1, col = bestNode.col)) {
			this.creatSeccessionNode(bestNode, row, col);
		}
		//下部节点
		if (this.isCanMove(row = bestNode.row + 1, col = bestNode.col)) {
			this.creatSeccessionNode(bestNode, row, col);
		}
		//左部节点
		if (this.isCanMove(row = bestNode.row, col = bestNode.col - 1)) {
			this.creatSeccessionNode(bestNode, row, col);
		}
		//右部节点
		if (this.isCanMove(row = bestNode.row, col = bestNode.col + 1)) {
			this.creatSeccessionNode(bestNode, row, col);
		}

		this.closeNode.push(bestNode);
		for (let i = 0; i < this.openNode.length; i++) {
			let node = this.openNode.elementAt(i);
			if (node.row == bestNode.row && node.col == bestNode.col) {
				this.openNode.removeElementAt(node);
				break;
			}
		}
	}

	creatSeccessionNode(bestNode, row, col) {
		let oldNode = null;
		let g = bestNode.g + G_OFFSET;
		if (!this.isInClose(row, col)) {
			if ((oldNode = this.checkOpen(row, col)) != null) {
				if (oldNode.g < g) {
					oldNode.parent = bestNode;
					oldNode.g = g;
					oldNode.f = g + oldNode.h;
				}
			} else {
				let node = new MGE_Node();
				node.parent = bestNode;
				node.g = g;
				node.h = this.getH(row, col);
				node.f = node.g + node.h;
				node.row = row;
				node.col = col;
				this.openNode.push(node);
			}
		}
	}

	checkOpen(row, col) {
		let node = null;
		for (let i = 0; i < this.openNode.length; i++) {
			let node_temp = this.openNode.elementAt(i);
			if (node_temp.row == row && node_temp.col == col) {
				node = node_temp;
				return node;
			}
		}
		return node;
	}

	isInClose(row, col) {
		for (let i = 0; i < this.closeNode.length; i++) {
			let node = this.closeNode.elementAt(i);
			if (node.row == row && node.col == col) {
				node = null;
				return true;
			}
			node = null;
		}
		return false;
	}

	// 得到最优节点
	getBesetNode() {
		let bestNode = null;
		let f = 999999999;
		for (let i = 0; i < this.openNode.length; i++) {
			let node = this.openNode.elementAt(i);
			if (node.f < f) {
				f = node.f;
				bestNode = node;
			}
			node = null;
		}
		return bestNode;
	}

	// 得到该图块的H值
	getH(row, col) {
		return (Math.abs(this.destinationRow - row) + Math.abs(this.destinationCol - col));
	}

	// 得到该位置所在地图行
	getRowPosition(y) {
		return Int(y / this.tileSize);
	}

	// 得到该位置所在地图列
	getColPosition(x) {
		return Int(x / this.tileSize);
	}

	getMapData(col, row) { //col = y坐标，row = x坐标
		col = Int(col);
		row = Int(row);
		if (this.mapData != null) {
			let index = (col + this.startTileY) * this.tile_x_count + (row + this.startTileX);
			if (index >= 0 && index < this.mapData.length) {
				return Int(this.mapData[index]);
			}
		}
		return 0;
	}
	// 检测该图块是否可通行
	isCanMove(col, row) {
		col = Int(col);
		row = Int(row);
		if (this.mapData == null) {
			return false;
		} else if (row < 0 || row >= this.tile_x_count) {
			return false;
		} else if (col < 0 || col >= this.tile_y_count) {
			return false;
		} else {
			return (this.getMapData(col, row) & 0x80) == 0;
		}
	}
}


/**
 * 节点类
 */
class MGE_Node {
	constructor() {
		this.f = 0; //该节点路径评分
		this.g = 0; //从起始点到该节点的预估距离
		this.h = 0; //从该节点到终点的曼哈顿距离（忽略障碍水平垂直移动到终点的距离）
		this.row = 0; //该节点所在行
		this.col = 0; //该节点所在列
		this.parent = null; //该节点的父节点
	}
	//	MGE_Node[] child = new MGE_Node[8];	//该节点的子节点，最多8个
}
