/**
 * 帧动画, 使用旧版数据, 按帧显示, 切换帧时性能低!
 * 仅作备份,日后删除
 */
import Unpack from "../core/tool/Unpack";
import {
    ACT,
    ACTModule,
    ACTFrame,
    ACTSprite,
    ACTAction,
    ACTSequence
}
from "../core/Beans";
import {
    toString
}
from "../Tool";
import {
    CLIENT_ACT,
    FILE_TYPE,
    ROTATION,
    SCALE, //使用的动画资源被放大的倍数
}
from "../core/adapter/ENUM";


let HF_ACT = cc.Class({
    extends: cc.Component,
    //name: "HF_ACT",

    properties: {
        actID: 9900011, // 动画资源ID 
        FPS: 20, //动作帧率
        actionID: 0, //动作序列编号,[0map待机,1战斗待机,2map奔跑,3前冲,4防御,5攻击,6返回,7死亡,8连击,9施法,10坐骑]
        isLoop: true, //当前动作是否循环,不循环会停留在最后一帧
        isOlnyHead: false, //仅显示hero头像

        actSize: { // 下划线开头原本会隐藏
            default: null,
            visible: false
        },

        // 动画纹理文件
        _texture: null, // 动画纹理图片文件
        _act: null, //当前动作数据

        _actFrames: [cc.Node], // 帧 序列
        _actModules: [cc.SpriteFrame], // 图元 数组
        _headPic: null, //hero动画的第0个图元是头像
        _isCanFrameUpdate: false, // 是否可以更新动画,需要加载纹理和数据后才可以
        _frameStepIndex: 0, //帧序更新步数
        _currFrameID: 0, //当前动作序列帧的 帧序
        _currFrameID_show: 0, //当前动作序列帧的 正在显示的帧序
        _frameDT_sum: 0, //当前帧失去的时间 秒级
        _frameDuration: 0, //帧持续时间 1/FPS 秒级

        _actFrameUpdateCallBack:null,//动画帧更新的回调
        _actLoadCompleteCallBack:null,//act数据文件加载完成时的回调
    },

    // use this for initialization
    onLoad: function () {
        this.setFPS(this.FPS);
        this.setActId(this.actID);
        this.setActionID(this.actionID);
    },
    // called every frame
    update(dt) {
        if (this.isOlnyHead) {
            return;
        }
        this._frameDT_sum += dt;
        if (this._frameDT_sum > this._frameDuration) {
            this.actFrameUpdate();
            this._frameDT_sum = this._frameDT_sum - this._frameDuration;
        }
    },

    // 设置动作资源文件ID
    setActId(actID) {
        this.actID = actID;
        this.loadSpriteFrame();
    },

    // 设置动作ID
    setActionID(actionID) {
        if (this.actionID != actionID) {
            this.actionID = actionID;
            this._frameStepIndex = 0;
            this._currFrameID = 0;
        }
    },

    // 设置动作ID
    setIsLoop(isLoop) {
        this.isLoop = isLoop;
    },

    // 设置当前动画的帧率
    setFPS(fps) {
        this.FPS = fps;
        this._frameDuration = 1 / this.FPS;
    },

    //设置动画帧更新的回调,带有武器的人物动画需要
    set_actFrameUpdateCallBack(actFrameUpdateCallBack) {
        this._actFrameUpdateCallBack = actFrameUpdateCallBack;
    },
    //设置动画帧更新的回调,带有武器的人物动画需要
    set_actLoadCompleteCallBack(actLoadCompleteCallBack) {
        this._actLoadCompleteCallBack = actLoadCompleteCallBack;
    },

    //载入纹理图片 使用时需要绑定 this.loadSpriteFrame.bind(this)
    loadSpriteFrame() {
        this._isCanFrameUpdate = false;
        this.removeAct();
        let url_png = "act_png/" + this.actID;
        cc.loader.loadRes(url_png, cc.SpriteFrame, (err, spriteFrame) => {
            //console.log("loadSpriteFrame :", url_png);
            //console.log("loadSpriteFrame err:", err);
            this._texture = spriteFrame.getTexture();
            //console.log("00.this.texture:", this._texture);
            if (this._texture) {
                this._loadActFile();
            }
        });
    },

    getActSize(){
        //console.log("this.actSize:", this.actSize);
        return this.actSize;
    },

    //载入动画数据文件,
    _loadActFile() {
        //console.log("loadActFile this.actID:", this.actID);

        // let url_bin = cc.url.raw("resources/act_bin/" + this.actID + ".bin");
        // cc.loader.load(url_bin, (err, file) => {//这种方式H5与微信需要分版 

        //这种方式获取的数据都是BufferAsset类型,不需要分版
        let url_bin = "act_bin/" + this.actID; // + ".bin";
        cc.loader.loadRes(url_bin, cc.BufferAsset, (err, file) => {

            //console.log("loadActFile url_bin:", url_bin);
            //console.log("loadActFile err:", err);
            // 图元数组
            // let texture = this.spriteFrame.getTexture();

            let act = this.creatAct(0, file);
            this._act = act;
            this.actSize = {
                L: this._act.backGaugeLeft,
                R: this._act.backGaugeRight,
                B: this._act.backGaugeBottom,
                T: this._act.backGaugeTop,
                H: this._act.backGaugeBottom - this._act.backGaugeTop,
                W: this._act.backGaugeRight - this._act.backGaugeLeft,
            };
            if (this._actLoadCompleteCallBack){
                this._actLoadCompleteCallBack();
            }
            //console.log("11.this.actSize:", this.actSize);

            //console.log("11.console.cc.loader.load texture:", this._texture);
            //console.log("11.console.cc.loader.load act:", act);
            //console.log("11.console.cc.loader.load this._act:", this._act);

            if (this._act) {
                this._isCanFrameUpdate = true;
            }

            this._actModules = Array(act.actModule.length);
            for (let i = 0; i < act.actModule.length; i++) {
                let actModuleRect = new cc.Rect(act.actModule[i].x * SCALE,
                    act.actModule[i].y * SCALE,
                    act.actModule[i].w * SCALE,
                    act.actModule[i].h * SCALE);
                this._actModules[i] = new cc.SpriteFrame(this._texture, actModuleRect);
            }

            if (this.isOlnyHead) {
                let sprite_node = new cc.Node("head_node");
                sprite_node.parent = this.node;
                let sprite = sprite_node.addComponent(cc.Sprite);
                sprite.spriteFrame = this._actModules[0];
            }

            //console.log("1. this._actModules:", this._actModules);

            let j_start = 0;
            if (this.actID >= CLIENT_ACT.PC_START && this.actID <= CLIENT_ACT.PC_END) {
                j_start = 1; // 0帧是武器数据,可以不显示 //PC才有武器
            }

            //帧 序列
            //console.log("1. act.actFrame.length:", act.actFrame.length);
            this._actFrames = new Array(act.actFrame.length);
            for (let i = 0; i < act.actFrame.length; i++) {
                this._actFrames[i] = new cc.Node("frame_node_" + i);
                //console.log(i,". act.actFrame[i]:", act.actFrame[i]);
                for (let j = j_start; j < act.actFrame[i].actSprite.length; j++) {
                    //console.log(i, ". act.actFrame[i].actSprite.length:", act.actFrame[i].actSprite.length);
                    let sprite_node = new cc.Node("sprite_node_" + j);
                    sprite_node.parent = this._actFrames[i];
                    let sprite = sprite_node.addComponent(cc.Sprite);
                    let actSprite = act.actFrame[i].actSprite[j];
                    sprite.spriteFrame = this._actModules[actSprite.moduleID];
                    sprite.node.x = actSprite.x * SCALE;
                    sprite.node.y = -actSprite.y * SCALE;
                    sprite.node.anchorX = 0;
                    sprite.node.anchorY = 1;
                    //console.log("ok.[", i, ",", j, "] switch rop:", actSprite.mtrans);
                    //let MTRANS = [ROTATION.NONE, ROTATION.HORI, ROTATION.VERT, ROTATION.R90, 
                    //    ROTATION.R180, ROTATION.R270, ROTATION.HORI_90, ROTATION.HORI_270 ];

                    sprite.node.opacity = 255;
                    switch (actSprite.mtrans) {
                        case 0: // 没有进行转动和翻转
                            break;
                        case 1: // 左右翻转
                            sprite.node.scaleX = -1;
                            sprite.node.x += sprite.node.width;
                            break;
                        case 2: // 垂直翻转 左右翻转后顺时针旋转180度
                            sprite.node.scaleY = -1;
                            sprite.node.y -= sprite.node.height;
                            break;
                        case 3: // 顺时针旋转90度
                            //sprite.node.rotation = 90;
                            sprite.node.angle = -90; //该节点的旋转角度，正值为逆时针方向。
                            sprite.node.x += sprite.node.height;
                            break;
                        case 4: // 顺时针旋转180度
                            //sprite.node.rotation = 180;
                            sprite.node.angle = -180; //该节点的旋转角度，正值为逆时针方向。
                            sprite.node.x += sprite.node.width;
                            sprite.node.y -= sprite.node.height;
                            break;
                        case 5: // 顺时针旋转270度
                            //sprite.node.rotation = 270;
                            sprite.node.angle = -270; //该节点的旋转角度，正值为逆时针方向。
                            sprite.node.y -= sprite.node.width;
                            break;
                        case 6: // 左右翻转后 顺时针旋转90度
                            sprite.node.scaleX = -1;
                            //sprite.node.rotation = 90;
                            sprite.node.angle = -90; //该节点的旋转角度，正值为逆时针方向。
                            sprite.node.x += sprite.node.height;
                            sprite.node.y -= sprite.node.width;
                            break;
                        case 7: // 左右翻转后 顺时针旋转270度
                            sprite.node.scaleX = -1;
                            //sprite.node.rotation = 270;
                            sprite.node.angle = -270; //该节点的旋转角度，正值为逆时针方向。
                            break;
                        default:
                            //console.log("default:[", i, ",", j, "] switch rop:", actSprite.mtrans);
                            break;
                    }
                }
            }
        });
    },


    // 动画 帧更新
    actFrameUpdate() {
        if (!this._isCanFrameUpdate) {
            return;
        }

        let actAction = this._act.actAction[this.actionID].actSequence;
        let index = 0;
        if (this.isLoop) {
            index = this._frameStepIndex % actAction.length;
        } else {
            if (this._frameStepIndex > actAction.length - 1) {
                this._frameStepIndex = actAction.length - 1;
            }
            index = this._frameStepIndex;
        }
        
        this._actFrames[this._currFrameID_show].parent = null;
        if (this._currFrameID >= 0 && this._currFrameID != actAction[index].frameId) {
            this._currFrameID = actAction[index].frameId;
            this._actFrames[this._currFrameID].parent = this.node;
            this._currFrameID_show = this._currFrameID;
        }
        if (this._actFrames[this._currFrameID_show].parent == null) {
            this._actFrames[this._currFrameID_show].parent = this.node;
        }


        if (this._actFrameUpdateCallBack){
            let weaponSprite = this._act.actFrame[this._currFrameID].actSprite[0];
            this._actFrameUpdateCallBack(weaponSprite);
        }
        this._frameStepIndex += 1;
    },

    //移除旧的动画
    removeAct() {
        for (let i = 0; i < this._actFrames.length; i++) {
            this._actFrames[i].parent = null;
        }
        this._frameStepIndex = 0;
        this._currFrameID = 0;
    },

    creatAct(fileID, file) {
        let act = new ACT();
        let bmpWidth; // 图片宽度
        let bmpHeight; // 图片高度
        //let file = null; // 文件指针
        let length = 0; // 文件长度
        let fileOff = 0; // 文件指针偏移量
        let actModule = []; // 图元数组
        let actModuleCount = 0; // 图元数组 数组长度
        let actFrame = []; // 帧数据
        let actFrameCount = 0; // 帧数组长度
        let actAction = []; // 动作数据
        let actActionCount = 0; // 动作数组长度

        //console.log("file:", file);
        //file = readFile(null, fileID, FILE_TYPE.ACT);
        if (file == null) {
            return null;
        }
        length = file._buffer.byteLength;
        //console.error("setMountsID length:", length);
        //console.error("setMountsID file:", file);

        let unpack = new Unpack();
        unpack.setData(file._buffer); //H5 浏览器,CC模拟器
        //unpack.setData(file); //微信小游戏,需要使用这行

        unpack.skipBy(8); // 跳过 ACT.IMG{
        // 获取图片宽度 高度，双字节表示
        bmpWidth = unpack.unpack_GET_H();
        bmpHeight = unpack.unpack_GET_H();
        act.bmpWidth = bmpWidth;
        act.bmpHeight = bmpHeight;

        // 动画 图元数据
        // }MOD{
        unpack.skipBy(5); // 跳过 }MOD{
        actModuleCount = unpack.get_Int8_B();
        if (actModuleCount > 0) {
            actModule = new Array(actModuleCount); // new ACTModule[actModuleCount];
            for (let i = 0; i < actModuleCount; i++) {
                actModule[i] = new ACTModule(unpack.get_UInt8_B(), unpack.get_UInt8_B(), unpack.get_UInt8_B(),
                    unpack.get_UInt8_B());
            }
        }
        // 帧数据
        // }FRA{
        unpack.skipBy(5); // 跳过 }FRA{
        actFrameCount = unpack.get_UInt8_B();
        if (actFrameCount > 0) {
            actFrame = new Array(actFrameCount); // new ACTFrame[actFrameCount];
            for (let i = 0; i < actFrameCount; i++) {
                actFrame[i] = new ACTFrame();
                let spriteCount = unpack.get_UInt8_B();
                if (spriteCount > 0) {
                    let actFrameSprite = new Array(spriteCount); // new ACTSprite[spriteCount];
                    for (let j = 0; j < spriteCount; j++) {
                        actFrameSprite[j] = new ACTSprite(unpack.get_UInt8_B(), unpack.get_Int8_B(),
                            unpack.get_Int8_B(), unpack.get_Int8_B());
                    }
                    actFrame[i].actSpriteCount = spriteCount;
                    actFrame[i].actSprite = actFrameSprite;
                }
            }
        }
        // 动画数据
        // }ACT{
        unpack.skipBy(5); // 跳过 }ACT{
        actActionCount = unpack.get_Int8_B();
        if (actActionCount > 0) {
            actAction = new Array(actActionCount); // new ACTAction[actActionCount];
            for (let i = 0; i < actActionCount; i++) {
                actAction[i] = new ACTAction();
                let sequenceCount = unpack.get_UInt8_B();
                if (sequenceCount > 0) {
                    let actSequence = new Array(sequenceCount); // new ACTSequence[sequenceCount];
                    for (let j = 0; j < sequenceCount; j++) {
                        actSequence[j] = new ACTSequence(unpack.get_UInt8_B(), unpack.get_UInt8_B());
                    }
                    actAction[i].sequenceCount = sequenceCount;
                    actAction[i].actSequence = actSequence;
                }
            }
        }
        fileOff = unpack.getPos();
        if (length - fileOff > 4) // 有新版 GAP,KEY数据
        {
            // 动画原地与四边距离数据，上下左右
            // }GAP{
            unpack.skipBy(5); // 跳过 }GAP{
            act.backGaugeTop = unpack.get_Int8_B();
            act.backGaugeBottom = unpack.get_Int8_B();
            act.backGaugeLeft = unpack.get_Int8_B();
            act.backGaugeRight = unpack.get_Int8_B();

            if (act.backGaugeTop == 0 && act.backGaugeBottom == 0 && act.backGaugeLeft == 0 &&
                act.backGaugeRight == 0) { // 如果没有给ACT尺寸的话，需要个默认值
                act.backGaugeTop = -16;
                act.backGaugeBottom = 0;
                act.backGaugeLeft = -8;
                act.backGaugeRight = 8;
            }
            // }KEY{
            unpack.skipBy(5); // 跳过 }KEY{
            act.keyFramesSum = unpack.get_Int8_B();
            for (let i = 0; i < act.keyFramesSum; i++) {
                act.keyFrames[i] = unpack.get_Int8_B();
            }
        } else {
            // 默认值
            act.backGaugeTop = -16;
            act.backGaugeBottom = 0;
            act.backGaugeLeft = -8;
            act.backGaugeRight = 8;
            act.keyFramesSum = 1; // 有一个关键帧，是第0帧
            act.keyFrames[0] = 0;
        }

        // }END
        unpack.skipBy(4); // 跳过 }END

        // GIF 数据
        let isCreateImgOk = false;
        let bmpFileName = toString(fileID) + FILE_TYPE.PIC;
        //console.log(" bmpFileName:", bmpFileName);

        // act.bmpBuf = createImage(bmpFileName);
        // if (act.bmpBuf != null) {
        //     isCreateImgOk = true;
        // }

        // if (!isCreateImgOk) {
        //     fileOff = unpack.getPos();
        //     act.bmpBuf = createImage(file, fileOff, length - fileOff);
        // }

        act.actActionCount = actActionCount; // 动作数组长度
        act.actAction = actAction; // 动作数据
        act.actFrameCount = actFrameCount; // 帧数组长度
        act.actFrame = actFrame; // 帧数据
        act.actModuleCount = actModuleCount; // 图元数组 数组长度
        act.actModule = actModule; // 图元数组
        ////console.log("act:", act);
        return act;
    },

});