import Tool from "../Tool";
import Unpack from "../core/tool/Unpack";

import {
    ACT,
    ACTModule,
    ACTFrame,
    ACTSprite,
    ACTAction,
    ACTSequence
}
from "../core/Beans";
import {
    CLIENT_ACT,
    FILE_TYPE,
    ROTATION,
    SCALE, //使用的动画资源被放大的倍数
}
from "../core/adapter/ENUM";

//地图上的固定动画,不可以直接拖拽到编辑器中使用,由地图类控制
let HF_ACT_MAP = cc.Class({
    extends: cc.Component,

    properties: {
        FPS: 4, //动作帧率
        _mapData: null, // 地图数据
        _animation: null, // 地图动画数据
        _actFrames: [cc.Node], // 帧 序列
        // _actModules: [cc.SpriteFrame], // 图元 数组
        _isCanFrameUpdate: false, // 是否可以更新动画,需要加载纹理和数据后才可以
        _frameStepIndex: 0, //帧序更新步数
        // _currFrameID: 0, //当前动作序列帧的 帧序
        // _currFrameID_show: 0, //当前动作序列帧的 正在显示的帧序
        _frameDT_sum: 0, //当前帧失去的时间 秒级
        _frameDuration: 0, //帧持续时间 1/FPS 秒级
    },

    // use this for initialization
    onLoad: function () {
        this.setFPS(this.FPS);
    },
    // 设置当前动画的帧率
    setFPS(fps) {
        this.FPS = fps;
        this._frameDuration = 1 / this.FPS;
    },
    // called every frame
    update(dt) {
        if (this._isCanFrameUpdate) {
            this._frameDT_sum += dt;
            if (this._frameDT_sum > this._frameDuration) {
                this.actFrameUpdate();
                this._frameDT_sum = this._frameDT_sum - this._frameDuration;
            }
        }
    },

    // 设置动作资源文件ID
    setMapAct(mapData, animation) {
        this._mapData = mapData;
        this._animation = animation;
        this.initMapAnimation();
        this._isCanFrameUpdate = true;
    },
    initMapAnimation() {
        let mapData = this._mapData;
        let ani = this._animation;
        //帧 序列
        this._actFrames = new Array(ani.frameCount);
        for (let i = 0; i < this._actFrames.length; i++) {
            let frameIndex = i;
            let ani_frame = ani.frame[frameIndex];
            let moduleAppCount = ani_frame.moduleAppCount;
            this._actFrames[i] = new cc.Node("frame_node_" + i);
            for (let j = 0; j < moduleAppCount; j++) {
                let ma = ani_frame.moduleApp[j];
                let moduleID = ma.moduleID;
                let ma_module = mapData.mapModule[moduleID];
                
                let sprite_node = new cc.Node("sprite_node_" + j);
                sprite_node.parent = this._actFrames[i];
                let sprite = sprite_node.addComponent(cc.Sprite);

                let imgID = ma_module.imgID; // 图元所在图片ID //图元旋转及翻转情况
                let transformation = imgID; // 图元旋转及翻转情况
                imgID &= 0x0F;
                transformation = transformation >> 4;
                transformation = transformation << 8;
                
                let modulePng = mapData.bmpInfo[imgID].name;
                let url_png = "map_ani_png/" + modulePng;
                cc.loader.loadRes(url_png, cc.SpriteFrame, (err, spriteFrame) => {
                    if (spriteFrame) {
                        let actModuleRect = new cc.Rect(ma_module.x * SCALE,
                            ma_module.y * SCALE,
                            ma_module.w * SCALE,
                            ma_module.h * SCALE);

                        sprite.spriteFrame = new cc.SpriteFrame(spriteFrame.getTexture(), actModuleRect);
                        sprite.node.x = ma.x * SCALE;
                        sprite.node.y = -ma.y * SCALE;
                        sprite.node.anchorX = 0;
                        sprite.node.anchorY = 1;
                        switch (transformation) {
                            case ROTATION.HORI: //256|1 水平(左右)翻转<==>FLIP_HORI
                                sprite.node.scaleX = -1;
                                sprite.node.x += sprite.node.width;
                            break;
                            case ROTATION.VERT: //512|2 水平(左右)翻转后180度转动<==>FLIP_VERT垂直(上下)翻转
                                sprite.node.scaleY = -1;
                                sprite.node.y -= sprite.node.height;
                            break;
                            case ROTATION.R90: //768|3 90度转动.ok
                                sprite.node.angle = 90;
                                sprite.node.x += sprite.node.height;
                            break;
                            case ROTATION.R180: //1024|4 180度转动
                                sprite.node.angle = 180;
                                sprite.node.x += sprite.node.width;
                                sprite.node.y -= sprite.node.height;
                            break;
                            case ROTATION.R270: //1280|5 270度转动.ok
                                sprite.node.angle = 270;
                                sprite.node.y -= sprite.node.width;
                            break;
                            case ROTATION.HORI_90: //1536|6 水平(左右)翻转后90度转动.ok
                                sprite.node.scaleY = -1;
                                sprite.node.angle = 90;
                                sprite.node.x += sprite.node.height;
                                sprite.node.y -= sprite.node.width;
                            break;
                            case ROTATION.HORI_270: //1792|7 水平(左右)翻转后270度转动.ok
                                sprite.node.scaleY = -1;
                                sprite.node.angle = 270;
                            break;
                            default:
                            break;
                        }
                    }
                });
                //sprite_node.setPosition(ma.x * SCALE, ma.y * SCALE);
            }
        }
    },

    // 动画 帧更新
    actFrameUpdate() {
        this._actFrames[this._frameStepIndex].parent = null;
        this._frameStepIndex += 1;
        this._frameStepIndex = this._frameStepIndex % this._actFrames.length;
        this._actFrames[this._frameStepIndex].parent = this.node;
    },
});