/**
 * 这是一个复合的组件,包括 英雄造型动画+武器动画+脚下阴影
 */


import Unpack from "../core/tool/Unpack";
import {
    ACT_ID,
    ROTATION,
    SCALE, //使用的动画资源被放大的倍数
}
from "../core/adapter/ENUM";

//var HF_ACT = require("HF_ACT");

let HF_ACT_HERO = cc.Class({
    extends: cc.Component,
    
    properties: {
        //isLoop: true, //当前动作是否循环,不循环会停留在最后一帧
        isAutoZindex: false, //是否自动更新Z层级

        heroID: 2000001, //动画资源ID 
        actionID: 0, //动作序列编号,[0map待机,1战斗待机,2map奔跑,3前冲,4防御,5攻击,6返回,7死亡,8连击,9施法,10坐骑]
        _heroNode: null,
        _heroAct: null,

        heroName: "",   //人物名字,显示在头顶
        heroName_color: cc.Color,
        heroName_color_bg: cc.Color,
        _heroNameNode: null,

        weaponID: 0, //武器资源ID
        _weaponNode: null,

        mountsID: 0, //坐骑资源ID
        _mountsNode: null,
        _mountsAct: null,

        isShadow: false, //是否显示脚下阴影shadow
        _shadowNode: null,

    },

    // use this for initialization
    onLoad: function () {
        this.setIsShadow(this.isShadow);
        this.setHeroID(this.heroID);
        this.setWeaponsID(this.weaponID);
        this.setMountsID(this.mountsID);
        this.setHeroName(this.heroName,this.heroName_color,this.heroName_color_bg);
    },
    
    // 设置影子
    setIsShadow(isShadow) {
        this.isShadow = isShadow;
        if (this.isShadow) {
            if (this._shadowNode == null) {
                let url_png = "ui_png/shadow";
                cc.loader.loadRes(url_png, cc.SpriteFrame, (err, spriteFrame) => {
                    if (spriteFrame) {
                        this._shadowNode = new cc.Node('shadow');
                        var sp = this._shadowNode.addComponent(cc.Sprite);
                        sp.spriteFrame = spriteFrame;
                        this._shadowNode.parent = this.node;
                        this._shadowNode.setPosition(0, 0);
                        this._shadowNode.zIndex = -1; //人物遮挡坐骑
                    } else {
                        console.error("_loadSpriteFrame err:", err);
                    }
                });
            }
            // else {
            //     this._shadowNode.isAction = true
            // }
        }
    },
    // 设置动作资源文件ID
    setHeroID(heroID) {
        this.heroID = heroID;
        //console.log("this._heroNode:", this._heroNode);
        if (this._heroNode == null) {
            this._heroNode = new cc.Node('hero');
            this._heroAct = this._heroNode.addComponent('HF_ACT');
            this._heroAct.setActId(this.heroID);
            this.setActionID(this.actionID);
            this._heroNode.parent = this.node;
        }
    },
    //设置英雄的名字
    setHeroName(heroName, color, color_bg) {
        if (heroName.length < 1) {
            return;
        }
        this.heroName = heroName;
        if (this._heroNameNode == null) {
            this._heroNameNode = new cc.Node('heroName');
            this._heroNameNode.color = color;
            let nameLabel = this._heroNameNode.addComponent(cc.Label);
            nameLabel.string = this.heroName;
            nameLabel.fontSize = 26;
            nameLabel.lineHeight = 30;

            if (color_bg) {
                let outline = this._heroNameNode.addComponent(cc.LabelOutline);
                outline.color = color_bg;
            }

            this._heroNameNode.parent = this.node;
            this._heroNameNode.setPosition(0, 128);
        }
    },
    //设置人物的武器动画
    setWeaponsID(weaponID) {
        if (weaponID <= 0) {
            return;
        }
        this.weaponID = weaponID;
        //console.log("setWeaponsID this.weaponID:", this.weaponID);
        //console.log("setWeaponsID this._weaponNode:", this._weaponNode);
        if (this._weaponNode == null) {
            this._weaponNode = new cc.Node('weapon');
            var act = this._weaponNode.addComponent('HF_ACT');
            act.setActId(this.weaponID);
            act.setActionID(0);

            //设置回调方法需要绑定当前对象
            this._heroAct.set_actFrameUpdateCallBack(this.actFrameUpdateCallBack.bind(this));
            this._weaponNode.parent = this._heroNode;
        }
    },

    //设置人物的坐骑动画
    setMountsID(mountsID) {
        if (mountsID <= 0) {
            return;
        }
        this.mountsID = mountsID;
        //console.log("setMountsID this.mountsID:", this.mountsID);
        //console.log("setMountsID this._mountsNode:", this._mountsNode);
        if (this._mountsNode == null) {
            this._mountsNode = new cc.Node('mounts');
            this._mountsAct = this._mountsNode.addComponent('HF_ACT');
            this._mountsAct.setActId(this.mountsID);
            this._mountsAct.setActionID(0);
            this._mountsNode.parent = this.node;
            this._mountsAct.set_actLoadCompleteCallBack(this.actLoadCompleteCallBack.bind(this));
            this._heroAct.setActionID(ACT_ID.SITTING);
            this._heroNode.parent = this._mountsNode;
            this._heroNode.zIndex = 1;//人物遮挡坐骑

        }
    },

    //坐骑动画数据加载完成时回调,设置人物坐标
    actLoadCompleteCallBack(){
        let actData = this._mountsAct.getActSize();
        console.error("setMountsID2 actData:", actData);
        //let heroY = this._mountsAct._act.backGaugeTop * SCALE;
        let heroY = actData.H * SCALE;
        console.error("setMountsID heroY:", heroY);
        this._heroNode.setPosition(0, heroY); //高度需要调整
        this._heroNameNode.setPosition(0, heroY+100);
    },

    // 设置动作ID
    setActionID(actionID) {
        this.actionID = actionID;
        if (this._mountsAct) {
            this._mountsAct.setActionID(actionID);
        }
        else{
            this._heroAct.setActionID(actionID);
        }
    },

    // 设置动作ID
    setIsLoop(isLoop) {
        this._heroAct.setIsLoop(isLoop);
    },

    // 设置当前动画的帧率
    // setFPS(fps) {
    //     this.FPS = fps;
    //     this._frameDuration = 1 / this.FPS;
    // },

    // called every frame
    update(dt) {
        if (this.isAutoZindex) {
            this.node.zIndex = -this.node.y;
        }
        if (this._heroNameNode) { //名字始终超右
            this._heroNameNode.scaleX = this.node.scaleX;
        }
    },

    actFrameUpdateCallBack(weaponSprite)  {
        //console.log("actFrameUpdateCallBack weaponSprite:", weaponSprite);
        if (weaponSprite == null) {
            return;
        }
        
        if (this.weaponID > 0 && this._weaponNode != null) {
            let actSpriteRop = weaponSprite.mtrans << 8;
            //console.log("actFrameUpdate actSpriteRop:", actSpriteRop);
            switch (actSpriteRop) {
                case ROTATION.HORI: //256|1 水平(左右)翻转<==>FLIP_HORI
                    this._weaponNode.scaleX = -1;
                    break;
                case ROTATION.VERT: //512|2 水平(左右)翻转后180度转动<==>FLIP_VERT垂直(上下)翻转
                    this._weaponNode.scaleY = -1;
                    break;
                case ROTATION.R90: //768|3 90度转动.ok
                    this._weaponNode.angle = 90;
                    break;
                case ROTATION.R180: //1024|4 180度转动
                    this._weaponNode.angle = 180;
                    break;
                case ROTATION.R270: //1280|5 270度转动.ok
                    this._weaponNode.angle = 270;
                    break;
                case ROTATION.HORI_90: //1536|6 水平(左右)翻转后90度转动.ok
                    this._weaponNode.scaleY = -1;
                    this._weaponNode.angle = 90;
                    break;
                case ROTATION.HORI_270: //1792|7 水平(左右)翻转后270度转动.ok
                    this._weaponNode.scaleY = -1;
                    this._weaponNode.angle = 270;
                    break;
                default:
                    break;
            }

            //let ma_module = this._act.actModule[weaponSprite.moduleID]; // 当前MODULE
            let module_paint_x = weaponSprite.x;
            let module_paint_y = -weaponSprite.y;
            //console.log("actFrameUpdate _weaponNode module_paint_x:", module_paint_x);
            this._weaponNode.setPosition(module_paint_x * SCALE, module_paint_y * SCALE);
        }
    },

});