/*******************************************************************************
 * CopyRight (c) HYTC Ltd. All rights reserved.
 * Filename:    Beans.js
 * Creator:   GaoLei
 * Version:   0.0
 * Date: 	 2018-07-11
 * Description: 数据模型
 *******************************************************************************/
console.log(" 1 load Beans.js");

import * as ENUM from './adapter/ENUM'

//创建 调用者的多个对象
function createBeanArray(arraySize) {
	//var array = new Array(arraySize).fill( () => new this());
	var array = new Array(arraySize); //new Array(arraySize).fill( new this() );
	//console.log("createBeanArray arraySize=", arraySize)
	//console.log("createBeanArray this=", this)
	for (var i = 0; i < arraySize; i++) {
		array[i] = new this();
	}
	return array;
}

export class SuperBean {
	constructor() {
		this.createBeanArray = createBeanArray; //对象方法
	}
	_init() {
		this.constructor(); //对象方法
	}
	reset() {
        this._init(); //对象方法
	}
}
//类方法 
SuperBean.createBeanArray = createBeanArray;
SuperBean._init = function () {
	this.constructor()
}
SuperBean.reset = function () {
	this.reset()
}



/**
 * @author gaolei by 2012-08-16 
 * 动画
 */
export class ACT {
	constructor() {
		this.backGaugeTop = -16; //Int8 原点与四边距 上
		this.backGaugeBottom = 0; //Int8 原地与四边距 下
		this.backGaugeLeft = -8; //Int8 原地与四边距 左
		this.backGaugeRight = 8; //Int8 原地与四边距 右
		this.keyFramesSum = 0; //Int8 攻击动作的关键帧数量，有多少个
		this.actActionCount = 0; //Int8 动作数组长度
		this.actFrameCount = 0; //Int8 帧数组长度
		this.actModuleCount = 0; //Int8 图元数组 数组长度
		this.bmpWidth = 0; //uint16 图片宽度
		this.bmpHeight = 0; //uint16 图片高度

		this.bmpBuf = null; //UIImage();	//图片数据
		this.actAction = []; //[ACTAction]();	//动作数据
		this.actFrame = []; //[ACTFrame]();   //帧数据
		this.actModule = []; //[ACTModule]();	//图元数组
		this.keyFrames = new Array(16); //[Int](repeating: 0, count: 16);//攻击动作的关键帧数据
		this.pngFrames = new Map(); //WX版新增,将帧中多图元合成一张图,用于绘制<id,png>
	}
}
/**
 * 动画数据
 */
export class ACTAction {
	constructor() {
		this.sequenceCount = 0; //Int8 帧数量
		this.actSequence = []; //[ACTSequence]();	//帧数据集
	}
}

/**
 * 帧数据
 */
export class ACTFrame {
	constructor() {
		this.actSpriteState = 0; //Int8 帧，状态，0=普通帧，1是关键帧，...
		this.actSpriteCount = 0; //Int8 图元数量
		this.actSprite = []; //[ACTSprite]();//图元数组
	}
}

/**
 * 图元数据
 */
export class ACTModule {
	constructor(x = 0, y = 0, w = 0, h = 0) {
		this.x = x; // int8 图元所在图片上的坐标
		this.y = y; // int8 图元所在图片上的坐标
		this.w = w; // int8 图元所在图片上的宽度
		this.h = h; // int8 图元所在图片上的高度
	}
}
/**
 * 动画帧数据
 */
export class ACTSequence {
	constructor(frameId = 0, duration = 0) {
		this.frameId = frameId; // Int8 帧ID
		this.duration = duration; // Int8 持续
	}
}

/**
 * 图元在帧中应用时的数据
 */
export class ACTSprite {
	constructor(moduleID = 0, x = 0, y = 0, mtrans = 0) {
		this.moduleID = moduleID; // Int8 图元ID
		this.x = x; // int8 图元偏移坐标
		this.y = y;
		this.mtrans = mtrans; // char 图元旋转及翻转情况(需要修改)
	}
	reset() {
		this.moduleID = 0;
		this.x = 0;
		this.y = 0;
		this.mtrans = 0;
	}
}

/**
 * 动画数据
 */
export class Animation {
	constructor() {
		this.frameCount = 0; //int8 帧数量
		this.frame = []; //[Frame](); //帧的数组
	}
}

/**
 * 动画在地图上应用时的数据
 */
export class AnimationApp {
	constructor() {
		this.animationID = 0; //int8 动画ID
		this.x = 0; //int8 动画在地图上的tile坐标
		this.y = 0;
		this.map_y = 0; //int16 在地图上的坐标Y的最大值 用于遮挡关系
	}
}

/**
 * 分区信息
 */
export class Arealist_Item extends SuperBean {
	constructor() { super();
		this.id = 0;
		this.style = 0;
		this.state = 0;
		this.color = 0;
		this.smod_id = "";
		this.descr = "";
		this.name = "";
	}
}

export class ArenaData extends SuperBean {
	constructor() { super();
		this.isCanToFighting = false; //Bool 是否可以进入战斗，需要500回包啊！
		this.autoFight 	= 0; //uint8 503.返回.1代表开启，2代表失败，其他代表非自动战斗
		this.waitType 	= 0; //uint8 505.回合等待//type(1新回合选择,2等待对方 3 战斗结束?),剩余时间(秒)
		this.type 		= 0; //uint8 B 斗类型
		this.ID 		= 0; //uint8 B 场景类型ID
		//如果 以下四个值全为0，则表示为全地图，没有子地图,否则按起坐标从大地图上获取子地图
		this.startTileX = 0; //uint8子地图 左上角 地图坐标 tile索引
		this.startTileY = 0; //uint8
		this.endTileX	= 0; //uint8子地图 右下角 地图坐标 tile索引
		this.endTileY	= 0; //uint8
		this.fighterSum = 0; //uint8 B 参战人数
		this.autoFightOffx = 0; //int16 自动战斗图片的绘制偏移量
		this.waitTime 	= 0; //uint16 505.回合等待.剩余时间(秒)
		this.menuMask 	= [0, 0, 0, 0, 0, 0, 0, 0]; //uint16 501.战斗操作限制.掩码方式.(1攻击 2技能 4招降 8物品 16招将 32逃跑 64防御)
		this.myName 	= ""; //char[18] p 己方名称
		this.otherName 	= ""; //char[18] p 对方名称
		this.fighterDatas = Fighter.createBeanArray(8); //Fighter[MAX_FIGHTERS] 战士数据数组
	}
}

/** 
 * 用来加载图片的结构 //主要用于地图资源图片
 */
export class BmpInfo extends SuperBean {
	constructor() { super();
		this.width = 0;
		this.height = 0;
		this.pData = {};
		this.name = ""; //不包含扩展名
	}
}
/*
 * 66 聊天频道
 */
export class Chat_Item extends SuperBean {
	constructor() { super();
		this.part_type	= 0; //uint8
		this.type 		= 0; //uint16频道类型
		this.sendID 	= 0; //int32发送用户ID
		this.part_id 	= 0; //int32
		this.content 	= ""; //String 内容
		this.part_desc 	= ""; //String 附件说明
		this.name 		= ""; //char name[20]发送用户昵称
		this.time		= ""; //char name[20]时间
	}
}

/**
 * 66.聊天频道
 */
export class ChatRoom extends SuperBean {
	constructor() { super();
		this.type		= 0; // int8
		this.new_flag	= 0; // int8 聊天频道 提示 掩码
		this.list_loading = 0; // int8 聊天信息列表读取标示 (防止用户多次操作造成堵塞)
		this.reFresh	= false; // Bool 聊天区刷新标示
		this.list_page	= 0; // int16
		this.list_h 	= 0; // int16
		this.size 		= 0; // int16
		this.AREA_Y 	= 0; // uint16
		this.item 		= Chat_Item.createBeanArray(40); // Chat_Item[40] 聊天内容缓存
	}
}

/**
 * 飘动的云//宽高就不放这里了，因为是固定的
 */
export class Clouds extends SuperBean
{
	constructor() { super();
		this.map_x 				= 0; // int16
		this.map_y 				= 0; // int16
		this.map_destination_x	= 0; // int16
		this.map_destination_y	= 0; // int16
	}
	getPosx() {
		return Math.floor(this.map_x);
	}
	getPosy() {
		return Math.floor(this.map_y);
	}
	setPosx(x) {
		this.map_x = x;
	}
	setPosy(y) {
		this.map_y = y;
	}
}

export class DownloadFile extends SuperBean {
	constructor() { super();
		this.backState = 0; //下载完成后的返回 游戏状态 0为不返回了！
		this.fileSum = 0; //文件数量
		this.iconID = 0; //缩略图ID
		this.mapNameArray = [""]; //文件名数据列表
		this.mapName = ""; //地图名
		this.info = ""; //地图描述
	}
}

/**
 *  
 */
export class DownloadPercent extends SuperBean {
	constructor() { super();
		this.isNeedUtoC = false; //是否需要把文件名转码 UtoC
		this.isFinish = false; //当前文件是否下载完成
		this.isAllFinish = false; //当前全部文件是否下载完成
		this.linkCounter = 0; //重连次数
		this.currLoadingPercent = 0; //下载单个文件进度的百分比
		this.percentFileCount = 0; //下载文件数量的百分比
		this.fileIndex = 0; //当前文件索引
		this.fileSum = 0; //文件数量
		this.currFileName = ""; //当前下载完成的文件名
		this.fileNameArray = [""]; //文件名数据列表
	}
}

/**
 * 战斗中能使用的物品，红蓝黄等
 */
export class Drug extends SuperBean {
	constructor() { super();
		this.type 		= 0; //物品类型，1红，2兰，3黄=双回
		this.id 		= 0; //物品ID
		this.sum 		= 0; //数量
		this.icon_id 	= 0; //图片ID
		this.name 		= ""; //物品名称
		this.describe 	= ""; //物品描述
	}
}

/**
 * 战斗动画脚本
 */
export class Fight extends SuperBean {
	constructor() { super();
		this.index1		= 0; // uint8 B 发起攻击者
		this.index2 	= 0; // uint8 B  被攻击者
		this.attackType = 0; // uint8 B  攻击类型
		this.aimSum 	= 0; // uint8 B 同时受到攻击的人数
		this.wxState 	= 0; // uint8 B 五行相克
		this.ability 	= 0; // uint16 H 具体属性（技能ID 物品ID 招将indexID 连击数）
		this.geniusState = 0; // uint8 B 天赋状态/0无 1显示在攻击方 2显示在被攻击方 3 显示在画面中心
		this.skillActID_forane = 0; // uint32 本回合使用的技能动画ID远景,//用户释放动画使用
		this.skillActID_nearey = 0; // uint32 本回合使用的技能动画ID近景,//用户释放动画使用
		this.geniusName = ""; // char[10] P 天赋名称
		this.name 		= ""; // char[24] P 技能/物品/副将 名称
		//	Aim[]	aim = Aim.createBeanArray(4);	//威力最大也就4个吧！
		this.aim_index	= new Array(4); //B
		this.aim_state	= new Array(4); //B 本次攻击是否有效果
		this.aim_c_hp	= new Array(4); //i HP变化值
		this.aim_c_mp	= new Array(4); //i MP变化值
	}
}

/**
 * 500 战斗数据
 */
export class Fighter extends SuperBean //,moveable
{
	constructor() { super();
		this.indexID	= 0; // uint8 B 位置索引//与人所在数组索引绑定
		this.sex		= 0; // uint8 B 性别
		this.attrib		= 0; // uint8 B 五行属性
		this.speed		= 0; // uint8 B 速度第几
		this.skill_1	= 0; // uint8 B 技能序号
		this.skill_2	= 0; // uint8 B
		this.skill_3	= 0; // uint8 B
		this.skill_4	= 0; // uint8 B
		this.objtype	= 0; // uint8 B ( npc0 玩家1 仙宠2 )
		this.actionID	= 0; // uint8 B 
		this.face_to	= 0; // uint8 B
		this.isHold		= false; // Bool 是否保持不动画？

		this.selectState	= 0; // uint8 选择菜单的时候是否可选项
		this.hurtType		= 0; // uint8 伤害类型(0.无，1.普通，2.技能，...)
		this.hurtType2		= 0; // uint8 伤害类型2(1兰，2红，3绿，4紫)
		this.avoidFrames	= 0; // int8 后侧N个像素,并保持avoidFrames帧
		this.convalescence	= 0; // int8 被攻击后的恢复期，倒计时的帧数
		this.hurtOffYIndex	= 0; // int8 伤害显示计数器

		this.roletype	= 0; // uint16 H 职业
		this.state		= 0; // uint16 H 人物状态掩码 0正常 1封 2围 4攻 8乱 16毒 32速 64隐
		this.stateAdd	= 0; // uint16 H 人物状态掩码变化量	0状态没变化, 1新曾状态, 2减少状态//目前需求，只需知道 封的新增
		this.level		= 0; // uint16
		this.screen_x	= 0; // int16 自己所在屏幕的位置
		this.screen_y	= 0; // int16 
		this.opponent_x	= 0; // int16 对手攻击时的位置
		this.opponent_y = 0; // int16 
		this.speedValue	= 0; // int32 i	速度值
		this.maxHp		= 0; // int32 i
		this.maxMp		= 0; // int32 i
		this.hp 		= 0; // int32 i
		this.mp			= 0; // int32 i
		this.clothesID	= 0; // int32 i	造型
		this.weaponID	= 0; // int32 i	武器
		this.objectid	= 0; // int32 i	( roleid, 仙宠id )
		this.hurt_c_mp	= 0; // int32 伤害数值
		this.hurt_c_hp	= 0; // int32 伤害数值
		this.portraitID = 0; // int32 真实头像ID
		this.name		= ""; // char[18] p
		this.sendData	= new SendData(); // SendData 玩家操作数据，己方特有
	}
	//更换2个战士的数据，left=right 用右侧数据赋值给左侧
	static Fighter2Fighter(left, right) {
		left.indexID = right.indexID; //B	位置索引//与人所在数组索引绑定
		left.sex = right.sex; //B	性别
		left.attrib = right.attrib; //B	五行属性	
		left.speed = right.speed; //B	速度第几
		left.skill_1 = right.skill_1; //B	技能序号
		left.skill_2 = right.skill_2; //B	
		left.skill_3 = right.skill_3; //B	
		left.skill_4 = right.skill_4; //B	
		left.objtype = right.objtype; //B	( npc0 玩家1 仙宠2 )
		left.actionID = right.actionID;
		left.face_to = right.face_to;
		left.isHold = right.isHold; //是否保持不动画？
		left.selectState = right.selectState; //选择菜单的时候是否可选项
		left.hurtType = right.hurtType; //伤害类型(0.无，1.普通，2.技能，...)
		left.hurtType2 = right.hurtType2; //伤害类型(0.无，1.普通，2.技能，...)
		left.avoidFrames = right.avoidFrames; //后侧N个像素,并保持avoidFrames帧
		left.convalescence = right.convalescence; //被攻击后的恢复期，倒计时的帧数
		left.hurtOffYIndex = right.hurtOffYIndex; //伤害显示计数器
		left.roletype = right.roletype; //H	职业
		left.state = right.state; //H	人物状态掩码		0正常 1封 2围 4攻 8乱 16毒 32速 64隐
		left.stateAdd = right.stateAdd; //	人物状态掩码变化量	0状态没变化, 1新曾状态, 2减少状态//目前需求，只需知道 封的新增
		left.level = right.level; //B
		left.screen_x = right.screen_x; //自己所在屏幕的位置
		left.screen_y = right.screen_y;
		left.opponent_x = right.opponent_x; //对手攻击时的位置
		left.opponent_y = right.opponent_y;
		left.speedValue = right.speedValue; //i
		left.maxHp = right.maxHp; //i
		left.maxMp = right.maxMp; //i
		left.hp = right.hp; //i
		left.mp = right.mp; //i
		left.clothesID = right.clothesID; //i	造型
		left.weaponID = right.weaponID; //i	武器
		left.objectid = right.objectid; //i	( roleid, 仙宠id )
		left.hurt_c_mp = right.hurt_c_mp; //伤害数值
		left.hurt_c_hp = right.hurt_c_hp; //伤害数值	
		left.portraitID = right.portraitID; //真实头像ID
		left.name = right.name; //p
		left.sendData.actID = right.sendData.actID; //玩家操作数据，己方特有
		left.sendData.p1 = right.sendData.p1; //玩家操作数据，己方特有
		left.sendData.p2 = right.sendData.p2; //玩家操作数据，己方特有
		left.sendData.p3 = right.sendData.p3; //玩家操作数据，己方特有
		left.sendData.p4 = right.sendData.p4; //玩家操作数据，己方特有
		left.sendData.p5 = right.sendData.p5; //玩家操作数据，己方特有
	}
	getPosx() { return this.screen_x; }
	getPosy() { return this.screen_y; }
	setPosx(x) { this.screen_x = x; }
	setPosy(y) { this.screen_y = y; }
}
/**
 * 战斗结束数据
 */
export class FightOver extends SuperBean {
	constructor() { super();
		this.result = 0; // uint8 B 战斗结果.输赢 1赢 0输
		this.actId	= 0; // uint16 H 0返回地图，其他值请求联网
		this.expSum = 0; // uint8 B 获得经验的人员数量
		this.currMSGindex = 0; // uint8 当前显示的信息索引
		this.smgSum = 0; // uint8 信息数量
		this.fightEXPDatas_indexID = new Array(4); // int[4] 战士索引
		this.fightEXPDatas_info = new Array(4); // String[4] 经验描述信息//需要自己释放
		this.SmgDatas = [""]; // String[] 战斗结束后的信息
	}
}
/**
 * 用于存储战斗录像530的数据
 */
export class FightRecord extends SuperBean {
	//战斗录像标识，当前回合，总回合数，录像ID，（角色索引，速度）
	constructor() { super();
		this.state		= 0; //战斗录像标识
		this.round_curr	= 0; //当前回合
		this.round_sum	= 0; //总回合数
		this.id			= 0; //录像ID
		this.play_state = 0; //播放状态
		this.UI_type	= 0; //录像UI的类型
		this.UI_x		= 0;
		this.UI_xoff	= 0;
		this.UI_y_0		= 0;
		this.UI_y_1		= 0;
		this.UI_y_2		= 0;
		this.UI_ox		= 120;
		this.UI_len		= 4;
	}
	reset() {
		this.state		= 0; //战斗录像标识
		this.round_curr = 0; //当前回合
		this.round_sum	= 0; //总回合数
		this.id			= 0; //录像ID
		this.play_state	= 0; //播放状态
	}
}

export class FightRound extends SuperBean {
	constructor() { super();
		this.isCanFighting		= false; // Bool 是否可以开始战斗，需要510回包啊！
		this.isFightOver		= false; // Bool 本回合后是否结束战斗了？
		this.fightSum			= 0; // uint8 B 回合数量
		this.fighterUpdateSum	= 0; // uint8 B 需要更新数据的人数
		this.fightDatas = Fight.createBeanArray(16); // Fight[16] 回合动画数据集.最多16次
		//	FighterUpdate[] fighterUpdateDatas = FighterUpdate.createBeanArray(ENUM.MAX_FIGHTERS);
		this.fighterUpdateDatas_index	= new Array(ENUM.MAX_FIGHTERS); // int[16] B
		this.fighterUpdateDatas_state	= new Array(ENUM.MAX_FIGHTERS); // int[16] H 人物状态掩码0正常 1封 2围 4攻 8乱 16毒 32速 64隐
		this.fighterUpdateDatas_hp		= new Array(ENUM.MAX_FIGHTERS); // int[16] i HP值
		this.fighterUpdateDatas_mp		= new Array(ENUM.MAX_FIGHTERS); // int[16] i MP值
	}
}
/**
 * 335.飞天场景切换
 */
export class FlyingRole // : moveable
{
    reset() {
		this.speed = 0; //Int8 飞行速度
		this.sex = 0; //Int8 性别
		this.level = 0; //Int8 等级
		this.roleType = 0; //uint16 职业

		this.origin_x = 0; //int16 飞行起点
		this.origin_y = 0;
		this.destination_x = 0; //int16 飞行终点
		this.destination_y = 0;

		this.ID = 0; //int32 ID
		this.clothesID = 0; //int32 造型ID
		this.weaponID = 0; //int32 武器ID
		this.aircraftID = 0; //int32 飞行道具ID
		this.name = ""; //char[12] 名称
	}
    constructor() {
        this.reset();
    }
	getPosx() {
		return this.origin_x;
	}
	getPosy() {
		return this.origin_y;
	}
	setPosx(x) {
		this.origin_x = x;
	}
	setPosy(y) {
		this.origin_y = y;
	}
}
/**
 * 帧数据
 */
export class Frame {
    reset() {
		this.moduleAppCount = 0; //int8 图元数量
		this.moduleApp = []; // [ModuleApp](); //图元数组
	}
    constructor() {
        this.reset();
    }
}

/**
 * 用于显示的动画，仅需要从头到尾播放1次
 */
export class GIF extends SuperBean {
	constructor() { super();
		this.actionID		= 0; // uint8 
		this.face_to		= 0; // uint8
		this.frameIndex		= 0; // uint8 帧序列
		this.max_frmae		= 0; // uint8 该动作下的帧总数
		this.posType		= 0; // uint8 是否是地图坐标？默认不是//坐标类型
		this.layer			= 0; // int8 层次关系，如果需要分层显示的话
		this.loop			= 0; // int8 播放次数，-1 循环播放，
		this.isAutoDel		= false; // Bool 是否自动删除,播放完成就删除
		this.isShowFinished = false; // Bool 是否显示完
		this.isShowScreen	= false; // Bool 是否全屏显示
		this.screen_x		= 0; // int16 
		this.screen_y		= 0; // int16 
		this.showID			= 0; // int32 区分要显示的动画
		this.actID			= 0; // int32 
		this.actGamePlayer	= null;
		this.fighter		= null;
	}
}
export class GLN_ITEM {
    reset() {
		this.type = 0; //B 文字 10白色文字 11黑色文字 12红 13绿 14蓝 15黄 16红底白 17绿底白 18蓝底白 19黄底白 20 灰色
		this.is_newLine = 0; //B (0无 1之前换行 2画面中间开始绘制 3之前换行并且本行底色变化)
		this.isAction = false; //是否已经触发了该控件
		this.x = 0;
		this.y = 0;
		this.w = 0;
		this.h = 0;
		this.charsetIndex = 0; //编码序号
		this.content = ""; //Hp	显示内容/输入默认值/图片路径
		this.subSendData = new SendData(); //Hiiiii返回ACT,返回p1,返回p2,返回p3,返回p4,返回p5,
	}
    constructor() {
        this.reset();
    }
}
/**
 * @author gaolei by 2012-08-16
 */
export class GLN_PAGE extends SuperBean {
	constructor() { super();
		this.whereFrom = 0; //从哪个场景到的通用界面?
		this.defActionType = 0; //B		默认操作类型
		this.defTabID = 0; //B		默认页签id
		this.actSum = 0; //B		动作元素个数,
		this.NumSLTSum = 0; //数字调节器的个数

		//	int8		moveTab;		//移动时
		this.currTab = 0; //当前tab index;
		this.pageSum = 0; //B		多页签个数,
		this.isReturnToMap = 0; //B		马上返回地图，
		this.isNeedSendData = 0; //是否需要回传给服务器数据，默认不需要
		this.isAction = false; //是否已经触发了控件
		this.isHasBack = false; //是否有返回
		this.ID = 0; //H		界面ID

		// 	int16		moveFocus;		//保存操作时，光标所在位置
		this.moveTime = 0; //保存操作的时间，帧数

		this.NumSLTDatas = null; //保存 数字调节器的值
		this.subTabs = null; //{BBBPBH}	( 页签id,页签type(样式 1信息),页签title,页签背景,栏位个数,)
		this.input_item = null; //保留一个用于获取输入内容的指针
		this.action_item = null; //保留一个用于被点击过的控件的指针
		this.title = ""; //BP	页面标题
		this.glnSendData = new SendData(); //Hiiiii返回ACT,返回p1,返回p2,返回p3,返回p4,返回p5,
		this.glnSendData_OK = new SendData(); //Hiiiii返回ACT,返回p1,返回p2,返回p3,返回p4,返回p5,
	}
}
/**
 * @author gaolei by 2019-04-22 初期帮助的指引箭头
 */
export class HelpArrows {
    reset() {
		this.state = false; // B 0不显示，1显示
		this.x = 0; // H 目标坐标
		this.y = 0; // H
	}
    constructor() {
        this.reset();
    }
}
/**
 * @author gaolei by 2012-08-16 界面内容点击区信息
 */
export class ItemPoint extends SuperBean {
	constructor() { super();
		this.x1 = 0; // 坐标
		this.y1 = 0;
		this.x2 = 0; // 坐标
		this.y2 = 0;
		this.index = 0; // Item 索引
	}
}

/**
 * 登录，角色选择数据
 */
export class Login_Role_Info extends SuperBean {
	constructor() { super();
		this.state = 0;
		this.roletype = 0;
		this.head = 0;
		this.src_id = 0;
		this.id = 0;
		this.name = "";
		this.lvl = "";
		this.sitename = "";
	}
}
/**
 * 地图 传送门 信息
 */
export class Map_Door {
	constructor() {
        Map_Door.mapDoorW = 52; // 门宽 增加碰撞检测区域 以防止自动寻路走不到门里
        Map_Door.mapDoorH = 30; // 门高

		this.notChangMap = false; //Int8 1=不需要切换场景资源，0=需要切换场景资源
		this.state = 0; //Int8 门状态
		this.minimumLevelLimit = 0; //uint16 此门最低等级限制
		this.exitID = 0; //uint16 出口ID
		this.mapDoorX = 0; //uint16 门坐标
		this.mapDoorY = 0; //uint16 门坐标
		this.showTime = 0; //uint16 门显示的时间
		this.mapDoorID = 0; //int32 门ID
		this.prompted = ""; //String 提示语
		this.doorName = ""; //char[12] 门名称，通往哪里的提示
	}
}
/**
 * 110.地图信息
 */
export class Map_Info extends SuperBean {
	constructor() { super();
		this.isHasArenaBg = false; //是否自带战斗背景
		this.isMultiMap = false; //是否是多个地图块
		//如果 以下四个值全为0，则表示为全地图，没有子地图,否则按起坐标从大地图上获取子地图
		this.startTileX = 0; //子地图 左上角 地图坐标 tile索引
		this.startTileY = 0;
		this.endTileX = 0; //子地图 右下角 地图坐标 tile索引
		this.endTileY = 0;
		this.entryMode = 0; //进入地图的特效
		this.mapDoorCount = 0; //出口数量
		this.map_x = 0; //地图上坐标
		this.map_y = 0; //地图上坐标
		this.ID = 0; //地图ID
		this.beginTimeRecord = 0; //进入地图的初始时间
		this.name = ""; //地图名称
		this.mapDoor = null; //地图上的门最多8个
	}
}
/**
 * @author gaolei by 2019-04-22 220.场景npc更新
 */
export class Map_NPC_List extends SuperBean {
	constructor() { super();
		this.npcListSize = 0; // 当前地图玩家数量
		this.npcList = []; // 地图上显示玩家列表
	}
}

/**
 * 地图上 所有PC的信息列表
 */
export class Map_User_Info extends SuperBean //,moveable
{
	constructor() { super();
		this.SPEED = 0.4; //移动一个TILE所需要的时间 //移动速度6
		this.sex = 0; //性别
		this.type = 0; //角色类型,NPC=1,PC=2
		this.hauntType = 0; //出没方式
		this.face_to = 0; //人物面朝方向
		this.actionID = 0; //动画ID,也表示该人状态
		this.AI = 0; //NPC AI
		this.actOffFrame = 0; //动作偏移帧
		this.flyFrame = 0; //飞行帧计数器
		this.style = 0; //B	名字的颜色样式
		this.isShowName = false; //是否需要显示名字
		this.level = 0; //等级
		this.roleType = 0; //职业
		this.map_x = 0; //地图上坐标
		this.map_y = 0; //地图上坐标
		this.map_destination_x = 0; //地图上的 目的地坐标,起点也用屏幕坐标才可以
		this.map_destination_y = 0; //地图上的 目的地坐标
		this.clothesID = 0; //造型ID
		this.weaponID = 0; //武器ID
		this.mountID = 0; //坐骑ID
		this.hint = 0; //提示状态
		this.aircraftID = 0; //飞行器ID 1500000+B
		this.portraitID = 0; //头像ID
		this.ID = 0; //ID
		this.dialogue = ""; //默认的对话
		this.name = ""; //昵称
	}

	getPosx() { return this.map_x; }
	getPosy() { return this.map_y; }
	setPosx(x) { this.map_x = x; }
	setPosy(y) { this.map_y = y; }
}
/**
 * 115返回数据
 */
export class Map_User_List {
	constructor() {
		this.type = 0; //Int8 玩家列表类型.0=玩家，1=NPC，2=野怪
		this.startIndex = 0; //int16 当前页面开始的选项索引,数组里的i
		this.currCounts = 0; //int16 玩家列表中ITEM项数量合
		this.currPageMax = 0; //int16 当前列表最多的选项，counts<6?counts:6
		this.seleIndex = 0; //int16 列表当前选中项[0,currPageMax]
		this.currIndex = 0; //int16 当前列表光标索引[0,counts]，是seleIndex+
		this.info = ""; //char[20] 当前地图上全部玩家数量
	}
}

export class MAP extends SuperBean {
	constructor() { super();
		this.imgNameCount = 0; //地图上使用的图片数量
		this.moduleCount = 0; //图元数组 数组长度
		this.animationCount = 0; //地图上的动画 数组长度
		this.animationAppOBJCount = 0; //地图上	建筑层的动画 数组长度
		this.animationAppNPCCount = 0; //地图上	NPC层的动画 数组长度

		//如果 以下四个值全为0，则表示为全地图，没有子地图
		this.startTileX = 0; //子地图 左上角 地图坐标 tile索引
		this.startTileY = 0;
		this.endTileX = 0; //子地图 右下角角 地图坐标 tile索引
		this.endTileY = 0;

		this.currTileXcount = 0; //当前地图(子地图)的宽度 TILE个数
		this.currTileYcount = 0; //
		this.tile_x_count = 0; //地图横向瓦片数量
		this.tile_y_count = 0; //地图纵向瓦片数量
		this.map_px_width = 0; //(MAP_TILE_W*MAP_TILE_X_SUM) //地图宽度PX
		this.map_px_height = 0; //(MAP_TILE_H*MAP_TILE_Y_SUM) //地图高度PX

		this.mapID = 0; //我所在地图ID
		this.mapData = null; //地图数据
		this.mapModule = null; //图元数组
		this.animation = null; //地图上的动画
		this.animationAppOBJ = null; //地图上	建筑层的动画
		this.animationAppNPC = null; //地图上	NPC层的动画
		this.bmpInfo = BmpInfo.createBeanArray(32); //地图图片资源
		this.tileImage = null; //地图TILE整张图片
	}
}
/**
 * @author gaolei by 2019-04-22 任务指引提示
 */
export class MapChange extends SuperBean {
    constructor() { super();
		this.notChangMap = false;
		this.type = 0;
		this.map_x = 0;
		this.map_y = 0;
		this.mapID = 0;
	}
}

export class MapChangeFlying extends SuperBean {
	constructor() { super();
		this.flyPlayersSUM = 0; //其他玩家数量
		this.playersIndex = 0; //其他玩家索引//显示用
		this.aircraftID = 0; //飞行道具ID
		this.map_destination_x = 0; //目的地坐标
		this.map_destination_y = 0; //目的地坐标
		this.mapID = 0; //目的地地图ID
		this.mapName = ""; //目的地名称
		this.PC = new FlyingRole(); //我自己
		this.player = null; //飞行中的其他玩家
	}
}
/**
 * 791.
 */
export class MapFileInfo {
	constructor() {
		this.isShowIcon = false; //Boolean 是否已经显示图标了，不显示时，绘制默认图
		this.isFinish = false; //Boolean 是否已经下载完毕
		this.mapID = 0; //uint16 非偏移的地图编号
		this.mapName = ""; //char[16]
	}
}
/**
 * @author gaolei by 2012-08-16 
 * 图元数据
 */
export class Module {
	constructor(_imgID, _x, _y, _w, _h) {
		this.imgID = _imgID;
		this.x = _x;
		this.y = _y;
		this.w = _w;
		this.h = _h;
	}
}

/**
 * @author gaolei by 2012-08-16 
 * 图元在帧中应用时的数据
 */
export class ModuleApp {
	constructor() {
		this.moduleID = 0; //图元ID
		this.x = 0; //图元偏移坐标
		this.y = 0;
	}
}

/**
 * 15.16.17.
 */
export class MsgBox extends SuperBean {
	constructor() { super();
		this.bnt_sum = 0; //按钮个数
		this.draw_OK = 0;
		this.sel_index = 0; //选项
		this.net_cls = 0; //点击联网 等待刷新关闭

		//消息框类型 1确认消息 2 选择消息(左取消 右连接) 3左右取消 (双连接) 5 单按钮联网 17升级 100平台自己使用
		//	1确认消息 
		//	2选择消息(左取消 右连接) 
		//	3左右取消 (双连接) 
		//	4双连接带取消
		//	5 单按钮联网 
		//	9.
		//	15单按钮带actid //被踢提示
		//	17升级 
		//	100 101平台自己使用
		this.type = 0;
		this.h = 0; //对话框高度
		this.identifying = 0; //记录消息标识，100战斗已经结束，200战斗发起失败,500强制PK
		this.size = 0; //消息框尺寸
		this.time = 0; //确认型对话框 生成时间
		this.imgid = 0; //图片
		this.text = ""; //消息框类型 80字
		this.but_name = ""; //消息框按钮名称
		this.but_cancel_name = ""; //消息框按钮名称
		this.act = new SendData();
		this.act_cancel = new SendData();
		this.but_names = new Array(4);
		this.but_acts = SendData.createBeanArray(4);
	}
    reset() {
        this.draw_OK = 0;
        this.sel_index = 0; // 选项
        this.net_cls = 0; // 点击联网 等待刷新关闭
        this.type = 0; // 消息框类型 1确认消息 2 选择消息(左取消 右连接) 3左右取消 (双连接) 5 单按钮联网 100平台自己使用
        this.h = 0; // 对话框高度
        this.identifying = 0; // 记录消息标识，100战斗已经结束，200战斗发起失败,500强制PK
        this.size = 0; // 消息框尺寸
        this.time = 0; // 确认型对话框 生成时间
        this.imgid = 0; // 图片
        this.text = ""; // 消息框类型 80字
        this.but_name = ""; // 消息框按钮名称
        this.but_cancel_name = ""; // 消息框按钮名称
        this.act.reset();
        this.act_cancel.reset();
        this.but_names = new Array(4);
        this.but_acts = SendData.createBeanArray(4);
    }
}
MsgBox.offx = [
	[0, 0, 0, 0],
	[-48, 48, 0, 0],
	[-75, 0, 75, 0],
	[-99, -33, 33, 99]
];

/**
 * @author gaolei by 2019-04-22 出战时代的副将
 */
export class MyAssistant {
    reset() {
        this.count = 0;
        this.assistant = User_Info.createBeanArray(ENUM.MAX_CT_SUM); // 副将信息
    }
	constructor() {
        this.reset();
	}
}

/**
 * @author gaolei by 2019-04-22 战斗中显示 收服道具数量 0=普通,1=银葫,2=金葫
 */
export class MyGoods {
    reset() {
		this.id = 0; // 物品编号//记录要使用的物品ID/宠物ID等
		this.calabash = [0,0,0]; // 0=普通,1=银葫,2=金葫
	}
    constructor() {
        this.reset();
    }
}
/**
 * @author gaolei by 2019-04-22 事件通知
 */
export class Notify {
    reset() {
		this.type = 0; // 通知类型//( 1系统消息 2好友消息 3邮包 5公告提示）0=未背使用
		this.fuserid = 0; // 请求ID
	}
    constructor() {
        this.reset();
    }
}

/**
 * 205.NPC对话框
 */
export class Npc_Dialog extends SuperBean {
	constructor() { super();
		this.cont_draw_OK = 0; //NPC对话框内容绘制成功
		this.cont_dis = 0; //文字显示过程
		this.index = 0; //NPC对话索引
		this.sel_index = 0; //开始显示选项
		this.sel_count = 0; //对话选项数量
		this.count = 0; //对话数量
		this.type = 0; //对话类型
		this.show_sel = 0; //开始显示选项
		this.npc_net_wait = 0; //网络等待
		this.h = 0; //npc_对话框高
		this.sel_w = 0; //选项宽度
		this.npc_id = 0;
		this.show_sel_h = 0; //选项框高度
		this.show_sel_h_t = 0; //选项框目标高度
		this.mission_id = 0; //任务ID
		this.npc_head = 0; //头像ID
		this.npc_name = ""; //NPC名称
		this.dialog = Xy_Dialog.createBeanArray(10);
		this.sel_item = Xy_Dialog_Sel.createBeanArray(8); //对话选项
	}
	reset() {
		this.sel_count = 0; //对话选项数量
		this.type = 0; //对话类型
		this.npc_id = 0;

		this.dialog = Xy_Dialog.createBeanArray(10);
		this.sel_item = Xy_Dialog_Sel.createBeanArray(8); //对话选项
	}
}

export class ROW_DATA {
    reset() {
		this.itemSum = 0; //B Int8 栏位个数
		this.optionSum = 0; //B Int8 连接选项个数
		//图形列表也签
		this.x = 0; //int16	x;
		this.y = 0; //int16
		this.w = 0; //int16
		this.h = 0; //int16

		this.srcID = 0; //int32 i 显示资源ID(判断资源类型 动画 图片 地图 )（地图类不显示 只显示缩略图）
		this.icon = 0; //int32 i 左上角图片类型 1-3职业  >100显示对应资源图
		this.color = 0; //uint32 BBB 图形背景色
		this.name = ""; //String Bp 显示的图片名称
		this.descr = ""; //String Bp 注释说明
		this.itemDatas = []; //[ROW_ITEM](); // 行数据，控件数组
		this.optionDatas = []; //[Xy_Menu](); // 连接选项数据集合
	}
    constructor() {
        this.reset();
    }
}

export class ROW_ITEM {
	constructor() {
		this.type = 0; //Int8 B 文字 10白色文字 11黑色文字 12红 13绿 14蓝 15黄 16红底白 17绿底白 18蓝底白 19黄底白 20 灰色
		this.is_newLine = 0; //Int8 B (0无 2画面中间开始绘制 >10 从画面左侧向后 （？-10）x 5个像素开始绘制)
		this.x = 0; // int16	x;
		this.y = 0; // int16	y;
		this.w = 0; // int16	w;
		this.h = 0; // int16	h;
		this.content = ""; //String Hp	显示内容
	}
}

/**
 * Hiiiii 返回ACT,返回p1,返回p2,返回p3,返回p4,返回p5,
 */
export class SendData extends SuperBean {
	constructor() { super();
		this.actID	= 0; // uint16
		this.p1 	= 0; // int32
		this.p2 	= 0; // int32
		this.p3 	= 0; // int32
		this.p4 	= 0; // int32
		this.p5 	= 0; // int32
		this.ps1	= "";
		this.ps2	= "";
		this.ps3	= "";
	}
    reset() {
        this.actID = 0; // uint16
        this.p1 = 0; // int32
        this.p2 = 0; // int32
        this.p3 = 0; // int32
        this.p4 = 0; // int32
        this.p5 = 0; // int32
        this.ps1 = "";
        this.ps2 = "";
        this.ps3 = "";
    }
    setSendData(actID, p1, p2, p3, p4, p5) {
        this.actID = actID;
        this.p1 = p1;
        this.p2 = p2;
        this.p3 = p3;
        this.p4 = p4;
        this.p5 = p5;
    }
    setSendDataBy(sendData) {
        this.actID = sendData.actID;
        this.p1 = sendData.p1;
        this.p2 = sendData.p2;
        this.p3 = sendData.p3;
        this.p4 = sendData.p4;
        this.p5 = sendData.p5;
        this.ps1 = sendData.ps1;
        this.ps2 = sendData.ps2;
        this.ps3 = sendData.ps3;
    }
}

export class StackRole extends SuperBean {
	constructor() { super();
		this.distance = 0; // uint32 与PC的距离
		this.pRole = null; // Map_User_Info 引用 ROLE数组里的数据进行排序
	}
}

/**
 * 通关文牒
 */
export class Stamp extends SuperBean {
	constructor() { super();
		this.selectKey = 0; //按下某键，0为没按下
		this.select = 0; //选择当前
		this.selectSub = 0; //子选择
		this.finishPercent = 0; //下载完成百分比
		this.finishSum = 0; //下载完的文件数量
		this.mapInfoIndex = 0; //检查地图文件索引
		this.mapInfoSum = 0; //全部地图文件数量
		this.update = 0; //独立计数器
		this.info_main = "";
		this.info_minor = "";
		this.mapInfoArray = null;
	}
}

export class TAB {
	constructor() {
		this.ID = 0; //B Int8 页面ID
		this.type = 0; //B Int8 样式 1信息 2列表 3多页签
		this.option = 0; //Int8 当前页面可以进行的操作，确定 返回，上一页，下一页//OPTION_BACK
		this.bg_color = 0; //B Int8 背景风格(0黑1灰2深蓝3深紫4绿5蓝绿6土黄7暗红8深黄 9蓝绿深)//自身：2深蓝 其他玩家:1灰 系统:3紫色 NPC:蓝绿
		this.isCanDoFocus = false; //Boolean 当前屏幕显示的是否有焦点
		this.itemSum = 0; //H uint16 信息页面元素个数，列表是行个数
		this.focus = 0; //int16 焦点所在位置
		this.itemFirstIndex = 0; //int16 当前屏幕的第一个控件INDEX,
		this.itemLastIndex = 0; //int16 当前屏幕的最后一个控件INDEX,
		this.tabImgPosX = 0; //int16 TAB 名字图片坐标
		this.tabImgPosY = 0; //int16 TAB 名字图片坐标
		this.offy = 0; //int16 y坐标偏移
		this.height = 0; //int16 数据显示的高度
		this.itemDatas = []; //[GLN_ITEM]();//控件数据组
		this.rowDatas = []; //[ROW_DATA]();//行数据组
		this.title = ""; //BP char[18]页面标题
		this.sendData = new SendData(); //SendData 如果TAB是联网类型，是用该数据发送
	}
}
/**
 * @author gaolei by 2019-04-22 230.任务自动寻路
 */
export class TaskAutoRouting {
	constructor() {
		this.isNeedTask = false;
		this.isDoTask = false;
		this.isAutoRouting = false;
		this.isIgnoreNPC = false;
		this.isNeedDelayRouting = false;
		this.npcId = 0;
	}
    reset() {
        this.isNeedTask = false; // 是否需要显示任务提示按钮
        this.isDoTask = false; // 是否点击了任务提示按钮，点击后需要有联网等待，直到信令返回为止
        this.isAutoRouting = false; // 是否自动寻路中
        this.isIgnoreNPC = false; // 是否无视怪物
        this.isNeedDelayRouting = false; // 是否需要延迟自动寻路
        this.npcId = 0; // 与次任务相关寻路的NPC
    }
}

/**
 * @author gaolei by 2019-04-22 任务指引提示
 */
export class TaskBar {
    reset() {
        this.has_txt = false;
        this.type = 0; // 类型 1单独显示 2全提示
        this.npcId = 0; // 与次任务相关寻路的NPC
        this.text = "";
    }
	constructor() {
        this.reset();
	}
    
}
/**
 * 300 玩家自身信息
 */
export class User_Info extends SuperBean {
	constructor() { super();
		this.is_vip = 0; //是否是VIP
		this.vip_level = 0; //VIP等级
		this.wx = 0; //五行属性
		this.autoPathFindingStep = 0; //自动寻路中的移动方式索引
		this.exp_w = 0; //经验条长度  500=满
		this.roleMoveTime = 0;
		this.hp = 0; //HP
		this.mp = 0; //MP
		this.hp_max = 0; //
		this.mp_max = 0; //
		this.silver = 0; //银币
		this.gold = 0; //金币
		this.exp = 0; //经验值
		this.autoPath = new Array(ENUM.AUTO_PATH_FOOTSTEP); // char[128] 每一步的移动方向，搜索128步，够了吧？
		this.mapUserInfo = new Map_User_Info(); //在地图上的信息
	}
}

export class Xy_Arming_info extends SuperBean {
	constructor() { super();
		this.type = 0; //类型
		this.lvl = 0;
		this.stone = 0; //宝石孔 状态 掩码 1 2 4
		this.fz = 0;
		this.id = 0;
		this.pic_id = 0;
		this.descr = "";
		this.kx = "";
		this.name = "";
	}
}

/**
 * 属性点信息
 */
export class Xy_ATTPOT_INFO extends SuperBean {
	constructor() { super();
		this.hp_w = 0; // uint16
		this.mp_w = 0;
		this.ap_w = 0;
		this.sp_w = 0;
		this.potinfo_x = 0; //内容入场变量
	}
}

export class Xy_Dialog_Sel extends SuperBean {
	constructor() { super();
		this.id = 0; //选项id
		this.state = 0; //状态 0无 1新 2主 3接 4交
		this.mission_id = 0; //任务id
		this.content = ""; //对话内容
		this.sendData = new SendData();
	}
}

export class Xy_Dialog extends SuperBean {
	constructor() { super();
		this.type	= 0; // int16 显示颜色 0 白色 1红色 2绿色 3蓝色 5黄色
		this.dialog = ""; // String 对话内容
	}
}

export class Xy_INFO_Item extends SuperBean {
	constructor() { super();
		this.isplayer = 0; // uint8
		this.type	= 0; // uint8 选项类型0 普通 1金砖 2银两 3等级 4经验 5 气血 6精力
		this.style	= 0; // uint8 风格
		this.id		= 0; // uint16
		this.txt	= ""; // String 需要考虑是否使用数组
		this.sendData = new SendData();
	}
}

export class Xy_Levelup_Box extends SuperBean {
	constructor() { super();
		this.lvl_1 = 0; // uint8
		this.lvl_2 = 0; // uint8
		this.hp_1 = 0; // uint16
		this.mp_1 = 0; // uint16
		this.ap_1 = 0; // uint16
		this.df_1 = 0; // uint16
		this.sp_1 = 0; // uint16
		this.we_1 = 0; // uint16
		this.text = ""; // String
	}
}

/**
 * 菜单项
 */
export class Xy_Menu extends SuperBean {
	constructor() { super();
		this.type	= 0; // uint8
		this.ID		= 0; // int16 ID
		this.p_id	= 0; // int16 上级ID
		this.name	= ""; // char[10] 名称
		this.sendData = new SendData();
	}
}

export class Xy_PAGE_ARMING_SET extends SuperBean {
	constructor() { super();
		this.lvl = 0;
		this.xy_page_arming_sel_state = 0; //武器选单
		this.roletype = 0;
		this.xy_page_bg_w = 0; //背景底色展开变量
		this.xy_page_tit_h = 0; //上下页脚展开变量
		this.xy_page_potsel_w = 0; //内容入场变量
		this.xy_page_titinfo_y = 0; //标题入场变量
		this.xy_page_scan_y = 0; //内容入场变量
		this.xy_page_arming_sel = 0; //武器选择
		this.xy_page_arming_type_count = 0; //武器类型数量
		this.xy_page_arming_type_sel_page_index = 0; //武器选择页首选项索引

		this.xy_page_pot_info_hp = 0;
		this.xy_page_pot_info_mp = 0;
		this.xy_page_pot_info_ap = 0;
		this.xy_page_pot_info_sp = 0;
		this.xy_page_pot_info_df = 0;
		this.xy_page_pot_info_fz = 0;

		this.name = "";
		this.profile_id = new Array(6);
		this.sendData = new SendData();
		this.arming_type_index1 = null; //Xy_Arming_info.createBeanArray(50);
		this.arming_infos = Xy_Arming_info.createBeanArray(50); //装备列表
	}
}

export class Xy_PAGE_ATTPOT_INFO extends SuperBean {
	constructor() { super();
		this.wx = 0;
		this.lvl = 0;
		this.xy_page_bg_w = 0; //背景底色展开变量
		this.xy_page_tit_h = 0; //上下页脚展开变量
		this.xy_page_potsel_w = 0; //内容入场变量
		//	uint16 xy_page_potinfo_x;	//属性图绘制变量
		this.xy_page_titinfo_y = 0; //标题入场变量
		//xy_sel_index//选项索引

		//属性值
		this.xy_page_pot_att_p = 0;
		this.xy_page_pot_hp_p = 0;
		this.xy_page_pot_ap_p = 0;
		this.xy_page_pot_mp_p = 0;
		this.xy_page_pot_sp_p = 0;

		//调整值
		this.xy_page_pot_hp_p_add = 0;
		this.xy_page_pot_ap_p_add = 0;
		this.xy_page_pot_mp_p_add = 0;
		this.xy_page_pot_sp_p_add = 0;

		this.xy_page_pot_info_hp = 0;
		this.xy_page_pot_info_mp = 0;
		this.xy_page_pot_info_ap = 0;
		this.xy_page_pot_info_sp = 0;
		this.xy_page_pot_info_df = 0;
		this.xy_page_pot_info_fz = 0;

		this.fj_id = 0;
		this.roletype = 0;
		this.head_id = 0;
		this.pot_type = "";
		this.name = "";
		this.sendData = new SendData();
		this.attpot_info = new Xy_ATTPOT_INFO();
	}
}

export class Xy_PAGE_PLAYERINFO extends SuperBean {
	constructor() { super();
		this.wx = 0;
		this.lvl = 0;
		this.online = 0;
		this.page_style = 0;
		this.line_count = 0;
		this.but_count = 0;
		this.sel_but = 0;
		this.roletype = 0;
		this.xy_page_pot_hp = 0;
		this.xy_page_pot_mp = 0;
		this.xy_page_pot_ap = 0;
		this.xy_page_pot_sp = 0;

		this.xy_page_bg_w = 0; //背景底色展开变量
		this.xy_page_tit_h = 0; //上下页脚展开变量	
		this.xy_page_potsel_w = 0; //内容入场变量
		this.xy_page_titinfo_y = 0; //标题入场变量
		//	uint16	xy_page_potinfo_x;//内容入场变量
		this.xy_page_sel_but_x = 0;
		this.sel_line = 0;
		this.top_line = 0;
		this.bg_color = 0;
		this.bg_color_line = 0;
		this.bg_color_src = 0;
		this.id = 0;
		this.img_id = 0;
		this.scr_id = 0;

		this.line_nrs = null;
		this.buts = null;
		this.attpot_info = new Xy_ATTPOT_INFO();
		this.sendData = new SendData();
		this.name = "";
		this.page_title = "";
		this.title = "";
	}
}

export class Xy_PAGE_SelArea extends SuperBean {
	constructor() { super();
        this.count = 0;
        this.cloud_x = 0;
        this.page_top_index = 0;
        this.page_index = 0;// 页码
		this.page_count = 0;// 总页数
		this.focus_index = 0;// 聚焦项索引
		this.arealist = Arealist_Item.createBeanArray(60); // Arealist_Item[60];
	}
}

export class Xy_PAGE_SelRole extends SuperBean {
	constructor() { super();
		this.cr_timer = 0; // int16
		this.roles = Login_Role_Info.createBeanArray(ENUM.MAX_ROLE_SUM); //	Login_Role_Info [MAX_ROLE_SUM];
	}
}

export class Xy_PAGE_WorldMap extends SuperBean {
	constructor() { super();
		this.type		= 0; // uint8 0 陆地 1海 2天宫
		this.map_x		= 0; // int16
		this.map_y		= 0;
		this.map_t_x 	= 0;
		this.map_t_y 	= 0;
		this.map_line_count = 0;
		this.map_site_count = 0;
		this.sel_index		= 0;
		this.sel_site_id	= 0; // uint16
		this.xy_page_bg_h	= 0; // uint16 背景底色展开
		this.scr_id			= 0; // int32 地图资源id
		this.cloud_img_date = null //UIImage();//资源图片名
		this.title = ""; // char[20]
		this.cloud		= Xy_WorldMap_Item.createBeanArray(12); // Xy_WorldMap_Item[12] 云信息
		this.map_line	= Xy_WorldMap_Line.createBeanArray(50); // Xy_WorldMap_Line[50] 线路信息
		this.map_site	= Xy_WorldMap_Item.createBeanArray(50); // Xy_WorldMap_Item[50] 坐标信息
	}
}

export class Xy_PLAYERINFO_BUT extends SuperBean {
	constructor() { super();
		this.name = ""; // char[10];
		this.sendData = new SendData();
	}
}

export class Xy_PLAYERINFO_LINE_NR extends SuperBean {
	constructor() { super();
		this.style	= 0; // uint8
		this.nr 	= "";
		this.act_nr = "";
		this.sendData = new SendData();
	}
}

/**
 * 快速弹出选单
 */
export class Xy_Popup extends SuperBean {
	constructor() { super();
		this.H = 28; //17
		this.selected = 0; // int8
		this.count = 0; // int8 快捷菜单个数
		this.state = 0; // uint8
		this.net_cls = 0; // int8 点击联网 等待刷新关闭
		this.x = 0; // int16
		this.y = 0;
		this.h = 0;
		this.menus = null; // Xy_Menu[] 快速弹出选单
	}
}

export class Xy_Qmenu extends SuperBean {
	constructor() { super();
		this.isShow	= false; // 没用上啊
		this.draw_OK = 0; // uint8
		this.sel 	= 0; // int8
		this.x 		= 0; // int16 绘制参数
		this.bg_y 	= 0; // int16
		this.menus 	= Xy_Menu.createBeanArray(9); //Xy_Menu[9]快捷图标菜单
	}
}

export class Xy_UI_Menu extends SuperBean {
	constructor() { super();
		this.prt_map = 0; // uint8 菜单项需要刷新地图
		this.w		= 0; // int16
		this.lay	= 0; // int16 菜单当前等级
		this.p		= 0; // int16 父级菜单项
		this.count_lay = 0; // int16 本层菜单个数
		this.lay_first_index = 0; // int16 本层首选项索引
		this.count	= 0; // int16 有效菜单个数
		this.lay2_y = 0; // int16子菜单起始纵坐标
		this.menus	= Xy_Menu.createBeanArray(50); // Xy_Menu[50];
	}
}

export class Xy_WorldMap_Item extends SuperBean {
	constructor() { super();
		this.img_type	= 0; // uint8
		this.dtype		= 0; // uint16 坐标类型 0不可到 1可到达 / 云 方向 速度
		this.site_id	= 0; // uint16
		this.x = 0; // int16
		this.y = 0; // int16
		this.name	= ""; // char[15];
		this.descr	= ""; // char[200];
	}
}

export class Xy_WorldMap_Line extends SuperBean {
	constructor() { super();
		this.type = 0; // uint16 颜色 0黑白 1蓝白 2红白
		this.x1 = 0; // int16
		this.y1 = 0; // int16
		this.x2 = 0; // int16
		this.y2 = 0; // int16
	}
}
