/*******************************************************************************
 * CopyRight (c) HYTC Ltd. All rights reserved.
 * Filename:    HF_Color.js
 * Creator:   GaoLei
 * Version:   0.0
 * Date: 	 2019-03-29
 * Description: 组件模型
 *******************************************************************************/
console.log(" 1 load HF_Color.js");

export default class HF_Color {
    constructor(color) {
        if (color === undefined) {
            this.reset();
        } else {
            this.setColor((color >> 16) & 0xFF, (color >> 8) & 0xFF, color & 0xFF);
        }
    }
    
    reset() {
        this.r = 0;
        this.g = 0;
        this.b = 0;
        this.a = 255;
        this.c = 0xFF000000;// 颜色的INT表示法
    }

    setColor(r, g, b) {
        this.r = r;
        this.g = g;
        this.b = b;
        return this;
    }

    // mr_colourSt转换成INT值
    getColorValue() {
        return HF_Color.getColorToInt(this.r, this.g, this.b);
    }

    static getColorToInt(r, g, b) {
        let value = 0;
        value |= r;
        value <<= 8;
        value |= g;
        value <<= 8;
        value |= b;
        value |= HF_Color.c;//透明度
        return value;
    }

}