/*******************************************************************************
 * CopyRight (c) HYTC Ltd. All rights reserved.
 * Filename:    Rect.js
 * Creator:   GaoLei
 * Version:   0.0
 * Date: 	 2019-03-29
 * Description: 组件模型
 *******************************************************************************/
console.log(" 1 load Rect.js");

export default class Rect {
    reset() {
        this.x = 0;
        this.y = 0;
        this.w = 0;
        this.h = 0;
    }

    constructor(x, y, w, h) {
        if (x === undefined) {
            this.reset();
        } else {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
        }
    }

    moveTo(x, y) {
        this.x = x;
        this.y = y;
    }

    moveBy(x, y) {
        this.x += x;
        this.y += y;
    }

    setRect(x, y, w, h) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
    }

    setRectBy(rect) {
        this.setRect(rect.x, rect.y, rect.w, rect.h);
    }

    isOverlap(rect) {
        if (this.x + this.w > rect.x && rect.x + rect.w > this.x && this.y + this.h > rect.y &&
            rect.y + rect.h > this.y) {
            return true;
        } else {
            return false;
        }
    }

    getRectBy(off) {
        return new Rect(this.x - off, this.y - off, this.w + off * 2, this.h + off * 2);
    }

    isEqual(rect) {
        return (this.x == rect.x && this.y == rect.y && this.w == rect.w && this.h == rect.h);
    }
}