/*******************************************************************************
 * CopyRight (c) HYTC Ltd. All rights reserved.
 * Filename:    HF_Color.js
 * Creator:   GaoLei
 * Version:   0.0
 * Date: 	 2019-03-29
 * Description: 组件模型
 *******************************************************************************/
console.log(" 1 load Unpack.js");

import * as Tool from '../../Tool.js'
import {
    SendData,
} from '../Beans'

let littleEndian = false; //可选，布尔值，规定是大端字节序还是小端字节序；true表示小端字节序，省略或者false表示大端字节序。

export default class Unpack {
    constructor() {
        this._init();
    }

    _init() {
        this.pos = 0;
        this.data = null; //DataView
        this.arrayBuffer = null;
        //console.log("-= Unpack _init =-")
    }
    setData(_data) {
        this.pos = 0;
        this.arrayBuffer = _data;
        this.data = new DataView(this.arrayBuffer);
        console.log("setData _data=:", _data)
        //console.log("setData this.data=:", this.data)
    }
    getPos() {
        //console.log("-------getPos:",this.pos)
        return this.pos;
    }
    unpack_GET_Boolean() {
        return this.unpack_GET_B() == 0 ? false : true;
    }
    unpack_GET_B() {
        var value = 0;
        if (this.pos <= this.data.byteLength - 1) {
            value = this.data.getUint8(this.pos);
        }
        this.pos += 1;
        return value;
    }
    unpack_GET_H() {
        var value = 0;
        if (this.pos <= this.data.byteLength - 2) {
            value = this.data.getUint16(this.pos, littleEndian);
        }
        this.pos += 2;
        return value;
    }
    unpack_get_i() {
        var value = 0;
        if (this.pos <= this.data.byteLength - 4) {
            value = this.data.getInt32(this.pos, littleEndian);
        }
        this.pos += 4;
        return value;
    }

    skipBy(pos) { //从当前位置跳过多少个字节不处理
        this.pos += pos;
    }
    get_UInt8_B() {
        return this.unpack_GET_B();
    }
    get_Int8_B() {
        var value = 0;
        if (this.pos <= this.data.byteLength - 1) {
            value = this.data.getInt8(this.pos);
        }
        this.pos += 1;
        return value;
    }
    get_Byte() {
        return this.get_Int8_B();
    }

    unpack_GET_P(len) {
        // console.log("unpack_GET_P this.pos=:", this.pos, " len=", len, "  this.data.byteLength=", this.data.byteLength)
        // console.log("unpack_GET_P this.data=:", this.data)
        var str = "";
        if (this.pos <= this.data.byteLength - len) {
            var byteArray = [];
            for (let i = 0; i < len; i++) {
                byteArray[i] = this.data.getUint8(this.pos + i);
            }
            var utf8Array = Tool.UTF8Bytes_to_UnicodeBytes(byteArray);
            // for (let i = 0; i < utf8Array.length; i++)
            // {
            // 	str += String.fromCharCode(utf8Array[i])
            // }
            str = String.fromCharCode(...utf8Array);
            //console.log("unpack_GET_P str=", str)
        }
        this.pos += len;
        return str;
    }
    
    unpack_GET_BP() {
        let B = this.unpack_GET_B();
        let str = this.unpack_GET_P(B);
        return str;
    }

    unpack_GET_HP() {
        let H = this.unpack_GET_H();
        let str = this.unpack_GET_P(H);
        return str;
    }
    unpack_GET_H5i() {
        let sendData = new SendData();
        if (this.pos <= this.data.byteLength - 22) {
            sendData.actID = this.unpack_GET_H();
            sendData.p1 = this.unpack_get_i();
            sendData.p2 = this.unpack_get_i();
            sendData.p3 = this.unpack_get_i();
            sendData.p4 = this.unpack_get_i();
            sendData.p5 = this.unpack_get_i();
        } else {
            this.pos += 22;
        }
        return sendData;
    }

    unpack_get_p(srcPos, len) { //起点,终点
        var get_p = null;
        //console.log("unpack_get_p srcPos=", srcPos, " len=", len)
        if (this.pos <= this.arrayBuffer.byteLength - len) {
            get_p = this.arrayBuffer.slice(srcPos, srcPos + len);
            //console.log("unpack_get_p get_p.byteLength=", get_p.byteLength)
        }
        this.pos += len;
        return get_p;
    }
   
}
