// 游戏世界 地图场景脚本
import {
    FILE_TYPE,
    ACT_ID,
}
from "../core/adapter/ENUM";
import * as ENUM from "../core/adapter/ENUM";

import {
    ACT,
    Animation,
    AnimationApp,
    BmpInfo,
    Clouds,
    Frame,
    MAP,
    Map_Door,
    Module,
    ModuleApp,
    StackRole,
}from "./core/Beans";

import {
    Int,
    toInt,
    toString
}
from "../Tool";
import Unpack from "./core/tool/Unpack";
//import AutoPath from '../basic_tools/AutoPath';
let AutoPath = require('../basic_tools/AutoPath');

cc.Class({
    extends: cc.Component,

    properties: {
        PC: cc.Node,
        MAP_ID: 0, //地图ID
        TOP_H: 0, //顶部距离
        BOTTOM_H: 0, //底部距离

        info: cc.Label,
        //camera: cc.Node,
        _map: null,
        _follow:null,
        _PC_Player: [], //PC队伍,123为副将
    },

    onLoad () {
        //除了使用 on 监听，我们还可以使用 once 方法。once 监听在监听函数响应后就会关闭监听事件。
        this.node.on(cc.Node.EventType.TOUCH_END, (event) => { // mousedown touchend
            //console.log("MAP:touchend event:", event);

            // 转换坐标点到节点下
            let node_pos = this.node.convertToNodeSpaceAR(event.getLocation());
            //console.log("MAP:touchend node_pos:", node_pos);
            node_pos = this.convertToMapPos(node_pos);
            //console.log("MAP:touchend convertToMapPos:", node_pos);
            this.PC.destination_x = Int(node_pos.x);
            this.PC.destination_y = Int(node_pos.y);
            this.autoPathFinding(this.PC);

            if (this.PC.autoPath.length > 0) {
                let children = this.node.getChildren();

                if (this._PC_Player.length===0){
                    this._PC_Player[0] = this.node.getChildByName('player');
                    this._PC_Player[1] = this.node.getChildByName('player_1');
                    this._PC_Player[2] = this.node.getChildByName('player_2');
                    this._PC_Player[3] = this.node.getChildByName('player_3');
                }

                //需要修改 children 顺序会被child的zIndex给修改的
                //需要另一个数组来存储 人物指针
                for (let i = 1; i < this._PC_Player.length; i++) {
                    //console.log(i + ".this._PC_Player: ", this._PC_Player[i]);
                    let PC_autoPath = this._PC_Player[i - 1].autoPath;
                    PC_autoPath.pop(); //最后一个不用走到
                    let F1_autoPath_0 = this.getMapArrPos(cc.v2(this._PC_Player[i - 1].x, this._PC_Player[i - 1].y));
                    let F1_autoPath = [F1_autoPath_0].concat(PC_autoPath);
                    let child = this._PC_Player[i];
                    child.autoPath = F1_autoPath;
                    this.autoPathRuning(child);
                }
            }
        });
        if (this.MAP_ID != 0) {
            this.set_MAP_ID(this.MAP_ID);
        }
    },

    start () {
        //console.log("MAP:start");
        //console.log("MAP:start this.PC:", this.PC);
        //console.log("MAP:start this.node:", this.node);
        //console.log("follow this.node.w:", this.node.w);
        //console.log("follow this.node.h:", this.node.h);
        this._follow = cc.follow(this.PC, cc.rect(0, -this.BOTTOM_H, 1632, 1680 + this.TOP_H + this.BOTTOM_H));
        this.node.runAction(this._follow);
        let children = this.node.getChildren();
        for (let i = 1; i < children.length; i++) {
            let child = children[i];
            this.setPC_mapPos(child, cc.v2(child.x, child.y));
        }
    },

    // update(dt){},

    set_MAP_ID(mapID) {
        this.MAP_ID = mapID;
        //console.log("MAP:set_MAP_ID this.MAP_ID:", this.MAP_ID);
        this.map_loadMap(this.MAP_ID);
    },

    setPC_mapPos(player, mapPos) {
        player.x = mapPos.x;
        player.y = this.node.height - mapPos.y;
        if (player === this.PC) {
            this.info.string = "x:" + Int(mapPos.x) + " y:" + Int(mapPos.y);
        }
    },

    //根据地图坐标 获取地图数据数组坐标
    getMapArrPos(mapPos) {
        let arrPos = {
            col: Int(mapPos.x / ENUM.MAP_TILE_H),
            row: Int(this.convertToMapPosY(mapPos.y) / ENUM.MAP_TILE_W),
        };
        return arrPos;
    },
    //需要转换GL坐标与屏幕坐标的差异 
    convertToMapPos(pos) {
        pos.y = this.convertToMapPosY(pos.y);
        return pos;
    },
    convertToMapPosY(posY) {
        return this.node.height - posY;
    },

    //执行自动寻路的跑动
    autoPathRuning(player) {
        //console.log("autoPathRuning player:", player);
        //console.log("autoPathRuning autoPath[]:", player.autoPath);
        let prevPosX = player.x;
        let actArray = [];
        let speed = 0.24; //player.mapUserInfo.SPEED;
        for (let i = 0; i < player.autoPath.length; i++) {
            let toPos = player.autoPath[i];
            let posy = this.convertToMapPosY((toPos.row + 0.5) * ENUM.MAP_TILE_H);
            let posx = (toPos.col + 0.5) * ENUM.MAP_TILE_W;
            actArray[i] = cc.moveTo(speed, cc.v2(posx, posy));
            
            let flipX = null; //是否需要转向
            if (posx > prevPosX) { //面右
                flipX = cc.flipX(false);
            } else if (posx < prevPosX) { //面左
                flipX = cc.flipX(true);
            }

            if (flipX) {
                actArray[i] = cc.spawn(flipX, actArray[i]);
            }
            prevPosX = posx;//记录上次的X坐标

            if (i == 0) { //转到奔跑状态
                let act0 = cc.callFunc(this.changeAction, player, ACT_ID.MOVE);
                actArray[i] = cc.spawn(act0, actArray[i]);
            }
        }
        if (actArray.length >= 1) {
            //转到站立待机状态
            actArray[actArray.length] = cc.callFunc(this.changeAction, player, ACT_ID.MOVE_WAIT);
            let seq = cc.sequence(actArray);
            player.stopAllActions();
            player.runAction(seq);
        }
    },
    //自动寻路入口函数
    autoPathFinding(player) {
        let startX = Int(player.x / ENUM.MAP_TILE_W);
        let startY = Int(this.convertToMapPosY(player.y) / ENUM.MAP_TILE_H);
        let destinationX = Int(player.destination_x / ENUM.MAP_TILE_W);
        let destinationY = Int(player.destination_y / ENUM.MAP_TILE_H);

        //console.log("autoPathFinding start:[", startX, startY, "]");
        //console.log("autoPathFinding destination:[", destinationX, destinationY, "]");

        // for (let i = 0; i < player.autoPath.length; i++) {
        //     player.autoPath[i] = 0;
        // }
        player.autoPath = [];
        if (startX == destinationX && startY == destinationY) {
            //player.autoPathFindingStep = 0; // 自动寻路开始
            return;//不需要寻路
        }

        let autoPath = new AutoPath();
        autoPath.mapData = this._map.mapData;
        autoPath.tile_x_count = this._map.tile_x_count;
        autoPath.tile_y_count = this._map.tile_y_count;
        autoPath.startTileX = this._map.startTileX;
        autoPath.startTileY = this._map.startTileY;

        //autoPath.mapPlayer = player; // 玩家指针
        //autoPath.mapPlayer.roleMoveTime = 0;
        player.autoPath = autoPath.getPath(startX, startY, destinationX, destinationY);

        // if (player.autoPath[0] != 0) {
        //     player.autoPathFindingStep = 0; // 自动寻路开始
        //     //player.mapUserInfo.actionID = ACT_ID.MOVE;
        // } else {
        //     player.autoPathFindingStep = -1; // 寻路失败
        // }
        this.autoPathRuning(player);
    },

    changeAction(player, actionID){
        //console.log("changeAction player:", player);
        //console.log("changeAction actionID:", actionID);
        if(player){
            let act = player.getComponent("HF_ACT_HERO");
            if (act) {
                act.setActionID(actionID);
            }
        }
    },

    creatMap(mapID, file) {
        let map = new MAP();
        //console.log("creatMap map:", map);

        let mapSize = 0; // 地图数据 数组长度
        let unpack = new Unpack();
        unpack.setData(file._buffer); //H5 浏览器,CC模拟器
        //unpack.setData(file); //微信小游戏,需要使用这行

        unpack.skipBy(8);

        map.imgNameCount = unpack.get_UInt8_B(); // 图片数量
        // ------获取图片.名字.宽高------------------------------
        if (map.imgNameCount > 0) {
            map.bmpInfo = new Array(map.imgNameCount); // new BmpInfo[map.imgNameCount];
            for (let i = 0; i < map.imgNameCount; i++) {
                let width = unpack.get_UInt8_B();
                let height = unpack.get_UInt8_B();
                let imgNameLength = unpack.get_UInt8_B();
                map.bmpInfo[i] = new BmpInfo();
                map.bmpInfo[i].name = unpack.unpack_GET_P(imgNameLength - 5); // 去掉扩展名了
                unpack.skipBy(5);
                map.bmpInfo[i].width = width;
                map.bmpInfo[i].height = height;
            }
        }
        // }WH{
        unpack.skipBy(4); // 跳过 }WH{

        // 地面瓦片索引数组 TILE INDEX 2字节//已经去掉了
        let map_tile_x_count = unpack.get_UInt8_B();
        let map_tile_y_count = unpack.get_UInt8_B();
        mapSize = map_tile_x_count * map_tile_y_count;
        map.tile_x_count = map_tile_x_count; // 地图横向瓦片数量
        map.tile_y_count = map_tile_y_count; // 地图纵向瓦片数量
        //setMapSize();
        // }MD{
        unpack.skipBy(4); // 跳过 }MD{
        if (mapSize > 1) {
            let mapDataSize = mapSize * 1;
            map.mapData = new Array(mapDataSize); // new byte[mapDataSize];
            for (let i = 0; i < mapDataSize; i++) {
                map.mapData[i] = unpack.get_Byte();
            }
        }

        // }MOD{ // 动画 图元数据
        unpack.skipBy(5); // 跳过 }MOD{
        map.moduleCount = unpack.get_UInt8_B(); // MOD长度
        if (map.moduleCount > 0) {
            //console.log(" map.moduleCount=" + map.moduleCount);
            map.mapModule = new Array(map.moduleCount); // new Module[map.moduleCount];
            for (let i = 0; i < map.moduleCount; i++) {
                map.mapModule[i] = new Module(unpack.get_Byte(), unpack.get_UInt8_B(), unpack.get_UInt8_B(),
                    unpack.get_UInt8_B(), unpack.get_UInt8_B());
            }
        }

        // }ANI{ // 动画数据
        unpack.skipBy(5); // 跳过 }ANI{
        map.animationCount = unpack.get_UInt8_B(); // 跳过ANI长度
        if (map.animationCount > 0) {
            map.animation = new Array(map.animationCount); //new Animation[map.animationCount];
            for (let i = 0; i < map.animationCount; i++) {
                map.animation[i] = new Animation();
                map.animation[i].frameCount = unpack.get_Byte(); // 第i个 animation的帧数
                let frame = new Array(map.animation[i].frameCount); // 第i个 animation的帧数据
                for (let j = 0; j < map.animation[i].frameCount; j++) // 第j帧数据
                {
                    frame[j] = new Frame();
                    frame[j].moduleAppCount = unpack.get_Byte(); // 第j个 frame的ModuleApp个数
                    let moduleApp = new Array(frame[j].moduleAppCount); // 第j帧图元APP的数组
                    for (let k = 0; k < frame[j].moduleAppCount; k++) // 第k个ModuleApp数据
                    {
                        moduleApp[k] = new ModuleApp();
                        moduleApp[k].moduleID = unpack.get_Int8_B();
                        moduleApp[k].x = unpack.get_Int8_B();
                        moduleApp[k].y = unpack.get_Int8_B();
                    }
                    frame[j].moduleApp = moduleApp;
                }
                map.animation[i].frame = frame;
            }
        }

        // 建筑层动画数据
        // }OBJ{
        unpack.skipBy(5); // 跳过 }OBJ{
        map.animationAppOBJCount = unpack.get_UInt8_B(); // 动画个数
        if (map.animationAppOBJCount > 0) {
            map.animationAppOBJ = new Array(map.animationAppOBJCount); // new AnimationApp[map.animationAppOBJCount];
            for (let i = 0; i < map.animationAppOBJCount; i++) {
                map.animationAppOBJ[i] = new AnimationApp();
                map.animationAppOBJ[i].animationID = unpack.get_Byte(); // 跳过animationID
                map.animationAppOBJ[i].x = unpack.get_Byte(); // 跳过该动画的X偏移
                map.animationAppOBJ[i].y = unpack.get_Byte(); // 跳过该动画的y偏移
            }
        }

        // 对象层动画数据
        // }NPC{
        unpack.skipBy(5); // 跳过 }NPC{
        map.animationAppNPCCount = unpack.get_UInt8_B(); // 跳过NPC 动画个数
        if (map.animationAppNPCCount > 0) {
            map.animationAppNPC = new Array(map.animationAppNPCCount); // new AnimationApp[map.animationAppNPCCount];
            for (let i = 0; i < map.animationAppNPCCount; i++) {
                map.animationAppNPC[i] = new AnimationApp();
                map.animationAppNPC[i].animationID = unpack.get_Byte(); // 跳过animationID
                map.animationAppNPC[i].x = unpack.get_Byte(); // 跳过该动画的X偏移
                map.animationAppNPC[i].y = unpack.get_Byte(); // 跳过该动画的y偏移
            }
        }

        // ------获取图片文件------------------------------
        for (let i = 0; i < map.imgNameCount; i++) {
            //console.log("map_loadMap map.bmpInfo[" + i + "].pData = " + map.bmpInfo[i].name);
            let imageName = map.bmpInfo[i].name + FILE_TYPE.PIC;
            //map.bmpInfo[i].pData = createImage(imageName);
            //console.log("map_loadMap map.bmpInfo[" + i + "].pData = " + imageName);
        }
        map.mapID = mapID; //mapInfo.ID;
        //map.tileImage = makeMapImage(map); //by gaolei 190131 世界地图使用大图
        return map;
    },

    _loadMapAnimation(animationApp, animationAppCount, zIndexOff) {
        if (this._map.mapData == null) {
            return;
        }
        for (let i = 0; i < animationAppCount; i++) {
            let animationID = animationApp[i].animationID;
            let map_x = animationApp[i].x * ENUM.MAP_TILE_W;
            let map_y = animationApp[i].y * ENUM.MAP_TILE_H;
                map_y = this.convertToMapPosY(map_y);
            let animationNode = new cc.Node('animationApp_' + i);
            var ani = animationNode.addComponent('HF_ACT_MAP');
            ani.setMapAct(this._map, this._map.animation[animationID]);
            animationNode.setPosition(map_x, map_y);
            animationNode.parent = this.node;
            animationNode.zIndex = zIndexOff - animationNode.y;
        }
    },

    _loadMapFile() {
        let url_bin = "map_bin/" + this.MAP_ID;
        cc.loader.loadRes(url_bin, cc.BufferAsset, (err, file) => {
            if (file) {
                this._map = this.creatMap(this.MAP_ID, file);
                this._loadMapAnimation(this._map.animationAppOBJ, this._map.animationAppOBJCount,0); // 地图上的建筑层 地面层
                this._loadMapAnimation(this._map.animationAppNPC, this._map.animationAppNPCCount,8888); // 地图上的建筑层 天空层
            } else {
                console.error("_loadMapFile err:", err);
            }
        });
    },

    //载入地图背景 地面层
    _loadSpriteFrame() {
        let url_png = "map_png/" + this.MAP_ID;
        cc.loader.loadRes(url_png, cc.SpriteFrame, (err, spriteFrame) => {
            if (spriteFrame) {
                let sprite = this.node.getComponent(cc.Sprite);
                sprite.spriteFrame = spriteFrame;
                this.setPC_mapPos(this.PC, cc.v2(this.PC.x, this.PC.y)); //移动到该点
                if (this._follow) {
                    this.node.stopAction(this._follow);
                }
                this._follow = cc.follow(this.PC, cc.rect(0, -this.BOTTOM_H, sprite.node.width, sprite.node.height + this.TOP_H + this.BOTTOM_H));
                this.node.runAction(this._follow);
            } else {
                console.error("_loadSpriteFrame err:", err);
            }
        });
    },

    map_loadMap(mapID) {
        //console.log("MAP:map_loadMap mapID:", mapID);
        this._loadSpriteFrame(); //加载地图背景层
        this._loadMapFile(); //加载地图数据
    },

});
