cc.Class({
    extends: cc.Component,

    properties: {
        //背景乐 音量
        bgmVolume: 1.0,
        //音效 音量
        sfxVolume: 1.0,
        //背景乐 播放ID
        bgmAudioID: -1,
    },

    //音效管理类 初始化
    init: function() {
        var t = cc.sys.localStorage.getItem("USER_SETTING_VOLUME_BGM");
        if (t != null) {
            this.bgmVolume = parseFloat(t);
        }

        var t = cc.sys.localStorage.getItem("USER_SETTING_VOLUME_SFX");
        if (t != null) {
            this.sfxVolume = parseFloat(t);
        }
    },


    getUrl: function(url) {
        return cc.url.raw("resources/" + url);
    },

    //播放 背景乐
    playBGM(url) {
        var audioUrl = this.getUrl(url);
        if(cc.show_log)
            console.log(audioUrl);
        if (this.bgmAudioID >= 0) {
            cc.audioEngine.stop(this.bgmAudioID);
        }
        this.bgmAudioID = cc.audioEngine.play(audioUrl, true, this.bgmVolume);
    },

    //播放 音效
    playSFX(url) {
        var audioUrl = this.getUrl(url);
        if (this.sfxVolume > 0) {
            var audioId = cc.audioEngine.play(audioUrl, false, this.sfxVolume);
        }
    },

    //设置 音效 音量
    setSFXVolume: function(v) {
        if (this.sfxVolume != v) {
            cc.sys.localStorage.setItem("USER_SETTING_VOLUME_SFX", v);
            this.sfxVolume = v;
        }
    },

    //设置 背景乐 音量
    setBGMVolume: function(v, force) {
        if (this.bgmAudioID >= 0) {
            if (v > 0) {
                cc.audioEngine.resume(this.bgmAudioID);
            } else {
                cc.audioEngine.pause(this.bgmAudioID);
            }
            //cc.audioEngine.setVolume(this.bgmAudioID,this.bgmVolume);
        }
        if (this.bgmVolume != v || force) {
            cc.sys.localStorage.setItem("USER_SETTING_VOLUME_BGM", v);
            this.bgmVolume = v;
            cc.audioEngine.setVolume(this.bgmAudioID, v);
        }
    },

    //暂停 所有音效
    pauseAll: function() {
        cc.audioEngine.pauseAll();
    },

    //继续 所有音效
    resumeAll: function() {
        cc.audioEngine.resumeAll();
    },

    //播放 通用按钮点击 音效
    playComBtnClickSfx: function() {
        //播放 音效
        this.playSFX("Sound/btnClick.mp3")
    },

    //播放 礼物特效 音效
    playExpClick: function(type) {
        //播放 音效
        cc.log(type)
        this.playSFX("exp/" + type + ".mp3")
    }
});