// Learn cc.Class:
//  - [Chinese] http://docs.cocos.com/creator/manual/zh/scripting/class.html
//  - [English] http://www.cocos2d-x.org/docs/creator/en/scripting/class.html
// Learn Attribute:
//  - [Chinese] http://docs.cocos.com/creator/manual/zh/scripting/reference/attributes.html
//  - [English] http://www.cocos2d-x.org/docs/creator/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - [Chinese] http://docs.cocos.com/creator/manual/zh/scripting/life-cycle-callbacks.html
//  - [English] http://www.cocos2d-x.org/docs/creator/en/scripting/life-cycle-callbacks.html

cc.Class({
    extends: cc.Component,

    properties: {
        // foo: {
        //     // ATTRIBUTES:
        //     default: null,        // The default value will be used only when the component attaching
        //                           // to a node for the first time
        //     type: cc.SpriteFrame, // optional, default is typeof default
        //     serializable: true,   // optional, default is true
        // },
        // bar: {
        //     get () {
        //         return this._bar;
        //     },
        //     set (value) {
        //         this._bar = value;
        //     }
        // },
        _game_map : cc.Node,

        _cilckPos : null,

        quan_list : [],

        Currentround : 0, //当前回合数
        Isround : false,  //当前是自己回合

        Mround : cc.Node,

        Yround : cc.Node,

        round_num : cc.Label,

        game_rule : cc.Prefab,

        game_steing :cc.Prefab,

        game_win : cc.Node,

        game_lose : cc.Node,


        _prefabs_list : null,

        _mAnimal_number : 0,
        _yAnimal_number : 0,

    },

    // LIFE-CYCLE CALLBACKS:

    onLoad () {

        this._prefabs_list = {game_rule : this.game_rule , game_steing: this.game_steing}

        //初始化地图显示
        this._game_map = cc.find("Canvas/game_map");
        //1 ： 地面   2：水面  3： 笼子 4 ：星星 5 :可移动光圈 11： 老鼠   12：猫  13：狗 14 ：狼   15： 豹子   16 ：老虎  17： 狮子  20：大象  敌方动物 * 10
        this.map_list = [
                    [170,1,3,4,3,1,160],
                    [1,130,1,3,1,120,1],
                    [110,1,150,1,140,1,200],
                    [1,2,2,1,2,2,1],
                    [1,2,2,1,2,2,1],
                    [1,2,2,1,2,2,1],
                    [20,1,14,1,15,1,11],
                    [1,12,1,3,1,13,1],
                    [16,1,3,4,3,1,17],
        ]
        //建筑物位置备份
        this.map_Animal_list = [
            [1,1,3,4,3,1,1],
            [1,1,1,3,1,1,1],
            [1,1,1,1,1,1,1],
            [1,2,2,1,2,2,1],
            [1,2,2,1,2,2,1],
            [1,2,2,1,2,2,1],
            [1,1,1,1,1,1,1],
            [1,1,1,3,1,1,1],
            [1,1,3,4,3,1,1],
        ]

        this._mAnimal_number = 8;
        this._yAnimal_number = 8;


        //不管是单人模式 还是双人模式，由当前玩家先走
        for(var i = 0 ; i < this.map_list.length; i++)
        {
            for(var j = 0 ; j < this.map_list[i].length; j++)
            {
                this._game_map.children[i * this.map_list[i].length + j].getComponent("role_show").show(this.map_list[i][j],new cc.v2(i,j));
            }
        }
        this.posend = {1 : new cc.v2(8,3), 2 : new cc.v2(0,3)};

        //修改当前回合数
        this.Currentround = 1;
        
        //修改当前自己回合
        this.Isround = true;
        this.setIsround();

        //cc.Pattern = 2
        this.round_num.string = this.Currentround;

    },

    start () {

    },

    //修改当前回合显示
    setIsround()
    {
        this.Mround.active = this.Isround;
        this.Yround.active = !this.Isround;
    },

    //地图点击事件
    map_click(btn,data)
    {
        cc.rtData.AudioMgr.playComBtnClickSfx();
        if(data == -1)
        {
            this.CloseQuan();
            return ;
        }
        var btnobj = btn.target.getComponent("role_show");
        this.role_move(btnobj._mark,btnobj._pos);
        cc.log(btnobj);
    },

    //判断点击的物品可移动的位置
    role_move(role,pos)
    {
        //记录当前点击动物位置
        if(role > 10)
        {
            if(this._cilckPos == pos)
            {
                var iscolse = this.CloseQuan();
                if(iscolse)
                {
                    return;
                }
            }
            else
            {
                this.CloseQuan();
            }
            this._cilckPos = pos;
        }
        switch(role)
        {
            case 5:
                this.Sure_move(pos,role);
                break;
            case 11 :
            case 110 :
                this.Mouse_move(pos,role);
                break;
            case 12 :
            case 120 :
                this.cat_move(pos,role);
                break;
            case 13 :
            case 130 :
                this.dog_move(pos,role);
                break;
            case 14 :
            case 140 :
                this.wolf_move(pos,role);
                break;
            case 15 :
            case 150 :
                this.leopard_move(pos,role);
                break;
            case 16 :
            case 160 :
                this.Tiger_move(pos,role);
                break;
            case 17 :
            case 170 :
                this.Lion_move(pos,role);
                break;
            case 20 :
            case 200 :
                this.Elephant_move(pos,role);
                break;
        }
    },
    //关闭移动光圈显示
    CloseQuan()
    {
        if(this.quan_list.length == 0)
        {
            return false;
        }
        for(var i = 0 ; i <  this.quan_list.length; i++)
        {
            this._game_map.children[this.quan_list[i].x * this.map_list[this.quan_list[i].x].length + this.quan_list[i].y].getComponent("role_show").move_show(false);
        }
        //清空数组
        this.quan_list = [];
        return true;
    },
    //遍历敌方还存在的动物 并返回对象
    lookupAnimal()
    {
        var list = [];
        //不管是单人模式 还是双人模式，由当前玩家先走
        for(var i = 0 ; i < this.map_list.length; i++)
        {
            for(var j = 0 ; j < this.map_list[i].length; j++)
            {
                if(this.map_list[i][j] > 100)
                {
                    list[list.length] = this._game_map.children[i * this.map_list[i].length + j].getComponent("role_show");
                }
            }
        }
        return list;
    },
    //遍历已方还存在的动物
    lookup_U_Animal()
    {
        var list = [];
        //不管是单人模式 还是双人模式，由当前玩家先走
        for(var i = 0 ; i < this.map_list.length; i++)
        {
            for(var j = 0 ; j < this.map_list[i].length; j++)
            {
                if(this.map_list[i][j] > 10 && this.map_list[i][j] < 100)
                {
                    list[list.length] = this._game_map.children[i * this.map_list[i].length + j].getComponent("role_show");
                }
            }
        }
        return list;
    },

    //执行可以移动
    Sure_move(pos)
    {
        //移动结束后先关闭光圈显示
        this.CloseQuan();

        //获取当前步地图标识
        var amis = this._game_map.children[ this._cilckPos.x * this.map_list[ this._cilckPos.x].length +  this._cilckPos.y].getComponent("role_show")._mark;

       
        //获取下一步地图标识
        var tempmark = this._game_map.children[pos.x * this.map_list[pos.x].length + pos.y].getComponent("role_show")._mark;

        if(tempmark > 10)
        {
            this._game_map.children[pos.x * this.map_list[pos.x].length + pos.y].getComponent("role_show").open_boom();
        }
        
        if(amis > 10)
        {
            var am = amis > 100 ? amis / 10 : amis;
            cc.rtData.AudioMgr.playSFX("Sound/zoon_" + am+".mp3");
        }

        this.map_list[pos.x][pos.y] = amis;
        this.map_list[ this._cilckPos.x][ this._cilckPos.y] = this.map_Animal_list[this._cilckPos.x][this._cilckPos.y];


        //修改去下一步的标识   
        this._game_map.children[pos.x * this.map_list[pos.x].length + pos.y].getComponent("role_show").OpenData(amis);
        //修改当前步的标识
        this._game_map.children[ this._cilckPos.x * this.map_list[ this._cilckPos.x].length +  this._cilckPos.y].getComponent("role_show").Colsedata(tempmark);

        //标识修改完毕后，判断是否胜利条件
        var lis = this.lookupAnimal();  //遍历敌方动物
        var mlist = this.lookup_U_Animal();//遍历已方动物
        //游戏胜利判断   如果没有敌方怪物了，就是我方胜利了
        if(cc.rtData.Pattern == 2)
        {
            if(lis.length == 0)
            {
               this.game_win.active = true;
               this.game_win.getComponent("game_win").show(this.Currentround,mlist.length,lis.length -  this._yAnimal_number,1);
            }
            else if(mlist == 0)
            {
                this.game_win.active = true;
                this.game_win.getComponent("game_win").show(this.Currentround,lis.length,mlist.length - this._mAnimal_number,2);
            }
        }
        else
        {
            if(lis.length == 0)
            {
               this.game_win.active = true;
               this.game_win.getComponent("game_win").show(this.Currentround,mlist.length,lis.length - this._yAnimal_number);
            }
            else if(mlist == 0)
            {
                this.game_lose.active = true;
            }
        }
        //游戏胜利判断， 判断动物是否达到目标点   已方判断
        if(pos.x == this.posend[2].x && pos.y ==this.posend[2].y  && this.Isround)
        {
            this.game_win.active = true;
            this.game_win.getComponent("game_win").show(this.Currentround,mlist.length,lis.length - this._yAnimal_number);
        }
        else if(pos.x == this.posend[1].x && pos.y ==this.posend[1].y  && !this.Isround)
        {
            this.game_lose.active = true;
        }


        //根据回合关闭玩家可点击事件
        this.Isround = !this.Isround

       

        this.setIsround();

        if(!this.Isround)
        {
            if(cc.rtData.Pattern == 1)
            {

                this.scheduleOnce(function() {
                    // 这里的 this 指向 component
                    var number =  parseInt(Math.random() *100) %  lis.length;

                    this.role_move(lis[number]._mark,lis[number]._pos);
                    
                    var pos =  parseInt(Math.random() * 100) %  this.quan_list.length;
     
                    this.Sure_move(new cc.v2(this.quan_list[pos]));
                    
                }.bind(this), 0.5);

            }
            else
            {
                this.OpenCilck(true,this.Isround)
            }
        }
        else
        {
            //修改当前回合数
            this.Currentround++;
            this.round_num.string = this.Currentround;
            this.OpenCilck(false,this.Isround)
        }
    },
    //根据玩法打开玩家的可点击事件
    OpenCilck(type,Isround)
    {;
        for(var i = 0 ; i < this.map_list.length; i++)
        {
            for(var j = 0 ; j < this.map_list[i].length; j++)
            {
                
                    if(this.map_list[i][j] > 100)
                    {
                        this._game_map.children[i * this.map_list[i].length + j].getComponent("role_show").OpenCilck(type);
                    }
               
                    if(this.map_list[i][j] > 10 && this.map_list[i][j] < 100)
                    {
                        this._game_map.children[i * this.map_list[i].length + j].getComponent("role_show").OpenCilck(this.Isround);
                    }
            }
        }
    },



    //打开可移动光圈显示
    open_move(pos,type)
    {
        if(type == 0)
        {
            return;
        }
        type  = type == 1 ? true : false;
        if(type)
        {
            this.quan_list[this.quan_list.length] = pos;
        }
        this._game_map.children[pos.x * this.map_list[pos.x].length + pos.y].getComponent("role_show").move_show(type);
    },
    //判断星星是否能踩
    xingxing_judge(data,pos)
    {
        
        if(this.Isround)
        {
            if(pos.x == this.posend[2].x && pos.y ==this.posend[2].y )
            {
                return 1;
            }
            else
            {
                return 0;
            }
        }
        else
        {
            if(pos.x == this.posend[1].x && pos.y ==this.posend[1].y )
            {
                return 1;
            }
            else
            {
                return 0;
            }
        }

        
    },
    Mouse_judge(pos,role,pros,targetpos)
    {
        if(role > 100 && pos < 100)
        {
            role = role / 10;
        }
        else if(pos > 100 && role < 100)
        {
            pos = pos /10;
        }
        else if(pos > 100 && role > 100 || (pos > 10 && role > 10))
        {
            return 0;
        }

        if(pos == null)
        {
            return 0;
        }
        if(pos == 4)
        {
            var obj = this.xingxing_judge(pos,targetpos);
            return obj;
        }

        if(this.map_Animal_list[targetpos.x][targetpos.y] == 3)
        {
            return 1
        }
        
        if(pos < role + 1 || ( pos == 20 &&  this.map_Animal_list[pros.x][pros.y] != 2 ))
        {
            return 1;
        }
        else
        {
            return 0;
        }
    },

    dog_judge(pos,role,pros,targetpos)
    {
        if(role > 100 && pos < 100)
        {
            role = role / 10;
        }
        else if(pos > 100 && role < 100)
        {
            pos = pos /10;
        }
        else if(pos > 100 && role > 100 || (pos > 10 && role > 10))
        {
            return 0;
        }

        if(pos == null)
        {
            return 0;
        }
        var number = this.map_Animal_list[targetpos.x][targetpos.y];
        if(number == 3)
        {
            return 1
        }
        
        if(pos < role + 1 && pos != 2)
        {
            return 1;
        }
        else
        {
            return 0;
        }
    },
    Lion_judge(pos,role,pros,targetpos)
    {
        if(role > 100 && pos < 100)
        {
            role = role / 10;
        }
        else if(pos > 100 && role < 100)
        {
            pos = pos /10;
        }
        else if(pos > 100 && role > 100 || (pos > 10 && role > 10))
        {
            return 0;
        }

        if(pos == null)
        {
            return 0;
        }
        if(this.map_Animal_list[targetpos.x][targetpos.y] == 3)
        {
            return 1
        }
        
        if(pos < role + 1)
        {
            return 1;
        }
        else
        {
            return 0;
        }
    },
    Elephant_judge(pos,role,pros,targetpos)
    {
        if(role > 100 && pos < 100)
        {
            role = role / 10;
        }
        else if(pos > 100 && role < 100)
        {
            pos = pos /10;
        }
        else if(pos > 100 && role > 100 || (pos > 10 && role > 10))
        {
            return 0;
        }

        if(pos == null)
        {
            return 0;
        }

        if(this.map_Animal_list[targetpos.x][targetpos.y] == 3)
        {
            return 1
        }
        
        
        if(pos < role + 1  && pos != 2)
        {
            if(pos == 11)
            {
                return 0;
            }
            return 1;
        }
        else
        {
            return 0;
        }
    },
    Animal_Move(pos,type,role){

        var func = null;
        if(type == 1)
        {
            func = this.Mouse_judge.bind(this);
        }
        else if( type == 2)
        {
            func = this.dog_judge.bind(this);
        }
        else  if( type == 3)
        {
            func = this.Lion_judge.bind(this);
        }
        else if(type == 4)
        {
            func = this.Elephant_judge.bind(this);
        }

        //下边位置判断
        if(pos.x + 1 < this.map_list.length)
        {
            var temp = this.map_list[pos.x + 1][pos.y];
            var temppos = new cc.v2(pos.x + 1,pos.y)

            if(type == 3)
            {
                if(temp == 2)
                {
                    var henumber = 0;
                    //判断地形，河有多长
                    for(var i = 0; i < this.map_Animal_list[i].length;i++)
                    {
                        if(this.map_Animal_list[temppos.x + i][temppos.y] == 2)
                        {
                            henumber++;
                        }
                        else
                        {
                            break;
                        }
                    }
                    var zangnumber = 0;
                    //遍历这条河道中间是否有障碍物
                    for(var i = 0; i < henumber; i++)
                    {
                        if(this.map_list[temppos.x + i][temppos.y] == 2)
                        {
                            zangnumber++;
                        }
                        else
                        {
                            break;
                        }
                    }
                    if(zangnumber != henumber)
                    {
                        this.open_move(temppos,0);
                    }
                    else
                    {
                         //判断这条河道终点的动物 是否战斗力比当前动物高
                        temp = this.map_list[temppos.x + henumber][temppos.y];
                        temppos = new cc.v2(temppos.x  + henumber,temppos.y)
                        this.open_move(temppos,func(temp,role,pos,temppos));
                    }
                }
                else
                {
                    this.open_move(temppos,func(temp,role,pos,temppos));
                }
            }
            else
            {
                this.open_move(temppos,func(temp,role,pos,temppos));
            }
        }

        //上边位置判断
        if(pos.x - 1 > -1)
        {
            var temp = this.map_list[pos.x - 1][pos.y];
            var temppos = new cc.v2(pos.x - 1,pos.y)
            
            if(type == 3)
            {
                if(temp == 2)
                {
                    var henumber = 0;
                    //判断地形，河有多长
                    for(var i = 0; i < this.map_Animal_list[i].length;i++)
                    {
                        if(this.map_Animal_list[temppos.x - i][temppos.y] == 2)
                        {
                            henumber++;
                        }
                        else
                        {
                            break;
                        }
                    }
                    var zangnumber = 0;
                    //遍历这条河道中间是否有障碍物
                    for(var i = 0; i < henumber; i++)
                    {
                        if(this.map_list[temppos.x - i][temppos.y] == 2)
                        {
                            zangnumber++;
                        }
                        else
                        {
                            break;
                        }
                    }
                    if(zangnumber != henumber)
                    {
                        this.open_move(temppos,0);
                    }
                    else
                    {
                         //判断这条河道终点的动物 是否战斗力比当前动物高
                        temp = this.map_list[temppos.x - henumber][temppos.y];
                        temppos = new cc.v2(temppos.x  - henumber,temppos.y)
                        this.open_move(temppos,func(temp,role,pos,temppos));
                    }
                }
                else
                {
                    this.open_move(temppos,func(temp,role,pos,temppos));
                }
            }
            else
            {
                this.open_move(temppos,func(temp,role,pos,temppos));
            }
        }

        //左边位置判断
        if(pos.y + 1 < this.map_list[pos.x].length)
        {
            var temp = this.map_list[pos.x][pos.y + 1];
            var temppos = new cc.v2(pos.x,pos.y + 1)
            
            if(type == 3)
            {
                if(temp == 2)
                {
                    var henumber = 0;
                    //判断地形，河有多长
                    for(var i = 0; i < this.map_Animal_list[i].length;i++)
                    {
                        if(this.map_Animal_list[temppos.x][temppos.y + i] == 2)
                        {
                            henumber++;
                        }
                        else
                        {
                            break;
                        }
                    }
                    var zangnumber = 0;
                    //遍历这条河道中间是否有障碍物
                    for(var i = 0; i < henumber; i++)
                    {
                        if(this.map_list[temppos.x][temppos.y + i] == 2)
                        {
                            zangnumber++;
                        }
                        else
                        {
                            break;
                        }
                    }
                    if(zangnumber != henumber)
                    {
                        this.open_move(temppos,0);
                    }
                    else
                    {
                         //判断这条河道终点的动物 是否战斗力比当前动物高
                        temp = this.map_list[temppos.x ][temppos.y + henumber];
                        temppos = new cc.v2(temppos.x  ,temppos.y + henumber)
                        this.open_move(temppos,func(temp,role,pos,temppos));
                    }
                }
                else
                {
                    this.open_move(temppos,func(temp,role,pos,temppos));
                }
            }
            else
            {
                this.open_move(temppos,func(temp,role,pos,temppos));
            }
        }

        //右边位置判断
        if(pos.y - 1 > -1)
        {
            var temp = this.map_list[pos.x][pos.y - 1];
            var temppos = new cc.v2(pos.x,pos.y - 1)
            
            if(type == 3)
            {
                if(temp == 2)
                {
                    var henumber = 0;
                    //判断地形，河有多长
                    for(var i = 0; i < this.map_Animal_list[i].length;i++)
                    {
                        if(this.map_Animal_list[temppos.x][temppos.y - i] == 2)
                        {
                            henumber++;
                        }
                        else
                        {
                            break;
                        }
                    }
                    var zangnumber = 0;
                    //遍历这条河道中间是否有障碍物
                    for(var i = 0; i < henumber; i++)
                    {
                        if(this.map_list[temppos.x][temppos.y - i] == 2)
                        {
                            zangnumber++;
                        }
                        else
                        {
                            break;
                        }
                    }
                    if(zangnumber != henumber)
                    {
                        this.open_move(temppos,0);
                    }
                    else
                    {
                         //判断这条河道终点的动物 是否战斗力比当前动物高
                        temp = this.map_list[temppos.x ][temppos.y - henumber];
                        temppos = new cc.v2(temppos.x  ,temppos.y - henumber)
                        this.open_move(temppos,func(temp,role,pos,temppos));
                    }
                }
                else
                {
                    this.open_move(temppos,func(temp,role,pos,temppos));
                }
            }
            else
            {
                this.open_move(temppos,func(temp,role,pos,temppos));
            }
        }
    },
    Mouse_move(pos,role)
    {
        this.Animal_Move(pos,1,role);
    },
    cat_move(pos,role)
    {
        this.Animal_Move(pos,2,role);
    },
    dog_move(pos,role)
    {
        this.Animal_Move(pos,2,role);
    },
    wolf_move(pos,role)
    {
        this.Animal_Move(pos,2,role);
    },
    leopard_move(pos,role)
    {
        this.Animal_Move(pos,2,role);
    },
    Tiger_move(pos,role)
    {
        this.Animal_Move(pos,3,role);
    },
    Lion_move(pos,role)
    {
        this.Animal_Move(pos,3,role);
    },
    Elephant_move(pos,role)
    {
        this.Animal_Move(pos,4,role);
    },


    btn_onCilck(btn,data)
    {
        cc.rtData.AudioMgr.playComBtnClickSfx();
        var obj =  cc.instantiate(this._prefabs_list[data]);
        cc.find("Canvas/uiNode").addChild(obj);
    },

    onCilck()
    {
        cc.rtData.AudioMgr.playComBtnClickSfx();
        this.node.destroy();
    },
    

    // update (dt) {},
});
