// Learn cc.Class:
//  - [Chinese] http://docs.cocos.com/creator/manual/zh/scripting/class.html
//  - [English] http://www.cocos2d-x.org/docs/creator/en/scripting/class.html
// Learn Attribute:
//  - [Chinese] http://docs.cocos.com/creator/manual/zh/scripting/reference/attributes.html
//  - [English] http://www.cocos2d-x.org/docs/creator/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - [Chinese] http://docs.cocos.com/creator/manual/zh/scripting/life-cycle-callbacks.html
//  - [English] http://www.cocos2d-x.org/docs/creator/en/scripting/life-cycle-callbacks.html

cc.Class({
    extends: cc.Component,

    properties: {
        // foo: {
        //     // ATTRIBUTES:
        //     default: null,        // The default value will be used only when the component attaching
        //                           // to a node for the first time
        //     type: cc.SpriteFrame, // optional, default is typeof default
        //     serializable: true,   // optional, default is true
        // },
        // bar: {
        //     get () {
        //         return this._bar;
        //     },
        //     set (value) {
        //         this._bar = value;
        //     }
        // },

        animationNode : cc.Node,

        game_rule : cc.Prefab,

        game_steing :cc.Prefab,

        anima_start_list : [], //动画开始位置列表
        anima_end_list : [], //动画结束位置列表

        _prefabs_list :null,
    },

    // LIFE-CYCLE CALLBACKS:

    onLoad () {
        this.anima_start_list = [{x:247,y:305},{x:-255,y:325},{x:-252,y:254},{x:97,y:243},{x:230,y:225},{x:-159,y:224},{x:210,y:311},{x:-56,y:261}]
        for(var i = 0; i < this.animationNode.children.length - 1; i ++)
        {
            //记录初始位置
            this.anima_end_list[this.anima_end_list.length] = new cc.v2(this.animationNode.children[i].x,this.animationNode.children[i].y);
            this.animationNode.children[i].position = this.anima_start_list[i];
        }

        this._prefabs_list = {game_rule : this.game_rule , game_steing: this.game_steing}


        //初始化设置所需要的数据
        cc.rtData = {};
        cc.rtData.zd = cc.sys.localStorage.getItem('game_zd') == null || cc.sys.localStorage.getItem('game_zd') == 1 ? true : false;
        cc.rtData.yy = cc.sys.localStorage.getItem('game_yy') == null || cc.sys.localStorage.getItem('game_yy') == 1 ? true : false;
        cc.rtData.yx = cc.sys.localStorage.getItem('game_yx') == null || cc.sys.localStorage.getItem('game_yx') == 1 ? true : false;

        //初始化播放音效方法
        var tAudioMgr = require("AudioMgr");
        cc.rtData.AudioMgr = new tAudioMgr();
        cc.rtData.AudioMgr.playBGM("Sound/bgm.mp3");


        if(!cc.rtData.yy)
        {
            cc.rtData.AudioMgr.setBGMVolume(0)
        }

        if(!cc.rtData.yx)
        {
            cc.rtData.AudioMgr.setSFXVolume(0)
        }
    },

    start () {
        //给所有动物播放一个动画效果
        for(var i = 0; i < this.animationNode.children.length - 1; i ++)
        {
            this.animationNode.children[i].runAction(cc.sequence(
                
                    cc.moveTo(0.2,this.anima_end_list[i]),
                    cc.scaleTo(0.1,1.2),
                    cc.scaleTo(0.1,1)
                    )
            )
                
        }
    },

    game_click_start(btn,data)
    {
        cc.rtData.AudioMgr.playComBtnClickSfx();
        cc.rtData.Pattern = parseInt(data);
        cc.director.loadScene("game_in");
    },

    btn_onCilck(btn,data)
    {
        cc.rtData.AudioMgr.playComBtnClickSfx();
        var obj =  cc.instantiate(this._prefabs_list[data]);
        cc.find("Canvas/uiNode").addChild(obj);
    },

    // update (dt) {},
});
