cc.Class({
    extends: cc.Component,

    properties: {

        AnimalAtlis : cc.SpriteAtlas, //显示动物所需要图集

        AnimalNode : cc.Node,
        AnimalBG_Node : cc.Node,

        AnimalMove : cc.Node,

        NomoveNode : cc.Node, //不可移动图片

        game_bool : cc.Node,


       
        _pos : null, //当前地图位置

        _mark : null , //当前标识
        _marf_backups : 1, //备份当前标识
    },

    // LIFE-CYCLE CALLBACKS:

    // onLoad () {},

    start () {
        this.game_bool.getComponent(cc.Animation).on('stop',this.open_boom_end,this);
    },

    //移动光圈图标开关
    move_show(type)
    {
        if(type)
        {
            if(this._mark != 5)
            {
                this._marf_backups = this._mark;
                this._mark = 5
            }
        }
        else
        {
            this._mark = this._marf_backups ;
            this._marf_backups = null;

        }
        this.AnimalMove.active = type;
        //并且打开当前点击事件
        this.node.getComponent(cc.Button).interactable = type;

    },

    show(ground,pos)
    {
        //大于10 就是动物类  小于10 就是地图
        this._mark = ground;
        this._pos = pos;
       
        if(ground > 10)
        {
            this.AnimalBG_Node.parent.active = true;
            this.NomoveNode.active = false;
            this.node.getComponent(cc.Button).interactable = true;
            if(ground > 100)
            {
                this.node.getComponent(cc.Button).interactable = false;
            }
            this.AnimalNode.getComponent(cc.Sprite).spriteFrame = this.AnimalAtlis.getSpriteFrame(ground);

        }
        else if(ground < 10)
        {

            this.AnimalBG_Node.parent.active = false;
            this.NomoveNode.active = true;
            this.node.getComponent(cc.Button).interactable = false;
            this.NomoveNode.getComponent(cc.Sprite).spriteFrame = this.AnimalAtlis.getSpriteFrame(ground);
        }
    },
    //打开当前动物点击事件
    OpenCilck(type)
    {
        this.node.getComponent(cc.Button).interactable = type;
    },
    
    //修改当前标识，并关闭动物显示
    Colsedata(mark)
    {
        this.AnimalBG_Node.parent.active = false;
        this.NomoveNode.active = true;
        this.AnimalNode.active = false;
        //关闭按钮触发
        this.node.getComponent(cc.Button).interactable = false;
        this._mark = mark;
        this._marf_backups = 1;
    },
    //当前单元格变成动物标识
    OpenData(mark)
    {
        this.AnimalBG_Node.parent.active = true;
        this.AnimalNode.active = true;
        this.AnimalNode.getComponent(cc.Sprite).spriteFrame = this.AnimalAtlis.getSpriteFrame(mark);
        this._mark = mark;
        //关闭按钮触发
        this.node.getComponent(cc.Button).interactable = true;
        this._marf_backups = 1;
    },

    //当前爆炸效果
    open_boom()
    {
        this.game_bool.active = true;
        this.game_bool.getComponent(cc.Animation).play();
    },
    open_boom_end()
    {
        this.game_bool.active = false;
    },

    

    // update (dt) {},
});
