"use strict";
cc._RF.push(module, 'ce8e4R+bwFC9pw1FaHy7VQe', 'mirror');
// src/mirror.js

"use strict";

// Learn cc.Class:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/class.html
//  - [English] http://docs.cocos2d-x.org/creator/manual/en/scripting/class.html
// Learn Attribute:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/reference/attributes.html
//  - [English] http://docs.cocos2d-x.org/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/life-cycle-callbacks.html
//  - [English] https://www.cocos2d-x.org/docs/creator/manual/en/scripting/life-cycle-callbacks.html

cc.Class({
    extends: cc.Component,

    properties: {
        camera: {
            default: null,
            type: cc.Camera
        },
        mirror: {
            default: null,
            type: cc.Sprite
        }
    },

    start: function start() {
        var texture = new cc.RenderTexture();
        texture.initWithSize(this.mirror.node.width, this.mirror.node.height);
        var spriteFrame = new cc.SpriteFrame();
        spriteFrame.setTexture(texture);
        this.mirror.spriteFrame = spriteFrame;
        this.camera.targetTexture = texture;
    }
});

cc._RF.pop();