(function() {"use strict";var __module = CC_EDITOR ? module : {exports:{}};var __filename = 'preview-scripts/assets/Script/MKSound.js';var __require = CC_EDITOR ? function (request) {return cc.require(request, require);} : function (request) {return cc.require(request, __filename);};function __define (exports, require, module) {"use strict";
cc._RF.push(module, '965ee795rJBlqQakZdUqFP7', 'MKSound', __filename);
// Script/MKSound.ts

Object.defineProperty(exports, "__esModule", { value: true });
var MKSound = /** @class */ (function () {
    function MKSound() {
        // var t = cc.sys.localStorage.getItem("bgmVolume");
        // if(t != null){
        //     this.bgmVolume = parseFloat(t);    
        // }
        // var t = cc.sys.localStorage.getItem("sfxVolume");
        // if(t != null){
        //     this.sfxVolume = parseFloat(t);    
        // }
        cc.game.on(cc.game.EVENT_HIDE, function () {
            console.log("cc.audioEngine.pauseAll");
            cc.audioEngine.pauseAll();
        });
        cc.game.on(cc.game.EVENT_SHOW, function () {
            console.log("cc.audioEngine.resumeAll");
            cc.audioEngine.resumeAll();
        });
    }
    /**
     * 转化地址
     * @param url
     */
    MKSound.getUrl = function (url) {
        return cc.url.raw("resources/sounds/" + url);
    };
    /**
     * 播放背景音乐
     * @param url
     */
    MKSound.playBGM = function (audioUrl) {
        // var audioUrl = this.getUrl(url);
        // console.log(audioUrl);
        if (this.bgmAudioID >= 0) {
            cc.audioEngine.stop(this.bgmAudioID);
        }
        this.bgmAudioID = cc.audioEngine.play(audioUrl, true, this.bgmVolume);
    };
    /**
     * 播放音效
     * @param url
     */
    MKSound.playSFX = function (audioUrl) {
        // var audioUrl = this.getUrl(url);
        if (this.sfxVolume > 0) {
            var audioId = cc.audioEngine.play(audioUrl, false, this.sfxVolume);
        }
    };
    MKSound.setSFXVolume = function (v) {
        if (this.sfxVolume != v) {
            cc.sys.localStorage.setItem("sfxVolume", v);
            this.sfxVolume = v;
        }
    };
    MKSound.setBGMVolume = function (v, force) {
        if (this.bgmAudioID >= 0) {
            if (v > 0) {
                cc.audioEngine.resume(this.bgmAudioID);
            }
            else {
                cc.audioEngine.pause(this.bgmAudioID);
            }
            cc.audioEngine.setVolume(this.bgmAudioID, this.bgmVolume);
        }
        if (this.bgmVolume != v || force) {
            cc.sys.localStorage.setItem("bgmVolume", v);
            this.bgmVolume = v;
            cc.audioEngine.setVolume(this.bgmAudioID, v);
        }
    };
    MKSound.pauseBGM = function () {
        cc.audioEngine.pause(this.bgmAudioID);
    };
    MKSound.resumeBGM = function () {
        cc.audioEngine.resume(this.bgmAudioID);
    };
    MKSound.bgmVolume = 1.0;
    MKSound.sfxVolume = 1.0;
    MKSound.bgmAudioID = -1;
    return MKSound;
}());
exports.default = MKSound;

cc._RF.pop();
        }
        if (CC_EDITOR) {
            __define(__module.exports, __require, __module);
        }
        else {
            cc.registerModuleFunc(__filename, function () {
                __define(__module.exports, __require, __module);
            });
        }
        })();
        //# sourceMappingURL=MKSound.js.map
        