
cc.Class({
    extends: cc.Component,

    properties: {
        sceneArr: [cc.Node],
    },

    onLoad() {
        this.touchOnce = true;   //是不是第一次点击屏幕
        this.dirstart = null;   //按住屏幕的初始坐标'
        this.dirend = null;     //手指离开屏幕的坐标
        cc.find("Canvas/bg").on("touchstart", this.onTouchStart, this);
        cc.find("Canvas/bg").on("touchend", this.onTouchEnd, this);
    },

    onTouchStart: function (e) {
        let location = e.getLocation();
        let node = cc.find("Canvas/bg");
        let pointInNode = node.convertToNodeSpaceAR(location);  //以参照物为锚点, 向右, 向上创建坐标系
        if (this.touchOnce) {
            //获取初始坐标
            this.dirstart = cc.v2(pointInNode.x, pointInNode.y);
            this. touchOnce = false;
        }
    },

    onTouchEnd: function (e) {
        this.touchOnce = true;
        let location = e.getLocation();
        let node = cc.find("Canvas/bg");
        let pointInNode = node.convertToNodeSpaceAR(location);
        //得到手指离开屏幕的位置坐标
        this.dirend = cc.v2(pointInNode.x, pointInNode.y);
        let endx = this.dirend.x;
        let endy = this.dirend.y;
        let startx = this.dirstart.x;
        let starty = this.dirstart.y;
        /**
         * 如果结束x < 起始x 就是向左, 反之向右
         * 如果结束y < 起始y 就是向下, 反之向上
         * 如果y的差值绝对值 > x的差值绝对值 就是向上或向下, 反之就是向左或向右
         */
        let chaX = endx - startx;
        let chaY = endy - starty;
        let jueX = Math.abs(chaX);
        let jueY = Math.abs(chaY);
        if (jueX <= 10 && jueY <= 10) { //防止误触
            if (startx < 225 && startx > -225 && starty < 225 && starty > -225) {
                this.gotoScene();
            }
            return;
        } else if (chaX<=0 && chaY>=0 && jueX<jueY) {
            //向上滑
            
        } else if (chaX<=0 && chaY>=0 && jueX>jueY) {
            //左滑
            this.leftAction(this.sceneArr);
        } else if (chaX>=0 && chaY>=0 && jueX<jueY) {
            //上滑
            
        } else if (chaX>=0 && chaY>=0 && jueX>jueY) {
            //右滑
            this.rightAction(this.sceneArr);
        } else if (chaX>=0 && chaY<=0 && jueX<jueY) {
            //下滑
            
        }else if (chaX>=0 && chaY<=0 && jueX>jueY) {
            //右滑
            this.rightAction(this.sceneArr);
        } else if (chaX<=0 && chaY<=0 && jueX<jueY) {
            //下滑
            
        } else if (chaX<=0 && chaY<=0 && jueX>jueY) {
            //左滑
            this.leftAction(this.sceneArr);
        }
    
    },

    //左划
    leftAction: function (nodeArr) {
        for (let i=0; i<nodeArr.length; i++) {
            if (nodeArr[i].x == -550) {
                var changex1 = cc.callFunc(function () {
                    nodeArr[i].x = 360;
                })
                var myAction1 = cc.sequence(cc.moveTo(0.1, cc.v2(-630, 0)), changex1, cc.moveTo(0.1, cc.v2(280, 0)));
                nodeArr[i].runAction(myAction1);
            } else if (nodeArr[i].x == -225) {
                var myAction2 = cc.spawn(cc.moveTo(0.2, cc.v2(-550, 0)), cc.scaleBy(0.2, 0.6));
                nodeArr[i].runAction(myAction2);
            } else if (nodeArr[i].x == 280) {
                var myAction3 = cc.spawn(cc.moveTo(0.2, cc.v2(-225, 0)), cc.scaleBy(0.2, 1.67));
                nodeArr[i].runAction(myAction3);
            }
        }
    },

    //右滑
    rightAction: function (nodeArr) {
        for(let i=0; i<nodeArr.length; i++) {
            if (nodeArr[i].x == -550) {
                var myAction1 = cc.spawn(cc.moveTo(0.2, cc.v2(-225, 0)), cc.scaleBy(0.2, 1.67));
                nodeArr[i].runAction(myAction1);
            } else if (nodeArr[i].x == -225) {
                var myAction2 = cc.spawn(cc.moveTo(0.2, cc.v2(280, 0)), cc.scaleBy(0.2, 0.6));
                nodeArr[i].runAction(myAction2);
            } else if (nodeArr[i].x == 280) {
                var changex2 = cc.callFunc(function () {
                    nodeArr[i].x = -630;
                })
                var myAction3 = cc.sequence(cc.moveTo(0.1, cc.v2(360, 0)), changex2, cc.moveTo(0.1, cc.v2(-550, 0)));
                nodeArr[i].runAction(myAction3);
            }
        }
    },
});
