(function() {"use strict";var __module = CC_EDITOR ? module : {exports:{}};var __filename = 'preview-scripts/assets/game.js';var __require = CC_EDITOR ? function (request) {return cc.require(request, require);} : function (request) {return cc.require(request, __filename);};function __define (exports, require, module) {"use strict";
cc._RF.push(module, 'bbad27NVjNEwqF+3HYWrK0R', 'game', __filename);
// game.js

"use strict";

cc.Class({
    extends: cc.Component,

    properties: {
        sceneArr: [cc.Node]
    },

    onLoad: function onLoad() {
        this.touchOnce = true; //是不是第一次点击屏幕
        this.dirstart = null; //按住屏幕的初始坐标'
        this.dirend = null; //手指离开屏幕的坐标
        cc.find("Canvas/bg").on("touchstart", this.onTouchStart, this);
        cc.find("Canvas/bg").on("touchend", this.onTouchEnd, this);
    },


    onTouchStart: function onTouchStart(e) {
        var location = e.getLocation();
        var node = cc.find("Canvas/bg");
        var pointInNode = node.convertToNodeSpaceAR(location); //以参照物为锚点, 向右, 向上创建坐标系
        if (this.touchOnce) {
            //获取初始坐标
            this.dirstart = cc.v2(pointInNode.x, pointInNode.y);
            this.touchOnce = false;
        }
    },

    onTouchEnd: function onTouchEnd(e) {
        this.touchOnce = true;
        var location = e.getLocation();
        var node = cc.find("Canvas/bg");
        var pointInNode = node.convertToNodeSpaceAR(location);
        //得到手指离开屏幕的位置坐标
        this.dirend = cc.v2(pointInNode.x, pointInNode.y);
        var endx = this.dirend.x;
        var endy = this.dirend.y;
        var startx = this.dirstart.x;
        var starty = this.dirstart.y;
        /**
         * 如果结束x < 起始x 就是向左, 反之向右
         * 如果结束y < 起始y 就是向下, 反之向上
         * 如果y的差值绝对值 > x的差值绝对值 就是向上或向下, 反之就是向左或向右
         */
        var chaX = endx - startx;
        var chaY = endy - starty;
        var jueX = Math.abs(chaX);
        var jueY = Math.abs(chaY);
        if (jueX <= 10 && jueY <= 10) {
            //防止误触
            if (startx < 225 && startx > -225 && starty < 225 && starty > -225) {
                this.gotoScene();
            }
            return;
        } else if (chaX <= 0 && chaY >= 0 && jueX < jueY) {
            //向上滑

        } else if (chaX <= 0 && chaY >= 0 && jueX > jueY) {
            //左滑
            this.leftAction(this.sceneArr);
        } else if (chaX >= 0 && chaY >= 0 && jueX < jueY) {
            //上滑

        } else if (chaX >= 0 && chaY >= 0 && jueX > jueY) {
            //右滑
            this.rightAction(this.sceneArr);
        } else if (chaX >= 0 && chaY <= 0 && jueX < jueY) {
            //下滑

        } else if (chaX >= 0 && chaY <= 0 && jueX > jueY) {
            //右滑
            this.rightAction(this.sceneArr);
        } else if (chaX <= 0 && chaY <= 0 && jueX < jueY) {
            //下滑

        } else if (chaX <= 0 && chaY <= 0 && jueX > jueY) {
            //左滑
            this.leftAction(this.sceneArr);
        }
    },

    //左划
    leftAction: function leftAction(nodeArr) {
        var _loop = function _loop(i) {
            if (nodeArr[i].x == -550) {
                changex1 = cc.callFunc(function () {
                    nodeArr[i].x = 360;
                });
                myAction1 = cc.sequence(cc.moveTo(0.1, cc.v2(-630, 0)), changex1, cc.moveTo(0.1, cc.v2(280, 0)));

                nodeArr[i].runAction(myAction1);
            } else if (nodeArr[i].x == -225) {
                myAction2 = cc.spawn(cc.moveTo(0.2, cc.v2(-550, 0)), cc.scaleBy(0.2, 0.6));

                nodeArr[i].runAction(myAction2);
            } else if (nodeArr[i].x == 280) {
                myAction3 = cc.spawn(cc.moveTo(0.2, cc.v2(-225, 0)), cc.scaleBy(0.2, 1.67));

                nodeArr[i].runAction(myAction3);
            }
        };

        for (var i = 0; i < nodeArr.length; i++) {
            var changex1;
            var myAction1;
            var myAction2;
            var myAction3;

            _loop(i);
        }
    },

    //右滑
    rightAction: function rightAction(nodeArr) {
        var _loop2 = function _loop2(i) {
            if (nodeArr[i].x == -550) {
                myAction1 = cc.spawn(cc.moveTo(0.2, cc.v2(-225, 0)), cc.scaleBy(0.2, 1.67));

                nodeArr[i].runAction(myAction1);
            } else if (nodeArr[i].x == -225) {
                myAction2 = cc.spawn(cc.moveTo(0.2, cc.v2(280, 0)), cc.scaleBy(0.2, 0.6));

                nodeArr[i].runAction(myAction2);
            } else if (nodeArr[i].x == 280) {
                changex2 = cc.callFunc(function () {
                    nodeArr[i].x = -630;
                });
                myAction3 = cc.sequence(cc.moveTo(0.1, cc.v2(360, 0)), changex2, cc.moveTo(0.1, cc.v2(-550, 0)));

                nodeArr[i].runAction(myAction3);
            }
        };

        for (var i = 0; i < nodeArr.length; i++) {
            var myAction1;
            var myAction2;
            var changex2;
            var myAction3;

            _loop2(i);
        }
    }
});

cc._RF.pop();
        }
        if (CC_EDITOR) {
            __define(__module.exports, __require, __module);
        }
        else {
            cc.registerModuleFunc(__filename, function () {
                __define(__module.exports, __require, __module);
            });
        }
        })();
        //# sourceMappingURL=game.js.map
        