cc.Class({
    extends: cc.Component,

    properties: {
        ip: "47.52.144.123:8000",
        label: {
            default: null,
            type: cc.Label
        },
        // defaults, set visually when attaching this script to the Canvas
        text: 'Hello, World!'
    },

    // use this for initialization
    onLoad: function () {
        this.label.string = this.text;
    },

    update: function (dt) {

    },

    socketConnect() {
        var opts = {
            'reconnection': false,
            'force new connection': true
        };
        let url = "http://" + this.ip;

        cc.log("socket.io连接", url);
        this.label.string = "正在连接" + url;
        let sio = io.connect(url);
        sio.on('reconnect', function () {
            cc.log('reconnection');
        });
        sio.on('connect', (data) => {
            cc.log("连接成功");
            this.label.string = "连接成功";
        });

        sio.on('disconnect', (data) => {
            cc.log("连接断开");
            this.label.string = "连接断开";
        });

        sio.on('connect_failed', function (err) {
            console.log('connect_failed', JSON.stringify(err));
            this.label.string = "连接失败";
        });

        sio.on('connect_error', function (err) {
            console.log('connect_error', JSON.stringify(err));
            this.label.string = "连接错误";
        });

        sio.on('error', function (err) {
            console.log('error', JSON.stringify(err));
        });
    }
});
