import BaseComponent from "./base/BaseComponent";

const { ccclass, property, disallowMultiple } = cc._decorator;

@ccclass
@disallowMultiple
export default class SwitchScene extends cc.Component {

    @property
    sceneName: string = '';

    protected onLoad() {
        this.node.on(cc.Node.EventType.TOUCH_END, this.clickCallbackFunc, this);
    }

    public clickCallbackFunc() {
        // this.node.off(cc.Node.EventType.TOUCH_START);
        let sceneName = this.sceneName;
        cc.director.loadScene(sceneName, function () {
            console.log(`Switch current scene to ${sceneName}`)
        });
    }
}