const {ccclass, property} = cc._decorator;

@ccclass
export default class TestAABB extends cc.Component {
	
	private _circleCollider:cc.PhysicsCircleCollider;
	private _boxCollider:cc.PhysicsBoxCollider;
	
	protected onLoad():void{
		this.initPhysics();
	}
	
	private initPhysics():void{
		let physicsManager=cc.director.getPhysicsManager();
		physicsManager.enabled=true;
		physicsManager.debugDrawFlags=cc.PhysicsManager.DrawBits.e_shapeBit;
	}
	
	protected start():void{
		let circleNode=cc.find("Canvas/Circle");
		this._circleCollider=circleNode.getComponent(cc.PhysicsCircleCollider);
		
		let boxNode=cc.find("Canvas/Box");
		this._boxCollider=boxNode.getComponent(cc.PhysicsBoxCollider);
	}
	
	protected update(dt:number):void{
		cc.log("Circle:"+(this._circleCollider.getAABB().height.toFixed(2)), "Box:"+(this._boxCollider.getAABB().height.toFixed(2)) );
	}
   
}
